package net.mehvahdjukaar.every_compat.modules.forge.building_but_better;

import com.starfish_studios.bbb.block.*;
import com.starfish_studios.bbb.item.DescriptionBlockItem;
import com.starfish_studios.bbb.registry.BBBTags.BBBBlockTags;
import com.starfish_studios.bbb.registry.BBBTags.BBBItemTags;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.material.PushReaction;

import java.util.Objects;

// IMPORTANT:
// FABRIC version of this module is already included in the mod.

// The v1.1.1 is only available on Modrinth

//SUPPORT: v1.1.1+
public class BuildingButBetterModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> layers;
    public final SimpleEntrySet<WoodType, Block> trims;
    public final SimpleEntrySet<WoodType, Block> beams;
    public final SimpleEntrySet<WoodType, Block> beamStairs;
    public final SimpleEntrySet<WoodType, Block> beamSlabs;
    public final SimpleEntrySet<WoodType, Block> supports;
    public final SimpleEntrySet<WoodType, Block> frames;
    public final SimpleEntrySet<WoodType, Block> pallets;
    public final SimpleEntrySet<WoodType, Block> lanterns;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> walls;

    public BuildingButBetterModule(String modId) {
        super(modId, "bbb");
        var tab = CreativeModeTabs.f_256788_;

        layers = SimpleEntrySet.builder(WoodType.class, "layer",
                        getModBlock("oak_layer"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new LayerBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("slab") //REASON: recipes
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("wooden_layers"), Registries.f_256747_)
                .addTag(BBBBlockTags.LAYERS, Registries.f_256747_)
                .addTag(BBBItemTags.LAYERS, Registries.f_256913_)
                .addTag(modRes("wooden_layers"), Registries.f_256913_)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .copyParentDrop()
                .addModelTransform(BlockTypeResTransformer::replaceOakPlanks)
                .build();
        this.addEntry(layers);

        trims = SimpleEntrySet.builder(WoodType.class, "trim",
                        getModBlock("oak_trim"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new FacingConnectingBlock(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/trim/oak_bottom"))
                .addTexture(modRes("block/trim/oak_middle"))
                .addTexture(modRes("block/trim/oak_none"))
                .addTexture(modRes("block/trim/oak_top"))
                .addTexture(modRes("block/trim/oak_top_face"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("trims"), Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(trims);

        beams = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new RotatedPillarBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("beams"), Registries.f_256747_)
                .addTag(BlockTags.f_13090_, Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beams);

        beamStairs = SimpleEntrySet.builder(WoodType.class, "beam_stairs",
                        getModBlock("oak_beam_stairs"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new StairBlock(w.planks.m_49966_(), Utils.copyPropertySafe(w.planks))
                )
                .addCondition(w -> (beams.blocks.get(w) != null)) //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("beams"), Registries.f_256747_)
                .addTag(BlockTags.f_13096_, Registries.f_256747_)
                .addTag(BlockTags.f_13030_, Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beamStairs);

        beamSlabs = SimpleEntrySet.builder(WoodType.class, "beam_slab",
                        getModBlock("oak_beam_slab"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new FacingSlabBlock(Utils.copyPropertySafe(w.planks))
                )
                .addCondition(w -> (beams.blocks.get(w) != null)) //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("beams"), Registries.f_256747_)
                .addTag(BlockTags.f_13097_, Registries.f_256747_)
                .addTag(BlockTags.f_13031_, Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beamSlabs);

        supports = SimpleEntrySet.builder(WoodType.class, "support",
                        getModBlock("oak_support"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new SupportBlock(Utils.copyPropertySafe(w.planks).m_60955_())
                )
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("supports"), Registries.f_256747_)
                .addTag(modRes("supports"), Registries.f_256913_)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(supports);

        ResourceLocation frameTexture;
        ResourceLocation stickTexture;
        if (PlatHelper.getModVersion("bbb").contains("1.0.1")) {
            frameTexture = modRes("block/frame/oak_frame");
            stickTexture = modRes("block/frame/oak_frame_sticks");
        }
        else { // v1.1.1
            frameTexture = modRes("block/frame/oak");
            stickTexture = modRes("block/frame/oak_sticks");
        }

        frames = SimpleEntrySet.builder(WoodType.class, "frame",
                        getModBlock("oak_frame"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new FrameBlock(Utils.copyPropertySafe(w.planks).m_60955_().m_60910_().m_278166_(PushReaction.DESTROY))
                )
                .requiresChildren("slab") //REASON: recipes
                .addTexture(frameTexture)
                .addTexture(stickTexture)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(new ResourceLocation("create", "movable_empty_collider"), Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("frames"), Registries.f_256747_)
                .addTag(modRes("frames"), Registries.f_256913_)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(frames);

        pallets = SimpleEntrySet.builder(WoodType.class, "pallet",
                        getModBlock("oak_pallet"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new PalletBlock(Utils.copyPropertySafe(w.planks).m_60955_())
                )
                .addTexture(modRes("block/pallet/oak_pallet"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("pallets"), Registries.f_256747_)
                .addTag(modRes("pallets"), Registries.f_256913_)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(pallets);

        lanterns = SimpleEntrySet.builder(WoodType.class, "lantern",
                        getModBlock("oak_lantern"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new WoodenLanternBlock(Utils.copyPropertySafe(w.planks).m_60953_((blockStatex) -> 15))
                )
                .requiresChildren("slab") //REASON: recipes
                .addTexture(modRes("block/lantern/oak"))
//                .addTextureM(modRes("block/lantern/oak"), EveryCompat.res("block/bbb/oak_lantern_m")) //REASON: the texture is 18x16, mask_texture had to be removed
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_lanterns"), Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(modRes("lanterns"), Registries.f_256913_)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(lanterns);

        ladders = SimpleEntrySet.builder(WoodType.class, "ladder",
                        getModBlock("oak_ladder"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new BBBLadderBlock(1, Utils.copyPropertySafe(Blocks.f_50155_))
                )
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .addTexture(modRes("block/ladder/acacia/oak"))
                .addTexture(modRes("block/ladder/birch/oak"))
                .addTexture(modRes("block/ladder/cherry/oak"))
                .addTexture(modRes("block/ladder/crimson/oak"))
                .addTexture(modRes("block/ladder/dark_oak/oak"))
                .addTexture(modRes("block/ladder/jungle/oak"))
                .addTexture(modRes("block/ladder/mangrove/oak"))
                .addTexture(modRes("block/ladder/oak/oak"))
                .addTextureM(modRes("block/ladder/spruce/oak"), EveryCompat.res("block/bbb/spruce-oak_ladder_m"))
                .addTexture(modRes("block/ladder/warped/oak"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("ladders"), Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(BlockTags.f_13082_, Registries.f_256747_)
                .addTag(BlockTags.f_201924_, Registries.f_256747_)
                .addTag(modRes("ladders"), Registries.f_256913_)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(ladders);

        walls = SimpleEntrySet.builder(WoodType.class, "wall",
                        getModBlock("oak_wall"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new WoodenWallBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_walls"), Registries.f_256747_)
                .addTag(modRes("wooden_blocks"), Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(walls);
    }
}