package net.mehvahdjukaar.every_compat.modules.forge.lieonlion;

import com.google.gson.JsonObject;
import io.github.lieonlion.mcv.init.McvBlockInit;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;

//SUPPORT: v1.5.4+
public class MoreChestVariantsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;

    public MoreChestVariantsModule(String modID) {
        super(modID, "mcv");

        chests = SimpleEntrySet.builder(WoodType.class, "chest",
                        McvBlockInit.OAK_CHEST, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new CompatChestBlock(this::getChestTile,
                                Utils.copyPropertySafe(Blocks.f_50087_).m_284180_(MapColor.f_283825_))
                )
                .addTile(MoreChestBlockEntity::new)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13088_, Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/normal"), Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS_WOODEN, Registries.f_256747_)
                .addTag(new ResourceLocation("quad", "cats_on_blocks/sit"), Registries.f_256747_)
                .addTag(new ResourceLocation("quad", "fuel/wood"), Registries.f_256913_)
                .addTag(Tags.Items.CHESTS_WOODEN, Registries.f_256913_)
                .addTag(Tags.Items.CHESTS, Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/normal"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256913_)
                .setTabKey(CreativeModeTabs.f_256791_)
                .defaultRecipe()
                .build();
        this.addEntry(chests);

        trappedChests = SimpleEntrySet.builder(WoodType.class, "trapped_chest",
                        McvBlockInit.OAK_TRAPPED_CHEST, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new CompatTrappedChestBlock(this::getTrappedTile,
                                Utils.copyPropertySafe(Blocks.f_50325_).m_284180_(MapColor.f_283825_))
                )
                .addTile(MoreTrappedBlockEntity::new)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/trapped"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13088_, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS_WOODEN, Registries.f_256747_)
                .addTag(new ResourceLocation("quad", "fuel/wood"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/trapped"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256913_)
                .addTag(Tags.Items.CHESTS_WOODEN, Registries.f_256913_)
                .addTag(Tags.Items.CHESTS, Registries.f_256913_)
                .setTabKey(CreativeModeTabs.f_257028_)
                .defaultRecipe()
                .build();
        this.addEntry(trappedChests);

    }

    // GetTile ---------------------------------------------------------------------------------------------------------
    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return trappedChests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity -----------------------------------------------------------------------------------------------------
    private class MoreChestBlockEntity extends CompatChestBlockEntity {
        public MoreChestBlockEntity(BlockPos pos, BlockState state) {
            super(chests.getTile(), pos, state);
        }
    }

    private class MoreTrappedBlockEntity extends CompatChestBlockEntity {
        public MoreTrappedBlockEntity(BlockPos pos, BlockState state) {
            super(trappedChests.getTile(), pos, state);
        }
    }

    // Registry --------------------------------------------------------------------------------------------------------
    @Override
    @OnlyIn(Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        CompatChestBlockRenderer.register(event, trappedChests.getTile(CompatChestBlockEntity.class), shortenedId());
    }

    // Textures
    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) -> {
            trappedChests.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak"),
                        EveryCompat.res("entity/mcv_chest_normal_m"),
                        EveryCompat.res("entity/mcv_chest_normal_o"),
                        EveryCompat.res("entity/mcv_trapped_normal_o"), 0
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak_left"),
                        EveryCompat.res("entity/mcv_chest_left_m"),
                        EveryCompat.res("entity/mcv_chest_left_o"),
                        EveryCompat.res("entity/mcv_trapped_left_o"), 0
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak_right"),
                        EveryCompat.res("entity/mcv_chest_right_m"),
                        EveryCompat.res("entity/mcv_chest_right_o"),
                        EveryCompat.res("entity/mcv_trapped_right_o"), 0
                );


                // MODEL BLOCK
                String path = shortenedId() + "/" + wood.getAppendableId() + "_chest";
                String trapped_path = shortenedId() + "/" + wood.getAppendableId() + "_trapped_chest";

                customModel(path, sink, manager);
                customModel(trapped_path, sink, manager);
            });

        });
    }

    public void customModel(String path, ResourceSink sink, ResourceManager manager) {
        JsonObject modelFile;
        ResourceLocation modelRLoc = EveryCompat.res("models/block/" + path + ".json");

        if (manager.m_213713_(modelRLoc).isPresent()) {
            try (InputStream modelStream = manager.m_213713_(modelRLoc).get().m_215507_()) {
                modelFile = RPUtils.deserializeJson(modelStream);

                String textureID = EveryCompat.MOD_ID + ":entity/chest/" + path;

                // Editing
                modelFile.getAsJsonObject("textures").addProperty("wood_type", textureID);

                // Add to Resource
                sink.addJson(EveryCompat.res(path), modelFile, ResType.BLOCK_MODELS);
            } catch (IOException e) {
                EveryCompat.LOGGER.error("MoreChestVariantsModule: failed to open the model file: {} - {}", modelRLoc, e);
            }
        }
    }
}
