package net.mehvahdjukaar.every_compat.modules.forge.valhelsia;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.valhelsia_structures.common.recipe.AxeCraftingRecipeBuilder;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class AxeCraftingRecipeTemplate implements IRecipeTemplate<AxeCraftingRecipeBuilder.Result> {
    public final Item output;
    public final int count;
    public final String group;
    public final Ingredient input;

    private final List<Object> conditions = new ArrayList<>();

    public AxeCraftingRecipeTemplate(JsonObject json) {

        JsonObject output = json.get("output").getAsJsonObject();

        ResourceLocation item = new ResourceLocation(output.get("item").getAsString());
        int count = 1;
        var c = output.get("count");
        if (c != null) count = c.getAsInt();

        this.count = count;
        this.output = BuiltInRegistries.f_257033_.m_7745_(item);

        var g = json.get("group");
        this.group = g == null ? "" : g.getAsString();

        this.input = Ingredient.m_43917_(json.get("input"));
    }

    @Override
    public <T extends BlockType> AxeCraftingRecipeBuilder.Result createSimilar(
            T originalMat, T destinationMat, Item unlockItem, @Nullable String id) {
        ItemLike newOutput = BlockSetAPI.changeItemType(this.output, originalMat, destinationMat);
        if (newOutput == null)
            throw new UnsupportedOperationException(String.format("Could not convert output item %s", output));

        boolean atLeastOneChanged = false;
        Ingredient newInput = input;
        for (var in : newInput.m_43908_()) {
            Item it = in.m_41720_();
            if (it != Items.f_42127_) {
                ItemLike i = BlockSetAPI.changeItemType(it, originalMat, destinationMat);
                if (i != null) {
                    atLeastOneChanged = true;
                    //converts first ingredient it finds
                    newInput = Ingredient.m_43929_(i);
                    break;
                }
            }
        }
        //if recipe fails
        if (!atLeastOneChanged) return null;

        AxeCraftingRecipeBuilder builder = new AxeCraftingRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, newInput, newOutput.m_5456_(), count);
        //builder.group(group);

        builder.m_126132_("has_log", InventoryChangeTrigger.TriggerInstance.m_43199_(unlockItem));


        AtomicReference<AxeCraftingRecipeBuilder.Result> newRecipe = new AtomicReference<>();

        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((AxeCraftingRecipeBuilder.Result) r));
        } else {
            builder.m_176500_(r -> newRecipe.set((AxeCraftingRecipeBuilder.Result) r), id);
        }
        return newRecipe.get();
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    @Override
    public List<Object> getConditions() {
        return conditions;
    }

}