/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TagUtility {
    public static final ResourceLocation SILICA_TAG = TagUtility.platformTag("silica_glass", "silica");
    public static final ResourceLocation GLASS_TAG = TagUtility.platformTag("glass_blocks", "glass");
    public static final ResourceLocation GLASS_PANE_TAG = TagUtility.platformTag("glass_panes");

    public static ResourceLocation getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink sink, ResourceManager manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        ResourceLocation RLocLogs = ResourceLocation.parse((String)(resLocMOD + "_" + suffixTag));
        ResourceLocation RLocStems = ResourceLocation.parse((String)(resLocMOD + "_" + suffixAlt));
        ResourceLocation RLocFolders = ResourceLocation.parse((String)(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName()));
        ResourceLocation RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (TagUtility.doTagExistFor(RLocLogs, manager)) {
            return RLocLogs;
        }
        if (TagUtility.doTagExistFor(RLocStems, manager)) {
            return RLocStems;
        }
        if (TagUtility.doTagExistFor(RLocEC, manager)) {
            return RLocEC;
        }
        if (TagUtility.doTagExistFor(RLocFolders, manager)) {
            return RLocFolders;
        }
        TagUtility.createAndAddDefaultTags(RLocEC, sink, blockType, new Block[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(ResourceLocation resLoc, ResourceSink sink, BlockType blockType, Block ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return TagUtility.createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return TagUtility.createAndAddCustomTags(resLoc, sink, blocks);
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Block ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Block block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.BLOCK);
            sink.addTag(tagBuilder, Registries.ITEM);
        }
        return isTagCreated;
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Item ... items) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Item item : items) {
            if (item == null) continue;
            tagBuilder.addEntry((Object)item);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.ITEM);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, String tag, boolean includeBlock, boolean includeItem, ResourceSink pack) {
        TagUtility.addTagToAllBlocks(blocks, nameStone, modId, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)tag)), includeBlock, includeItem, pack);
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, TagKey<Block> tag, boolean includeBlock, boolean includeItem, ResourceSink pack) {
        TagUtility.addTagToAllBlocks(blocks, nameStone, modId, tag, includeBlock, includeItem, pack, null);
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, TagKey<Block> tag, boolean includeBlock, boolean includeItem, ResourceSink pack, @Nullable String regexBlockId) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                Block block = (Block)entry.getValue();
                String blockPath = Utils.getID((Block)block).getPath();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!stoneType.getTypeName().equals(nameStone) || regexBlockId != null && !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.BLOCK);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.ITEM);
                }
            }
        }
    }

    public static Pair<ResourceLocation, Boolean> getATagId(String idTag, String idAlt, ResourceManager manager) {
        ResourceLocation RLocId = ResourceLocation.parse((String)idTag);
        ResourceLocation RLocIdAlt = ResourceLocation.parse((String)idAlt);
        if (TagUtility.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (TagUtility.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(ResourceLocation resLoc, ResourceManager manager) {
        boolean blockTag = manager.getResource(ResType.TAGS.getPath(resLoc.withPrefix("blocks/"))).isPresent();
        boolean itemTag = manager.getResource(ResType.TAGS.getPath(resLoc.withPrefix("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static ResourceLocation platformTag(String tagPath) {
        return TagUtility.platformTag(tagPath, tagPath);
    }

    public static ResourceLocation platformTag(String fabric, String neoforge) {
        return PlatHelper.getPlatform().isFabric() ? TagUtility.fabricTag(fabric) : TagUtility.neoforgeTag(neoforge);
    }

    public static ResourceLocation fabricTag(String tagPath) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)tagPath);
    }

    public static ResourceLocation neoforgeTag(String tagPath) {
        return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)tagPath);
    }
}

