/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.regions_unexplored;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;

public abstract class RegionsUnexploredModuleAbstract
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> branches;
    public final SimpleEntrySet<LeavesType, Block> shrubs;

    public RegionsUnexploredModuleAbstract(String modId) {
        super(modId, "ru");
        ResourceLocation tab = PlatHelper.getPlatform().isFabric() ? this.modRes("main") : this.modRes("ru_main");
        this.branches = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "branch", this.getModBlock("oak_branch"), () -> VanillaWoodTypes.OAK, this::newBranchBlock).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("branches_can_survive_on"), Registries.BLOCK)).addTag(this.modRes("branches"), Registries.BLOCK)).addTag(this.modRes("branches"), Registries.ITEM)).setTabKey(tab)).addRecipe(this.modRes("oak_branch_from_oak_log"))).build();
        this.addEntry(this.branches);
        this.shrubs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "shrub", this.getModBlock("dark_oak_shrub"), () -> VanillaLeavesTypes.DARK_OAK, this::newShrubBlock).addCondition(l -> {
            boolean log = l.getAssociatedWoodType() != null;
            boolean sapling = l.getItemOfThis("sapling") != null;
            return log && sapling;
        })).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("shrubs"), Registries.BLOCK)).addTag(this.modRes("shrub_can_survive_on"), Registries.BLOCK)).addTag(this.modRes("shrubs"), Registries.ITEM)).setTabKey(tab)).addRecipe(this.modRes("dark_oak_sapling_from_dark_oak_shrub"))).addRecipe(this.modRes("dark_oak_shrub"))).copyParentDrop().copyParentTint()).build();
        this.addEntry(this.shrubs);
    }

    public abstract Block newShrubBlock(LeavesType var1);

    public abstract Block newBranchBlock(WoodType var1);

    @Override
    public void onModSetup() {
        this.branches.blocks.forEach((woodType, block) -> ComposterBlock.COMPOSTABLES.put(block, 0.3f));
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (woodType.isVanilla() || woodType.getNamespace().equals("regions_unexplored")) continue;
                TagUtility.createAndAddCustomTags(ResourceLocation.withDefaultNamespace((String)"planks"), sink, woodType.planks);
                TagUtility.createAndAddCustomTags(ResourceLocation.parse((String)"forge:planks"), sink, woodType.planks);
            }
        });
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            try (TextureImage branch_side = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("item/oak_branch_side"));
                 TextureImage branch_top = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("item/oak_branch_top"));
                 TextureImage branch_block = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/oak_branch"));){
                Respriter respriterSIDE = Respriter.of((TextureImage)branch_side);
                Respriter respriterTOP = Respriter.of((TextureImage)branch_top);
                Respriter respriterBlock = Respriter.of((TextureImage)branch_block);
                this.branches.blocks.forEach((wood, block) -> {
                    try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        String resLocITEM = "item/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch";
                        String resLocBLOCK = "block/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch";
                        List list_logSide = Palette.fromAnimatedImage((TextureImage)logSide_texture);
                        List list_logTop = Palette.fromAnimatedImage((TextureImage)logTop_texture);
                        sink.addTextureIfNotPresent(manager, resLocBLOCK, () -> respriterBlock.recolor(list_logSide));
                        sink.addTextureIfNotPresent(manager, resLocITEM, () -> {
                            TextureImage recoloredITEM = respriterSIDE.recolor(list_logSide);
                            try (TextureImage recoloredTOP = respriterTOP.recolor(list_logTop);){
                                TextureOps.applyOverlay((TextureImage)recoloredITEM, (TextureImage[])new TextureImage[]{recoloredTOP});
                            }
                            return recoloredITEM;
                        });
                    }
                    catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to get Log Texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to get Branch Item Texture for ", (Throwable)e);
            }
            try (TextureImage shrubTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/dark_oak_shrub_top"));
                 TextureImage shrubBottom = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/dark_oak_shrub_bottom"));
                 TextureImage shrubTopMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ru/mask_shrub_top"));
                 TextureImage shrubMiddleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ru/mask_shrub_middle"));){
                this.shrubs.blocks.forEach((leavesType, block) -> {
                    String shrubPath = leavesType.createPathWith(this.shortenedId(), "shrub");
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)Objects.requireNonNull(leavesType.getAssociatedWoodType()).log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage leavesTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)leavesType.leaves, CompatSpritesHelper.LOOKS_LIKE_LEAF_TEXTURE));){
                        Respriter respriterTop = Respriter.masked((TextureImage)shrubTop, (TextureImage)shrubMiddleMask);
                        Respriter respriterBottom = Respriter.of((TextureImage)shrubBottom);
                        List logSidePalette = Palette.fromAnimatedImage((TextureImage)logTexture);
                        List leavesPalette = Palette.fromAnimatedImage((TextureImage)leavesTexture);
                        String resLoc = "block/" + shrubPath;
                        sink.addTextureIfNotPresent(manager, resLoc + "_bottom", () -> respriterBottom.recolor(logSidePalette));
                        sink.addTextureIfNotPresent(manager, resLoc + "_top", () -> {
                            try (TextureImage recoloredShrubTop = respriterTop.recolor(leavesPalette);){
                                Respriter respriterMiddle = Respriter.masked((TextureImage)recoloredShrubTop, (TextureImage)shrubTopMask);
                                TextureImage textureImage = respriterMiddle.recolor(logSidePalette);
                                return textureImage;
                            }
                        });
                    }
                    catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to get texture for {} : {}", (Object)block.toString(), (Object)e.getMessage());
                    }
                });
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to open textures for: {}", (Object)e.getMessage());
            }
        });
    }
}

