/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PaletteStrategies {
    private static final Set<Cached> cachedStrategies = new HashSet<Cached>();
    public static final PaletteStrategy MAIN_CHILD = PaletteStrategies.registerCached(PaletteStrategies::makePaletteFromMainChild);
    public static final PaletteStrategy PLANKS_STANDARD = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, null));
    public static final PaletteStrategy LOG_SIDE_STANDARD = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "log", CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE, null));
    public static final PaletteStrategy STRIPPED_LOG_TOP_STANDARD = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "stripped_log", CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE, null));
    public static final PaletteStrategy STRIPPED_LOG_SIDE_STANDARD = PaletteStrategies.registerCached((t, manager) -> PaletteStrategies.makePaletteFromChild(t, manager, "stripped_log", CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE, null));
    public static final PaletteStrategy SIGN_LIKE = PaletteStrategies.registerCached((blockType, manager) -> {
        PaletteStrategy.PaletteAndAnimation paletteAndAnimation;
        block8: {
            TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)blockType.getBlockOfThis("planks")));
            try {
                List targetPalette = SpriteUtils.extrapolateSignBlockPalette((TextureImage)plankTexture);
                paletteAndAnimation = PaletteStrategy.PaletteAndAnimation.of(targetPalette, plankTexture.getMcMeta());
                if (plankTexture == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            plankTexture.close();
        }
        return paletteAndAnimation;
    });
    public static final PaletteStrategy LOG_SIDE_REMOVE_2_DARKEST = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "log", CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE, p -> {
        if (p.size() > 3) {
            p.reduceDown();
            p.reduceDown();
        }
    }));
    public static final PaletteStrategy PLANKS_REMOVE_DARKEST = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        if (p.size() > 2) {
            p.reduceDown();
        }
    }));
    public static final PaletteStrategy PLANKS_REMOVE_2_DARKEST = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        if (p.size() > 3) {
            p.reduceDown();
            p.reduceDown();
        }
    }));
    public static final PaletteStrategy PLANKS_LOW_CONTRAST = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        float averageStep = p.getAverageLuminanceStep();
        p.matchLuminanceStep(averageStep * 0.9f);
    }));
    public static final PaletteStrategy WOOD_ITEM = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromMainChild(blockType, manager, SpriteUtils::extrapolateSignBlockPalette));

    @ApiStatus.Internal
    public static void clearCache() {
        cachedStrategies.forEach(c -> c.cache.clear());
    }

    public static synchronized PaletteStrategy registerCached(PaletteStrategy factory) {
        Cached c = new Cached(factory);
        cachedStrategies.add(c);
        return c;
    }

    public static PaletteStrategy.PaletteAndAnimation makePaletteFromMainChild(BlockType blockType, ResourceManager manager) {
        return PaletteStrategies.makePaletteFromMainChild(blockType, manager, null);
    }

    public static PaletteStrategy.PaletteAndAnimation makePaletteFromMainChild(BlockType blockType, ResourceManager manager, @Nullable Consumer<Palette> paletteTransform) {
        PaletteStrategy.PaletteAndAnimation paletteAndAnimation;
        block13: {
            ItemLike mainChild = blockType.mainChild();
            Block mainBlockTypeBlock = null;
            if (mainChild instanceof Block) {
                Block block;
                mainBlockTypeBlock = block = (Block)mainChild;
            } else if (mainChild instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)mainChild;
                mainBlockTypeBlock = blockItem.getBlock();
            }
            if (mainBlockTypeBlock == null) {
                throw new UnsupportedOperationException("You need to provide a palette supplier for non block main child");
            }
            TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)mainBlockTypeBlock));
            try {
                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                McMetaFile animation = plankTexture.getMcMeta();
                if (paletteTransform != null) {
                    targetPalette.forEach(paletteTransform);
                }
                paletteAndAnimation = PaletteStrategy.PaletteAndAnimation.of(targetPalette, animation);
                if (plankTexture == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get mainChild texture for " + String.valueOf(blockType.getId()) + " - " + String.valueOf(e));
                }
            }
            plankTexture.close();
        }
        return paletteAndAnimation;
    }

    public static <T extends BlockType> PaletteStrategy.PaletteAndAnimation makePaletteFromChild(T blockType, ResourceManager m, String childKey, @Nullable Predicate<String> whichSide, @Nullable Consumer<Palette> paletteTransform) {
        Object child = blockType.getChild(childKey);
        if (child instanceof Block) {
            PaletteStrategy.PaletteAndAnimation paletteAndAnimation;
            block31: {
                Block b = (Block)child;
                if (whichSide != null) {
                    PaletteStrategy.PaletteAndAnimation paletteAndAnimation2;
                    block30: {
                        TextureImage blockTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)b, whichSide));
                        try {
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)blockTexture);
                            if (paletteTransform != null) {
                                targetPalette.forEach(paletteTransform);
                            }
                            paletteAndAnimation2 = PaletteStrategy.PaletteAndAnimation.of(targetPalette, blockTexture.getMcMeta());
                            if (blockTexture == null) break block30;
                        }
                        catch (Throwable targetPalette) {
                            try {
                                if (blockTexture != null) {
                                    try {
                                        blockTexture.close();
                                    }
                                    catch (Throwable throwable) {
                                        targetPalette.addSuppressed(throwable);
                                    }
                                }
                                throw targetPalette;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                            }
                        }
                        blockTexture.close();
                    }
                    return paletteAndAnimation2;
                }
                TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)b));
                try {
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    if (paletteTransform != null) {
                        targetPalette.forEach(paletteTransform);
                    }
                    paletteAndAnimation = PaletteStrategy.PaletteAndAnimation.of(targetPalette, plankTexture.getMcMeta());
                    if (plankTexture == null) break block31;
                }
                catch (Throwable targetPalette) {
                    try {
                        if (plankTexture != null) {
                            try {
                                plankTexture.close();
                            }
                            catch (Throwable throwable) {
                                targetPalette.addSuppressed(throwable);
                            }
                        }
                        throw targetPalette;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                    }
                }
                plankTexture.close();
            }
            return paletteAndAnimation;
        }
        if (child instanceof Item) {
            PaletteStrategy.PaletteAndAnimation paletteAndAnimation;
            block32: {
                Item i = (Item)child;
                TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)m, (Item)i));
                try {
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    if (paletteTransform != null) {
                        targetPalette.forEach(paletteTransform);
                    }
                    paletteAndAnimation = PaletteStrategy.PaletteAndAnimation.of(targetPalette, plankTexture.getMcMeta());
                    if (plankTexture == null) break block32;
                }
                catch (Throwable throwable) {
                    try {
                        if (plankTexture != null) {
                            try {
                                plankTexture.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                    }
                }
                plankTexture.close();
            }
            return paletteAndAnimation;
        }
        throw new RuntimeException("No child with key \"" + childKey + "\" found for" + String.valueOf(blockType.getId()));
    }

    private static class Cached
    implements PaletteStrategy {
        private final Map<BlockType, PaletteStrategy.PaletteAndAnimation> cache = new HashMap<BlockType, PaletteStrategy.PaletteAndAnimation>();
        private final PaletteStrategy factory;

        private Cached(PaletteStrategy factory) {
            this.factory = factory;
        }

        @Override
        public PaletteStrategy.PaletteAndAnimation getPaletteAndAnimation(BlockType t, ResourceManager manager) throws Exception {
            PaletteStrategy.PaletteAndAnimation existing = this.cache.get(t);
            if (existing == null) {
                existing = this.factory.getPaletteAndAnimation(t, manager);
                this.cache.put(t, existing);
            }
            return existing;
        }
    }
}

