/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class TextureUtility {
    public static String modifyTexturePath(String baseTexturePath, String prefix, String shortenedId, String oldTypeName, BlockType blockType) {
        String infix = shortenedId + "/" + blockType.getNamespace() + "/";
        return prefix + infix + baseTexturePath.substring(prefix.length()).replace(oldTypeName, blockType.getTypeName());
    }

    public static void generateLogTexture(ResourceLocation baseTextureLoc, ResourceLocation logMaskLoc, ResourceLocation planksMaskLoc, String shortenedId, String oldTypeName, PaletteStrategy logPaletteStrategy, ResourceSink sink, ResourceManager manager) {
        try (TextureImage mainTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)baseTextureLoc);
             TextureImage logMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)logMaskLoc);
             TextureImage planksMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                String newPath = TextureUtility.modifyTexturePath(baseTextureLoc.getPath(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newPath, () -> {
                    try {
                        PaletteStrategy.PaletteAndAnimation logPalette = logPaletteStrategy.getPaletteAndAnimation((BlockType)woodType, manager);
                        PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_STANDARD.getPaletteAndAnimation((BlockType)woodType, manager);
                        Respriter planksResprite = Respriter.masked((TextureImage)mainTexture, (TextureImage)logMask);
                        TextureImage recoloredInner = planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                        Respriter logResprite = Respriter.masked((TextureImage)recoloredInner, (TextureImage)planksMask);
                        return logResprite.recolorWithAnimation(logPalette.palette(), logPalette.animation());
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate log texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                        return mainTexture;
                    }
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to get mask texture: {}", (Object)e.getMessage());
        }
    }

    public record Quartet<L extends String, ML extends String, MR extends String, R extends PaletteStrategy>(L baseTexture, ML logMask, MR planksMask, R paletteStrategy) {
        public static <A extends String, B extends String, C extends String, D extends PaletteStrategy> Quartet<A, B, C, D> of(A baseTexture, B logMask, C planksMask, D paletteStrategy) {
            return new Quartet<A, B, C, D>(baseTexture, logMask, planksMask, paletteStrategy);
        }
    }
}

