/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.chipped;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ChippedAbstractModule
extends SimpleModule {
    public static String tabPath = "main";

    public ChippedAbstractModule(String modId) {
        super(modId, "ch");
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            List<EntrySet> doors = this.getEntries().stream().filter(e -> e.getName().contains("door") && !e.getName().contains("trapdoor")).toList();
            for (EntrySet e2 : doors) {
                if (!(e2 instanceof SimpleEntrySet)) continue;
                SimpleEntrySet se = (SimpleEntrySet)e2;
                for (Block d : se.blocks.values()) {
                    handler.addLootTable(d, ChippedAbstractModule.createDoorLoot(d));
                }
            }
            this.addCarpenterRecipe(handler, "planks");
            this.addCarpenterRecipe(handler, "door");
            this.addCarpenterRecipe(handler, "trapdoor");
            this.addCarpenterRecipe(handler, "log");
            this.addCarpenterRecipe(handler, "stripped_log");
        });
    }

    public static LootTable.Builder createDoorLoot(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)))));
    }

    protected void addCarpenterRecipe(ResourceSink pack, String identifier) {
        JsonArray ingredients = new JsonArray();
        for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
            if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
            boolean isTagCreated = false;
            String suffixedFile = identifier.equals("stripped_log") ? woodType.getAppendableIdWith("stripped", "log") : woodType.getAppendableIdWith(identifier);
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)EveryCompat.res(this.shortenedId() + "/" + suffixedFile));
            for (EntrySet<?> entry : this.getEntries()) {
                Item item;
                boolean isStrippedLog;
                String name = entry.getName();
                boolean bl = isStrippedLog = identifier.equals("stripped_log") && name.contains("stripped");
                if (!name.matches(".*(_" + identifier + "|" + identifier + "_).*") && !isStrippedLog || identifier.equals("door") && name.matches(".*(_trapdoor|trapdoor_).*") || identifier.equals("log") && name.matches(".*(_stripped_log|stripped_).*") || identifier.equals("stripped_log") && !name.contains("stripped") || (item = (Item)((SimpleEntrySet)entry).items.get(woodType)) == null) continue;
                tagBuilder.addEntry((Object)item);
                isTagCreated = true;
            }
            if (woodType.getChild(identifier) != null) {
                switch (identifier) {
                    case "planks": {
                        tagBuilder.addEntry((Object)woodType.planks);
                        break;
                    }
                    case "door": {
                        tagBuilder.addEntry(woodType.getChild("door"));
                        break;
                    }
                    case "trapdoor": {
                        tagBuilder.addEntry(woodType.getChild("trapdoor"));
                        break;
                    }
                    case "log": {
                        tagBuilder.addEntry((Object)woodType.log);
                        break;
                    }
                    case "stripped_log": {
                        tagBuilder.addEntry(woodType.getChild("stripped_log"));
                    }
                }
            }
            JsonObject tagObject = new JsonObject();
            if (!isTagCreated) continue;
            pack.addTag(tagBuilder, Registries.ITEM);
            pack.addTag(tagBuilder, Registries.BLOCK);
            tagObject.addProperty("tag", tagBuilder.getId().toString());
            ingredients.add((JsonElement)tagObject);
        }
        JsonObject recipeJO = new JsonObject();
        recipeJO.addProperty("type", "chipped:workbench");
        recipeJO.add("ingredients", (JsonElement)ingredients);
        if (!ingredients.isEmpty()) {
            pack.addJson(EveryCompat.res(this.shortenedId() + "/carpenters_table_" + identifier), (JsonElement)recipeJO, ResType.RECIPES);
        }
    }
}

