/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.item.FuelBlockItem;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FarmersDelightModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> cabinets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cabinet", this.getModBlock("oak_cabinet"), () -> VanillaWoodTypes.OAK, w -> new CabinetBlock(Utils.copyPropertySafe((Block)w.planks))).requiresChildren(new String[]{"trapdoor", "slab"})).addTile(this.getModTile("cabinet")).addTextureM(this.modRes("block/oak_cabinet_front"), EveryCompat.res("block/fd/oak_cabinet_front_m"), customPalette)).addTexture(this.modRes("block/oak_cabinet_side"), customPalette)).addTexture(this.modRes("block/oak_cabinet_top"), customPalette)).addTexture(this.modRes("block/oak_cabinet_front_open"), customPalette)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("cabinets/wooden"), Registries.ITEM)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).setTabKey(this.modRes("farmersdelight"))).setTabMode(TabAddMode.AFTER_SAME_TYPE)).defaultRecipe().addCustomItem((w, block, p) -> new FuelBlockItem(block, ModItems.basicItem(), 300)).build();
    public static final PaletteStrategy customPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.reduceDown();
        if (p.size() < 9) {
            while (p.size() <= 9) {
                p.increaseInner();
            }
        } else {
            while (p.size() >= 9) {
                p.reduce();
            }
        }
    }));

    public FarmersDelightModule(String modId) {
        super(modId, "fd", "everycomp");
        this.addEntry(this.cabinets);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                this.createCuttingRecipe("door", woodType.getBlockOfThis("door"), woodType, sink, manager);
                this.createCuttingRecipe("hanging_sign", woodType.getBlockOfThis("hanging_sign"), woodType, sink, manager);
                this.createCuttingRecipe("sign", woodType.getBlockOfThis("sign"), woodType, sink, manager);
                this.createCuttingRecipe("trapdoor", woodType.getBlockOfThis("trapdoor"), woodType, sink, manager);
                this.createCuttingRecipe("log", woodType.getBlockOfThis("log"), woodType, sink, manager);
                this.createCuttingRecipe("wood", woodType.getBlockOfThis("wood"), woodType, sink, manager);
            }
        });
    }

    public void createCuttingRecipe(String recipeType, Block input, WoodType targetType, ResourceSink sink, ResourceManager manager) {
        if (Objects.isNull(input)) {
            return;
        }
        String recipeLocation = this.modRes("cutting/oak_" + recipeType).toString();
        Recipe recipe = RPUtils.readRecipe((ResourceManager)manager, (String)recipeLocation);
        if (recipe instanceof CuttingBoardRecipe) {
            CuttingBoardRecipe cr = (CuttingBoardRecipe)recipe;
            String path = this.shortenedId() + "/cutting/" + targetType.getAppendableId() + "_" + recipeType;
            NonNullList oldResult = cr.getRollableResults();
            NonNullList newResult = NonNullList.withSize((int)oldResult.size(), (Object)ChanceResult.EMPTY);
            for (int i = 0; i < oldResult.size(); ++i) {
                Item newItem;
                ChanceResult r = (ChanceResult)oldResult.get(i);
                Item critem = r.stack().getItem();
                WoodType originalType = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)critem);
                if (originalType == VanillaWoodTypes.OAK && (newItem = BlockSetAPI.changeItemType((Item)critem, (BlockType)originalType, (BlockType)targetType)) != null) {
                    newResult.set(i, (Object)new ChanceResult(r.stack().transmuteCopy((ItemLike)newItem), r.chance()));
                    continue;
                }
                newResult.set(i, (Object)r);
            }
            CuttingBoardRecipe newRec = new CuttingBoardRecipe(cr.getGroup(), Ingredient.of((ItemLike[])new ItemLike[]{input}), cr.getTool(), newResult, cr.getSoundEvent());
            ResourceLocation recipePath = EveryCompat.res(path);
            sink.addRecipe(new RecipeHolder(recipePath, (Recipe)newRec));
        }
    }
}

