/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.valhelsia;

import com.mojang.blaze3d.platform.NativeImage;
import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.common.recipe.ToolCraftingRecipe;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.RecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.valhelsia.valhelsia_core.api.common.block.StrippableRotatedPillarBlock;

public class ValhelsiaStructuresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> cutStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> cutPosts;
    public final SimpleEntrySet<WoodType, Block> bundledStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> bundledPosts;

    public ValhelsiaStructuresModule(String modId) {
        super(modId, "vs", "everycomp");
        ResourceLocation tab = this.modRes("main");
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "stripped", this.getModBlock("stripped_oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new PostBlock(ValhelsiaStructuresModule.postProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("stripped_posts"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.strippedPosts);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", this.getModBlock("oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new StrippablePostBlock((WoodType)woodType, ValhelsiaStructuresModule.postProperties(woodType))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("posts"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.posts);
        this.cutStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut_stripped", this.getModBlock("cut_stripped_oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new CutPostBlock(ValhelsiaStructuresModule.cutPostProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("cut_stripped_posts"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutStrippedPosts);
        this.cutPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut", this.getModBlock("cut_oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new StrippableCutPostBlock((WoodType)woodType, ValhelsiaStructuresModule.cutPostProperties(woodType))).addTag(this.modRes("cut_posts"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutPosts);
        this.bundledStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled_stripped", this.getModBlock("bundled_stripped_oak_posts"), () -> VanillaWoodTypes.OAK, woodType -> new RotatedPillarBlock(ValhelsiaStructuresModule.bundledPostProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledStrippedPosts);
        this.bundledPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled", this.getModBlock("bundled_oak_posts"), () -> VanillaWoodTypes.OAK, woodType -> new StrippableRotatedPillarBlock(() -> (Block)this.bundledStrippedPosts.blocks.get(woodType), ValhelsiaStructuresModule.bundledPostProperties(woodType))).requiresFromMap(this.bundledStrippedPosts.blocks)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledPosts);
    }

    public static BlockBehaviour.Properties postProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? Objects.requireNonNull(woodType.getBlockOfThis("stripped_log")).defaultMapColor() : woodType.log.defaultMapColor()).strength(2.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties cutPostProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(state -> ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getAxis().isVertical() && Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? Objects.requireNonNull(woodType.getBlockOfThis("stripped_log")).defaultMapColor() : woodType.log.defaultMapColor()).strength(2.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties bundledPostProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.WOOD : MapColor.PODZOL).strength(2.0f).noOcclusion();
    }

    @Override
    public void onModSetup() {
        super.onModSetup();
        RecipeTemplate.register(ToolCraftingRecipe.class, (original, from, to) -> {
            ItemStack modifiedIngredient = RecipeTemplate.convertItemStack((ItemStack)original.ingredient().getItems()[0], (BlockType)from, (BlockType)to);
            Ingredient newInput = Ingredient.of((ItemStack[])new ItemStack[]{modifiedIngredient});
            ItemStack originalResult = original.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
            ItemStack newResult = RecipeTemplate.convertItemStack((ItemStack)originalResult, (BlockType)from, (BlockType)to);
            if (newResult == null) {
                throw new UnsupportedOperationException("Failed to convert recipe result");
            }
            return new ToolCraftingRecipe(original.category(), newInput, original.tool(), newResult);
        });
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            try {
                this.posts.blocks.forEach((w, block) -> {
                    ResourceLocation id = Utils.getID((Block)block);
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                        TextureImage newTexture = logTexture.makeCopy();
                        sink.addTextureIfNotPresent(manager, newId, () -> newTexture);
                        TextureImage newTop = topTexture.makeCopy();
                        CompatSpritesHelper.createSmallLogTopTexture(topTexture, newTop);
                        sink.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate Post texture for for {} : {}", block, (Object)e);
                    }
                });
                this.strippedPosts.blocks.forEach((w, block) -> {
                    ResourceLocation id = Utils.getID((Block)block);
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/stripped_oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                        try (TextureImage newTexture = logTexture.makeCopy();
                             TextureImage newTop = topTexture.makeCopy();){
                            sink.addTextureIfNotPresent(manager, newId, () -> newTexture);
                            CompatSpritesHelper.createSmallLogTopTexture(topTexture, newTop);
                            sink.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                        }
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate Stripped-Post texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception ex) {
                EveryCompat.LOGGER.error("Could not generate block texture: ", (Throwable)ex);
            }
            try (TextureImage BPTopInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_inner_m"));
                 TextureImage BPTopOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_outer_m"));
                 TextureImage logInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/common_log_top_inner_m"));
                 TextureImage logOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/common_log_top_outer_m"));){
                this.bundledPosts.blocks.forEach((w, block) -> {
                    ResourceLocation resLoc = ResourceLocation.parse((String)w.createFullIdWith("everycomp", "block", this.shortenedId(), "bundled_posts/bundled_", "posts"));
                    this.createTexture(resLoc, w.log, logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_oak_posts"), this.modRes("block/bundled_posts/bundled_oak_posts_top"), sink, manager, (Block)block);
                });
                this.bundledStrippedPosts.blocks.forEach((w, block) -> {
                    ResourceLocation resLoc = ResourceLocation.parse((String)w.createFullIdWith("everycomp", "block", this.shortenedId(), "bundled_posts/bundled_stripped_", "posts"));
                    this.createTexture(resLoc, w.getBlockOfThis("stripped_log"), logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_stripped_oak_posts"), this.modRes("block/bundled_posts/bundled_stripped_oak_posts_top"), sink, manager, (Block)block);
                });
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to open bundled_posts texture: ", (Throwable)e);
            }
        });
    }

    private void createTexture(ResourceLocation resLoc, Block getLogBlock, TextureImage logInnerMask, TextureImage logOuterMask, TextureImage BPTopInnerMask, TextureImage BPTopOuterMask, ResourceLocation getLogSide, ResourceLocation getLogTop, ResourceSink sink, ResourceManager manager, Block block) {
        try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
             TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));
             TextureImage TextureSide = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogSide);
             TextureImage TextureTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogTop);){
            TextureImage topImage;
            TextureImage sideImage;
            NativeImage standardSize;
            McMetaFile metaSide = logSide_texture.getMcMeta();
            if (Objects.nonNull(logSide_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.copyFrom(logSide_texture.getImage());
                sideImage = TextureImage.of((NativeImage)standardSize);
            } else {
                sideImage = logSide_texture;
            }
            List targetSide = Palette.fromAnimatedImage((TextureImage)sideImage);
            Respriter respriterSide = Respriter.of((TextureImage)TextureSide);
            sink.addTextureIfNotPresent(manager, resLoc, () -> respriterSide.recolorWithAnimation(targetSide, metaSide));
            McMetaFile metaTop = logTop_texture.getMcMeta();
            if (Objects.nonNull(logTop_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.copyFrom(logTop_texture.getImage());
                topImage = TextureImage.of((NativeImage)standardSize);
            } else {
                topImage = logTop_texture;
            }
            List targetTopInner = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logOuterMask, (float)0.0f);
            List targetTopOuter = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logInnerMask, (float)0.0f);
            Respriter innerTopResp = Respriter.masked((TextureImage)TextureTop, (TextureImage)BPTopOuterMask);
            TextureImage recoloredInner = innerTopResp.recolorWithAnimation(targetTopInner, metaTop);
            Respriter outerTopResp = Respriter.masked((TextureImage)recoloredInner, (TextureImage)BPTopInnerMask);
            while (((Palette)targetTopOuter.getFirst()).size() < 3) {
                ((Palette)targetTopOuter.getFirst()).increaseInner();
            }
            sink.addTextureIfNotPresent(manager, String.valueOf(resLoc) + "_top", () -> outerTopResp.recolorWithAnimation(targetTopOuter, metaTop));
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate the texture for {} : {}", (Object)block, (Object)e);
        }
    }

    public class StrippableCutPostBlock
    extends CutPostBlock {
        private final WoodType woodType;

        public StrippableCutPostBlock(WoodType woodType, BlockBehaviour.Properties properties) {
            super(properties);
            this.woodType = woodType;
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)this);
            if (!context.getItemInHand().canPerformAction(itemAbility) || Objects.requireNonNull(location).getPath().contains("stripped")) {
                return null;
            }
            if (itemAbility == ItemAbilities.AXE_STRIP && Objects.nonNull(ValhelsiaStructuresModule.this.cutStrippedPosts.blocks.get(this.woodType))) {
                return (BlockState)((BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(Utils.getID((Block)((Block)ValhelsiaStructuresModule.this.cutStrippedPosts.blocks.get(this.woodType))))).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)ATTACHED, (Comparable)((Boolean)state.getValue((Property)ATTACHED)))).setValue((Property)PARTS, (Comparable)((Integer)state.getValue((Property)PARTS)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            }
            return null;
        }
    }

    public class StrippablePostBlock
    extends PostBlock {
        private final WoodType woodType;

        public StrippablePostBlock(WoodType woodType, BlockBehaviour.Properties properties) {
            super(properties);
            this.woodType = woodType;
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)this);
            if (!context.getItemInHand().canPerformAction(itemAbility) || Objects.requireNonNull(location).getPath().contains("stripped")) {
                return null;
            }
            if (itemAbility == ItemAbilities.AXE_STRIP && Objects.nonNull(ValhelsiaStructuresModule.this.strippedPosts.blocks.get(this.woodType))) {
                return (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(Utils.getID((Block)((Block)ValhelsiaStructuresModule.this.strippedPosts.blocks.get(this.woodType))))).defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)))).setValue((Property)ATTACHED, (Comparable)((Boolean)state.getValue((Property)ATTACHED)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            }
            return null;
        }
    }
}

