/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.valhelsia_furniture;

import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskDrawerBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlockEntities;
import net.valhelsia.valhelsia_furniture.core.registry.ModTags;

public class ValhelsiaFurnitureModule
extends SimpleModule {
    public final SimpleEntrySet<net.mehvahdjukaar.moonlight.api.set.wood.WoodType, TableBlock> tables;
    public final SimpleEntrySet<net.mehvahdjukaar.moonlight.api.set.wood.WoodType, ChairBlock> chairs;
    public final SimpleEntrySet<net.mehvahdjukaar.moonlight.api.set.wood.WoodType, ChairBlock> hay_chairs;
    public final SimpleEntrySet<net.mehvahdjukaar.moonlight.api.set.wood.WoodType, StoolBlock> stools;
    public final SimpleEntrySet<net.mehvahdjukaar.moonlight.api.set.wood.WoodType, DeskBlock> desks;
    public final SimpleEntrySet<net.mehvahdjukaar.moonlight.api.set.wood.WoodType, DeskDrawerBlock> desk_drawers;

    public ValhelsiaFurnitureModule(String modId) {
        super(modId, "vf");
        ResourceLocation tab = this.modRes("main");
        this.tables = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(net.mehvahdjukaar.moonlight.api.set.wood.WoodType.class, "table", this.getModBlock("oak_table", TableBlock.class), () -> VanillaWoodTypes.OAK, w -> new TableBlock(w.toVanillaOrOak(), Utils.copyPropertySafe((Block)w.planks))).setRenderType(RenderLayer.CUTOUT).addTexture(this.modRes("block/table/oak/oak_table"))).addTexture(this.modRes("block/table/oak/oak_table_connected"), PaletteStrategies.PLANKS_REMOVE_DARKEST)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ModTags.Blocks.TABLES, Registries.BLOCK)).defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.tables);
        this.chairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(net.mehvahdjukaar.moonlight.api.set.wood.WoodType.class, "chair", this.getModBlock("oak_chair", ChairBlock.class), () -> VanillaWoodTypes.OAK, w -> new CompatChairBlock(w.toVanillaOrOak(), Utils.copyPropertySafe((Block)w.planks), false)).setRenderType(RenderLayer.CUTOUT).addTexture(this.modRes("block/chair/oak/oak_chair"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ModTags.Blocks.CHAIRS, Registries.BLOCK)).defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.chairs);
        this.hay_chairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(net.mehvahdjukaar.moonlight.api.set.wood.WoodType.class, "chair", "hay", this.getModBlock("hay_oak_chair", ChairBlock.class), () -> VanillaWoodTypes.OAK, w -> new CompatChairBlock(w.toVanillaOrOak(), Utils.copyPropertySafe((Block)w.planks), true)).setRenderType(RenderLayer.CUTOUT).addTextureM(this.modRes("block/chair/oak/hay_oak_chair"), EveryCompat.res("block/vf/hay_oak_chair_m"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ModTags.Blocks.CHAIRS, Registries.BLOCK)).defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.hay_chairs);
        this.stools = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(net.mehvahdjukaar.moonlight.api.set.wood.WoodType.class, "stool", this.getModBlock("oak_stool", StoolBlock.class), () -> VanillaWoodTypes.OAK, w -> new StoolBlock(w.toVanillaOrOak(), Utils.copyPropertySafe((Block)w.planks))).setRenderType(RenderLayer.CUTOUT).addTexture(this.modRes("block/stool/oak_stool"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ModTags.Blocks.STOOLS, Registries.BLOCK)).defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.stools);
        this.desks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(net.mehvahdjukaar.moonlight.api.set.wood.WoodType.class, "desk", this.getModBlock("oak_desk", DeskBlock.class), () -> VanillaWoodTypes.OAK, w -> new DeskBlock(w.toVanillaOrOak(), this.modTag(w.getAppendableId() + "_desks"), Utils.copyPropertySafe((Block)w.planks))).addTextureM(this.modRes("block/desk/oak/front"), EveryCompat.res("block/vf/desk_front_m"))).addTexture(this.modRes("block/desk/oak/middle"))).addTexture(this.modRes("block/desk/oak/side"))).addTexture(this.modRes("block/desk/oak/top"))).addTexture(this.modRes("block/desk/oak/top_middle"))).addTexture(this.modRes("block/desk/oak/top_side"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ModTags.Blocks.DESKS, Registries.BLOCK)).addTag(ModTags.Items.DESKS, Registries.ITEM)).defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.desks);
        this.desk_drawers = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(net.mehvahdjukaar.moonlight.api.set.wood.WoodType.class, "desk_drawer", this.getModBlock("oak_desk_drawer", DeskDrawerBlock.class), () -> VanillaWoodTypes.OAK, w -> new DeskDrawerBlock(w.toVanillaOrOak(), this.modTag(w.getAppendableId() + "_desks"), Utils.copyPropertySafe((Block)w.planks))).addTile(ModBlockEntities.DESK_DRAWER).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ModTags.Blocks.DESKS, Registries.BLOCK)).addTag(ModTags.Items.DESKS, Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.desk_drawers);
    }

    private TagKey<Block> modTag(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)EveryCompat.res(name));
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            this.createTagFor("desks", this.desks, this.desk_drawers, sink);
            this.createTagFor("chairs", this.chairs, this.hay_chairs, sink);
            for (net.mehvahdjukaar.moonlight.api.set.wood.WoodType w : this.tables.blocks.keySet()) {
                boolean isTagFull = false;
                SimpleTagBuilder tag = SimpleTagBuilder.of((ResourceLocation)EveryCompat.res(w.getAppendableId() + "_tables"));
                Block block = (Block)this.tables.blocks.get(w);
                if (block != null) {
                    isTagFull = true;
                    tag.addEntry((Object)block);
                }
                if (!isTagFull) continue;
                sink.addTag(tag, Registries.ITEM);
                sink.addTag(tag, Registries.BLOCK);
            }
        });
    }

    public void createTagFor(String blockType, SimpleEntrySet<?, ?> firstBlock, SimpleEntrySet<?, ?> secondBlock, ResourceSink handler) {
        for (BlockType w : firstBlock.blocks.keySet()) {
            boolean isTagFull = false;
            SimpleTagBuilder tag = SimpleTagBuilder.of((ResourceLocation)EveryCompat.res(w.getAppendableId() + "_" + blockType));
            Block firstB = (Block)firstBlock.blocks.get(w);
            Block secondB = (Block)secondBlock.blocks.get(w);
            if (firstB != null) {
                isTagFull = true;
                tag.addEntry((Object)firstB);
            }
            if (secondB != null) {
                isTagFull = true;
                tag.addEntry((Object)secondB);
            }
            if (!isTagFull) continue;
            handler.addTag(tag, Registries.ITEM);
            handler.addTag(tag, Registries.BLOCK);
        }
    }

    public static class CompatChairBlock
    extends ChairBlock {
        private final boolean isHayCHair;

        public CompatChairBlock(WoodType woodType, BlockBehaviour.Properties properties, boolean isHayCHair) {
            super(woodType, properties);
            this.isHayCHair = isHayCHair;
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            if (this.isHayCHair) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.valhelsia_furniture.hay_seat").withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

