/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.variants;

import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.poiUtility;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.FletchingTableBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VariantVanillaBlocksModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> barrel;
    public final SimpleEntrySet<WoodType, Block> beehive;
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> cartography;
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> chiseledBookshelves;
    public final SimpleEntrySet<WoodType, Block> composters;
    public final SimpleEntrySet<WoodType, Block> craftingTable;
    public final SimpleEntrySet<WoodType, Block> fletchingTable;
    public final SimpleEntrySet<WoodType, Block> grindstones;
    public final SimpleEntrySet<WoodType, Block> lectern;
    public final SimpleEntrySet<WoodType, Block> smithingTable;
    public final SimpleEntrySet<WoodType, Block> smoker;

    public VariantVanillaBlocksModule(String modId) {
        super(modId, "vvb", "everycomp");
        ResourceLocation tab = this.modRes(modId);
        this.barrel = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "barrel", this.getModBlock("oak_barrel"), () -> VanillaWoodTypes.OAK, w -> new BarrelBlock(Utils.copyPropertySafe((Block)Blocks.BARREL))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(this.modRes("barrels"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"c:barrels"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"c:barrels_wooden"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTexture(this.modRes("block/oak_barrel_bottom"))).addTextureM(this.modRes("block/oak_barrel_side"), EveryCompat.res("block/vanilla_barrel_side_m"))).addTextureM(this.modRes("block/oak_barrel_top"), EveryCompat.res("block/vanilla_barrel_top_m"))).addTexture(this.modRes("block/oak_barrel_top_open"))).addTile(() -> BlockEntityType.BARREL).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.barrel);
        this.beehive = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "beehive", this.getModBlock("spruce_beehive"), () -> VanillaWoodTypes.SPRUCE, w -> new BeehiveBlock(Utils.copyPropertySafe((Block)Blocks.BEEHIVE))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.BEEHIVES, Registries.BLOCK)).addTag(this.modRes("beehives"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTexture(this.modRes("block/spruce_beehive_end"))).addTexture(this.modRes("block/spruce_beehive_front"))).addTextureM(this.modRes("block/spruce_beehive_front_honey"), EveryCompat.res("block/spruce_beehive_front_honey_m"))).addTextureM(this.modRes("block/spruce_beehive_side"), EveryCompat.res("block/spruce_beehive_side_m"))).addTile(() -> BlockEntityType.BEEHIVE).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.beehive);
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", this.getModBlock("acacia_bookshelf"), () -> VanillaWoodTypes.ACACIA, w -> new Block(Utils.copyPropertySafe((Block)Blocks.BOOKSHELF))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.ENCHANTMENT_POWER_PROVIDER, Registries.BLOCK)).addTag(this.modRes("bookshelves"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"c:bookshelves"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTextureM(this.modRes("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.bookshelves);
        this.cartography = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cartography_table", this.getModBlock("oak_cartography_table"), () -> VanillaWoodTypes.OAK, w -> new CartographyTableBlock(Utils.copyPropertySafe((Block)Blocks.CARTOGRAPHY_TABLE))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("cartography_tables"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTextureM(this.modRes("block/oak_cartography_table_side1"), EveryCompat.res("block/vanilla_cartography_table_side1_m"))).addTextureM(this.modRes("block/oak_cartography_table_side2"), EveryCompat.res("block/vanilla_cartography_table_side2_m"))).addTexture(this.modRes("block/oak_cartography_table_side3"))).addTextureM(this.modRes("block/oak_cartography_table_top"), EveryCompat.res("block/vanilla_cartography_table_top_m"))).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.cartography);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", this.getModBlock("acacia_chest"), () -> VanillaWoodTypes.ACACIA, w -> new CompatChestBlock(this::getTile, Utils.copyPropertySafe((Block)w.planks))).addTile((x$0, x$1) -> new VariantChestBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addModelTransform(m -> m.addModifier((s, blockId, woodType) -> s.replace("\"variantvanillablocks:chest/acacia_chest\"", "\"" + woodType.createFullIdWith("everycomp", "chest", this.shortenedId(), "", "chest") + "\"")))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(this.modRes("chests"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"c:chests_wooden"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"c:chests"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.chests);
        this.chiseledBookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chiseled_bookshelf", this.getModBlock("acacia_chiseled_bookshelf"), () -> VanillaWoodTypes.ACACIA, w -> new ChiseledBookShelfBlock(Utils.copyPropertySafe((Block)w.planks))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("chiseled_bookshelves"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTexture(this.modRes("block/acacia_chiseled_bookshelf_empty"))).addTextureM(this.modRes("block/acacia_chiseled_bookshelf_occupied"), EveryCompat.res("block/vanilla_chiseled_bookshelf_occupied_m"))).addTexture(this.modRes("block/acacia_chiseled_bookshelf_side"))).addTexture(this.modRes("block/acacia_chiseled_bookshelf_top"))).addTile(() -> BlockEntityType.CHISELED_BOOKSHELF).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.chiseledBookshelves);
        this.composters = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "composter", this.getModBlock("oak_composter"), () -> VanillaWoodTypes.OAK, w -> new ComposterBlock(Utils.copyPropertySafe((Block)Blocks.COMPOSTER))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("composters"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTexture(this.modRes("block/oak_composter_bottom"))).addTexture(this.modRes("block/oak_composter_side"))).addTexture(this.modRes("block/oak_composter_top"))).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.composters);
        this.craftingTable = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "crafting_table", this.getModBlock("spruce_crafting_table"), () -> VanillaWoodTypes.SPRUCE, w -> new CraftingTableBlock(this, Utils.copyPropertySafe((Block)w.planks)){}).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("crafting_tables"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTextureM(EveryCompat.res("block/spruce_crafting_table_front"), EveryCompat.res("block/vct/spruce_crafting_table_front_m"))).addTextureM(EveryCompat.res("block/spruce_crafting_table_side"), EveryCompat.res("block/vct/spruce_crafting_table_side_m"))).addTextureM(EveryCompat.res("block/spruce_crafting_table_top"), EveryCompat.res("block/vct/spruce_crafting_table_top_m"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.craftingTable);
        this.fletchingTable = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "fletching_table", this.getModBlock("oak_fletching_table"), () -> VanillaWoodTypes.OAK, w -> new FletchingTableBlock(this, Utils.copyPropertySafe((Block)Blocks.FLETCHING_TABLE)){}).addTag(BlockTags.MINEABLE_WITH_PICKAXE, Registries.BLOCK)).addTag(this.modRes("fletching_tables"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTextureM(this.modRes("block/oak_fletching_table_front"), EveryCompat.res("block/vanilla_fletching_table_front_m"))).addTextureM(this.modRes("block/oak_fletching_table_side"), EveryCompat.res("block/vanilla_fletching_table_side_m"))).addTextureM(this.modRes("block/oak_fletching_table_top"), EveryCompat.res("block/vanilla_fletching_table_top_m"))).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.fletchingTable);
        this.grindstones = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "grindstone", this.getModBlock("oak_grindstone"), () -> VanillaWoodTypes.OAK, w -> new GrindstoneBlock(this, Utils.copyPropertySafe((Block)Blocks.GRINDSTONE)){}).addTag(BlockTags.MINEABLE_WITH_PICKAXE, Registries.BLOCK)).addTag(this.modRes("grindstones"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTexture(this.modRes("block/oak_grindstone_pivot"))).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.grindstones);
        this.lectern = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "lectern", this.getModBlock("acacia_lectern"), () -> VanillaWoodTypes.ACACIA, w -> new LecternBlock(this, Utils.copyPropertySafe((Block)Blocks.LECTERN)){}).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("lecterns"), Registries.BLOCK)).addTag(this.modRes("lecterns"), Registries.ITEM)).addTextureM(this.modRes("block/acacia_lectern_base"), EveryCompat.res("block/vanilla_lectern_base_m"))).addTextureM(this.modRes("block/acacia_lectern_front"), EveryCompat.res("block/vanilla_lectern_front_m"))).addTexture(this.modRes("block/acacia_lectern_sides"))).addTexture(this.modRes("block/acacia_lectern_top"))).addTile(() -> BlockEntityType.LECTERN).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.lectern);
        this.smithingTable = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "smithing_table", this.getModBlock("oak_smithing_table"), () -> VanillaWoodTypes.OAK, w -> new SmithingTableBlock(this, Utils.copyPropertySafe((Block)Blocks.SMITHING_TABLE)){}).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("smithing_tables"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTextureM(this.modRes("block/oak_smithing_table_bottom"), EveryCompat.res("block/vanilla_smithing_table_bottom_m"))).addTextureM(this.modRes("block/oak_smithing_table_front"), EveryCompat.res("block/vanilla_smithing_table_front_m"))).addTextureM(this.modRes("block/oak_smithing_table_side"), EveryCompat.res("block/vanilla_smithing_table_side_m"))).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.smithingTable);
        this.smoker = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "smoker", this.getModBlock("acacia_smoker"), () -> VanillaWoodTypes.ACACIA, w -> new SmokerBlock(this, Utils.copyPropertySafe((Block)Blocks.SMOKER)){}).addTag(BlockTags.MINEABLE_WITH_PICKAXE, Registries.BLOCK)).addTag(this.modRes("smokers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTextureM(this.modRes("block/acacia_smoker_front"), EveryCompat.res("block/vanilla_smoker_front_m"))).addTextureM(this.modRes("block/acacia_smoker_front_on"), EveryCompat.res("block/vanilla_smoker_front_on_m"))).addTextureM(this.modRes("block/acacia_smoker_side"), EveryCompat.res("block/vanilla_smoker_side_m"))).addTextureM(this.modRes("block/acacia_smoker_top"), EveryCompat.res("block/vanilla_smoker_x_m"))).addTextureM(this.modRes("block/acacia_smoker_bottom"), EveryCompat.res("block/vanilla_smoker_x_m"))).addTile(() -> BlockEntityType.SMOKER).copyParentDrop().defaultRecipe().setTabKey(tab)).build();
        this.addEntry(this.smoker);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    @Override
    public void onModInit() {
        super.onModInit();
        poiUtility.simpleAddBlocksToPOI(this.beehive, (ResourceKey<PoiType>)PoiTypes.BEEHIVE);
        poiUtility.simpleAddBlocksToPOI(this.barrel, (ResourceKey<PoiType>)PoiTypes.FISHERMAN);
        poiUtility.simpleAddBlocksToPOI(this.cartography, (ResourceKey<PoiType>)PoiTypes.CARTOGRAPHER);
        poiUtility.simpleAddBlocksToPOI(this.composters, (ResourceKey<PoiType>)PoiTypes.FARMER);
        poiUtility.simpleAddBlocksToPOI(this.fletchingTable, (ResourceKey<PoiType>)PoiTypes.FLETCHER);
        poiUtility.simpleAddBlocksToPOI(this.grindstones, (ResourceKey<PoiType>)PoiTypes.WEAPONSMITH);
        poiUtility.simpleAddBlocksToPOI(this.lectern, (ResourceKey<PoiType>)PoiTypes.LIBRARIAN);
        poiUtility.simpleAddBlocksToPOI(this.smithingTable, (ResourceKey<PoiType>)PoiTypes.TOOLSMITH);
        poiUtility.simpleAddBlocksToPOI(this.smoker, (ResourceKey<PoiType>)PoiTypes.BUTCHER);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        CompatChestBlockRenderer.register(event, this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> this.chests.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/acacia_chest"), EveryCompat.res("entity/vvb/oak_chest_m"), EveryCompat.res("model/oak_chest_normal_o"), null);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/acacia_chest_left"), EveryCompat.res("entity/vvb/oak_chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), null);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/acacia_chest_right"), EveryCompat.res("entity/vvb/oak_chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), null);
        }));
    }

    private class VariantChestBlockEntity
    extends CompatChestBlockEntity {
        public VariantChestBlockEntity(VariantVanillaBlocksModule variantVanillaBlocksModule, BlockPos pos, BlockState state) {
            super(variantVanillaBlocksModule.chests.getTile(), pos, state);
        }
    }
}

