package net.mehvahdjukaar.every_compat.modules.exlines;

import com.exline.barkcarpets.block.BarkCarpetBlock;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_3481;
import net.minecraft.class_7924;


public class BarkCarpetsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, BarkCarpetBlock> barkCarpets;

    public BarkCarpetsModule(String modId) {
        super(modId, "bc");


        barkCarpets = SimpleEntrySet.builder(WoodType.class, "bark_carpet",
                        getModBlock("oak_bark_carpet", BarkCarpetBlock.class), () -> VanillaWoodTypes.OAK,
                        w -> new BarkCarpetBlock(Utils.copyPropertySafe(w.log)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .setTabKey(modRes("tab"))
                .defaultRecipe()
                .build();

        this.addEntry(barkCarpets);
    }
}
