package net.mehvahdjukaar.every_compat.modules.fabric.bewitchment;

import com.google.gson.JsonObject;
import moriyashiine.bewitchment.api.block.PoppetShelfBlock;
import moriyashiine.bewitchment.common.Bewitchment;
import moriyashiine.bewitchment.common.registry.BWBlockEntityTypes;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWTags;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_7924;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.util.Objects;
import java.util.function.Consumer;

//SUPPORT: v1.20-8
public class BewitchmentModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> poppet_shelf;
    public final ItemOnlyEntrySet<WoodType, class_1792> bark;

    public BewitchmentModule(String modId) {
        super(modId, "bw");
        class_2960 tab = modRes(Bewitchment.MOD_ID);

        poppet_shelf = SimpleEntrySet.builder(WoodType.class, "poppet_shelf",
                        getModBlock("oak_poppet_shelf"), () -> VanillaWoodTypes.OAK,
                        w -> new PoppetShelfBlock(FabricBlockSettings.copyOf(w.planks)
                                .pistonBehavior(class_3619.field_15972)
                                .nonOpaque()
                        )
                )
                .requiresChildren("slab") // Recipes
                .addTile(() -> BWBlockEntityTypes.POPPET_SHELF)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(poppet_shelf);

        bark = ItemOnlyEntrySet.builder(WoodType.class, "bark",
                        () -> BWObjects.OAK_BARK, () -> VanillaWoodTypes.OAK,
                        w -> new class_1792(new class_1792.class_1793())
                )
                .requiresChildren("stripped_log") // Recipes
                .addTexture(modRes("item/oak_bark"), PaletteStrategies.LOG_SIDE_STANDARD)
                .addTag(BWTags.BARKS, class_7924.field_41197)
                .setTabKey(tab)
                .build();
        this.addEntry(bark);

    }

    @Override
    // RECIPES
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, sink) -> {

            String recipePath_1 = "athame_stripping/oak_bark_from_oak_log";
            String recipePath_2 = "athame_stripping/oak_bark_from_oak_wood";

            try (InputStream recipeStream_1 = manager.method_14486(ResType.RECIPES.getPath(modRes(recipePath_1)))
                    .orElseThrow(() -> new FileSystemNotFoundException(
                            "Failed to get recipe at location: " + modRes(recipePath_1).toString())).method_14482();
                 InputStream recipeStream_2 = manager.method_14486(ResType.RECIPES.getPath(modRes(recipePath_2)))
                         .orElseThrow(() -> new FileSystemNotFoundException(
                                 "Failed to get recipe at location: " + modRes(recipePath_2).toString())).method_14482()
            ) {
                JsonObject recipe_1 = RPUtils.deserializeJson(recipeStream_1);
                JsonObject recipe_2 = RPUtils.deserializeJson(recipeStream_2);

                bark.items.forEach((wood, item) -> {
                    // Replacing "oak" in the path
                    String prefix = shortenedId() + "/" + wood.getNamespace() + "/";

                    String newPath_1 = prefix + recipePath_1.replace("oak", wood.getTypeName());
                    String newPath_2 = prefix + recipePath_2.replace("oak", wood.getTypeName());

                    // Editing recipe_1
                    recipe_1.addProperty("log",
                            Utils.getID(wood.log).toString());
                    recipe_1.addProperty("stripped_log",
                            Utils.getID(wood.getBlockOfThis("stripped_log")).toString());
                    recipe_1.getAsJsonObject("result").addProperty("item",
                            Utils.getID(item).toString());

                    // Adding to Resources
                    sink.addJson(EveryCompat.res(newPath_1), recipe_1, ResType.RECIPES);

                    // Null check for wood - some wood mods doesn't include <type>_wood
                    if (Objects.nonNull(wood.getBlockOfThis("wood"))) {
                        // Editing recipe_2
                        recipe_2.addProperty("log",
                                Utils.getID(wood.getBlockOfThis("wood")).toString());
                        recipe_2.addProperty("stripped_log",
                                Utils.getID(wood.getBlockOfThis("stripped_wood")).toString());
                        recipe_2.getAsJsonObject("result").addProperty("item",
                                Utils.getID(item).toString());

                        // Adding to Resources
                        sink.addJson(EveryCompat.res(newPath_2), recipe_2, ResType.RECIPES);
                    }
                });
            } catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to open the recipe: ", e);
            }

        });

    }
}