package net.mehvahdjukaar.every_compat.modules.fabric.clutter;

import net.emilsg.clutter.block.ModBlockEntities;
import net.emilsg.clutter.block.custom.*;
import net.emilsg.clutter.util.ModBlockTags;
import net.emilsg.clutter.util.ModItemGroups;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.function.ToIntFunction;

//SUPPORT: v0.6.0+
public class ClutterModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> wall_bookshelves;
    public final SimpleEntrySet<WoodType, class_2248> window_sills;
    public final SimpleEntrySet<WoodType, class_2248> tables;
    public final SimpleEntrySet<WoodType, class_2248> stripped_tables;
    public final SimpleEntrySet<WoodType, class_2248> chairs;
    public final SimpleEntrySet<WoodType, class_2248> stripped_chairs;
    public final SimpleEntrySet<WoodType, class_2248> wall_cupboards;
    public final SimpleEntrySet<WoodType, class_2248> shelves;
    public final SimpleEntrySet<WoodType, class_2248> cupboards;
    public final SimpleEntrySet<WoodType, class_2248> trellises;
    public final SimpleEntrySet<WoodType, class_2248> benches;
    public final SimpleEntrySet<WoodType, class_2248> stripped_benches;
    public final SimpleEntrySet<WoodType, class_2248> mosaic_planks;
    public final SimpleEntrySet<WoodType, class_2248> mosaic_stairs;
    public final SimpleEntrySet<WoodType, class_2248> mosaic_slabs;

    public final HashMap<class_2248, class_2248> mapTables = new HashMap<>();
    public final HashMap<class_2248, class_2248> mapChairs = new HashMap<>();
    public final HashMap<class_2248, class_2248> mapBenches = new HashMap<>();

    public ClutterModule(String modId) {
        super(modId, "clu");
        var tab = ModItemGroups.CLUTTER_BLOCKS;

        wall_bookshelves = SimpleEntrySet.builder(WoodType.class, "wall_bookshelf",
                        getModBlock("oak_wall_bookshelf"), () -> VanillaWoodTypes.OAK,
                        w -> new WallBookshelfBlock(FabricBlockSettings.copyOf(w.planks)
                                .luminance(createLightLevelFromLitBlockState())
                        )
                )
                .addTile(() -> ModBlockEntities.WALL_BOOKSHELF)
                //TEXTURES: planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.BOOKSHELVES, class_7924.field_41254)
                .addTag(class_3481.field_44472, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModBlockTags.C_BOOKSHELVES, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(wall_bookshelves);

        window_sills = SimpleEntrySet.builder(WoodType.class, "window_sill",
                        getModBlock("oak_window_sill"), () -> VanillaWoodTypes.OAK,
                        w -> new WindowSillBlock(Utils.copyPropertySafe(w.planks))
                )
                .setRenderType(RenderLayer.CUTOUT)
                //TEXTURES: planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.WINDOW_SILLS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(window_sills);

        tables = SimpleEntrySet.builder(WoodType.class, "table",
                        getModBlock("oak_table"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatTableBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: log & planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.TABLES, class_7924.field_41254)
                .addTag(ModBlockTags.STRIPPABLE_TABLES, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)|betternether:(nether_mushroom|nether_reed)")
                .build();
        this.addEntry(tables);

        stripped_tables = SimpleEntrySet.builder(WoodType.class, "table", "stripped",
                        getModBlock("stripped_oak_table"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatTableBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes & textures
                //TEXTURES: stripped_log & planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.TABLES, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)|betternether:(nether_mushroom|nether_reed)")
                .build();
        this.addEntry(stripped_tables);


        chairs = SimpleEntrySet.builder(WoodType.class, "chair",
                        getModBlock("oak_chair"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatChairBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: log & planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.STRIPPABLE_CHAIRS, class_7924.field_41254)
                .addTag(ModBlockTags.WOODEN_CHAIRS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)|betternether:(nether_mushroom|nether_reed)")
                .build();
        this.addEntry(chairs);

        stripped_chairs = SimpleEntrySet.builder(WoodType.class, "chair", "stripped",
                        getModBlock("stripped_oak_chair"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatChairBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes & textures
                //TEXTURES: stripped_log & planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.WOODEN_CHAIRS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)|betternether:(nether_mushroom|nether_reed)")
                .build();
        this.addEntry(stripped_chairs);


        cupboards = SimpleEntrySet.builder(WoodType.class, "cupboard",
                        getModBlock("oak_cupboard"), () -> VanillaWoodTypes.OAK,
                        w -> new CupboardBlock(FabricBlockSettings.copyOf(w.planks).nonOpaque())
                )
                .addTile(() -> ModBlockEntities.CUPBOARD)
                //TEXTURES: planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.CUPBOARDS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTexture(modRes("block/oak_cupboard_inside"))
                .addTexture(modRes("block/oak_cupboard_door"))
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(cupboards);

        wall_cupboards = SimpleEntrySet.builder(WoodType.class, "wall_cupboard",
                        getModBlock("oak_wall_cupboard"), () -> VanillaWoodTypes.OAK,
                        w -> new WallCupboardBlock(FabricBlockSettings.copyOf(w.planks).nonOpaque())
                )
                .addTile(() -> ModBlockEntities.WALL_CUPBOARD)
                //TEXTURES: using cupboards' above
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.CUPBOARDS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(wall_cupboards);

        shelves = SimpleEntrySet.builder(WoodType.class, "shelf",
                        getModBlock("oak_shelf"), () -> VanillaWoodTypes.OAK,
                        w -> new ShelfBlock(FabricBlockSettings.copyOf(w.planks).nonOpaque())
                )
                .addTile(() -> ModBlockEntities.SHELF)
                //TEXTURES: log & planks
                .addTag(ModBlockTags.SHELVES, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)")
                .build();
        this.addEntry(shelves);

        trellises = SimpleEntrySet.builder(WoodType.class, "trellis",
                        getModBlock("oak_trellis"), () -> VanillaWoodTypes.OAK,
                        w -> new TrellisBlock(FabricBlockSettings.copyOf(w.planks)
                                .luminance(TrellisBlock.createLightLevelFromLitBlockState()))
                )
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                //TEXTURES: log
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.TRELLISES, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .addTag(class_3481.field_36327, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(trellises);

        benches = SimpleEntrySet.builder(WoodType.class, "bench",
                        getModBlock("oak_bench"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatBenchBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: log & planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.BENCHES, class_7924.field_41254)
                .addTag(ModBlockTags.STRIPPABLE_BENCHES, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)")
                .build();
        this.addEntry(benches);

        stripped_benches = SimpleEntrySet.builder(WoodType.class, "bench", "stripped",
                        getModBlock("stripped_oak_bench"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatBenchBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes & textures
                //TEXTURES: stripped_log & planks
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.BENCHES, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                //REASON: Take a look at their //TEXTURES, you'll see why. Excluded!
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)")
                .build();
        this.addEntry(stripped_benches);

        mosaic_planks = SimpleEntrySet.builder(WoodType.class, "mosaic",
                        getModBlock("oak_mosaic"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2248(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/oak_mosaic"))
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.WOODEN_MOSAICS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic_planks);

        mosaic_stairs = SimpleEntrySet.builder(WoodType.class, "mosaic_stairs",
                        getModBlock("oak_mosaic_stairs"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2510(copyStairs(w),
                                Utils.copyPropertySafe(w.planks))
                )
                .setRenderType(RenderLayer.CUTOUT)
                //TEXTURES: using mosaic_planks' above
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.WOODEN_MOSAICS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15459, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic_stairs);

        mosaic_slabs = SimpleEntrySet.builder(WoodType.class, "mosaic_slab",
                        getModBlock("oak_mosaic_slab"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2482(copySlabs(w))
                )
                .setRenderType(RenderLayer.CUTOUT)
                //TEXTURES: using mosaic_planks' above
                .addTag(ModBlockTags.FLAMMABLE, class_7924.field_41254)
                .addTag(ModBlockTags.WOODEN_MOSAICS, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15469, class_7924.field_41254)
                .addTag(class_3481.field_15468, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic_slabs);


    }

// METHODS
    private static ToIntFunction<class_2680> createLightLevelFromLitBlockState() {
        return (state) -> (Boolean)state.method_11654(class_2741.field_12548) ? 8 : 0;
    }

    public class_2680 copyStairs(WoodType woodType) {
        class_2248 stairs = woodType.getBlockOfThis("stairs");
        return (stairs != null) ? stairs.method_9564() : class_2246.field_10563.method_9564();
    }

    public class_4970.class_2251 copySlabs(WoodType woodType) {
        class_2248 slab = woodType.getBlockOfThis("slab");
        return (slab != null) ? Utils.copyPropertySafe(slab): Utils.copyPropertySafe(class_2246.field_10119);
    }

    // Making these blocks be strippable
    @Override
    public void onModSetup() {
        super.onModSetup();

        tables.blocks.forEach((wood, block) -> {
            putBlocksIn(mapTables, block, stripped_tables.blocks.get(wood));

            //CHAIRS
            putBlocksIn(mapChairs, chairs.blocks.get(wood), stripped_chairs.blocks.get(wood));

            //BENCHES
            putBlocksIn(mapBenches, benches.blocks.get(wood), stripped_benches.blocks.get(wood));
        });
    }

    private void putBlocksIn(HashMap<class_2248, class_2248> hashmap, class_2248 block, class_2248 strippedBlock) {
            hashmap.computeIfAbsent(block, key -> strippedBlock);
    }


// COMPAT CLASSES
    public class CompatTableBlock extends TableBlock {

        public CompatTableBlock(class_2251 properties) {
            super(properties);
        }

        private class_2680 getStrippedState(class_2680 state) {
            return mapTables.get(state.method_26204()).method_9564().method_11657(LEGS, state.method_11654(LEGS)).method_11657(LEG_POSITIONS, state.method_11654(LEG_POSITIONS));
        }

        @Override
        public @NotNull class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            class_1799 itemStack = player.method_5998(hand);

            if (itemStack.method_7909() instanceof class_1743 && state.method_26164(ModBlockTags.STRIPPABLE_TABLES)) {
                class_2680 strippedState = this.getStrippedState(state);

                world.method_8501(pos, strippedState);
                world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 1.0F, 1.0F);

                if (!player.method_7337()) {
                    itemStack.method_7956(1, player, (p) -> p.method_20236(hand));
                }

                return class_1269.field_5812;
            } else {
                return class_1269.field_5811;
            }
        }
    }

    public class CompatChairBlock extends WoodenChairBlock {
        public CompatChairBlock(class_2251 properties) {
            super(properties);
        }

        private class_2680 getStrippedState(class_2680 state) {
            return mapChairs.get(state.method_26204()).method_9564().method_11657(field_11177, state.method_11654(field_11177));
        }

        @Override
        public @NotNull class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7909() instanceof class_1743 && state.method_26164(ModBlockTags.STRIPPABLE_CHAIRS)) {
                class_2680 strippedState = this.getStrippedState(state);
                world.method_8501(pos, strippedState);
                world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 1.0F, 1.0F);
                if (!player.method_7337()) {
                    itemStack.method_7956(1, player, (p) -> p.method_20236(hand));
                }

                return class_1269.field_5812;
            } else {
                return class_1269.field_5811;
            }
        }
    }

    public class CompatBenchBlock extends WoodenBenchBlock {

        public CompatBenchBlock(class_2251 properties) {
            super(properties);
        }

        private class_2680 getStrippedState(class_2680 state) {
            return mapBenches.get(state.method_26204()).method_9564().method_11657(field_11177, state.method_11654(field_11177))
                    .method_11657(LEG_POSITIONS, state.method_11654(LEG_POSITIONS));
        }

        @Override
        public @NotNull class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7909() instanceof class_1743 && state.method_26164(ModBlockTags.STRIPPABLE_BENCHES)) {
                class_2680 strippedState = this.getStrippedState(state);
                world.method_8501(pos, strippedState);
                world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 1.0F, 1.0F);
                if (!player.method_7337()) {
                    itemStack.method_7956(1, player, (p) -> p.method_20236(hand));
                }

                return class_1269.field_5812;
            } else {
                return class_1269.field_5811;
            }
        }

    }
}