package net.mehvahdjukaar.every_compat.modules.fabric.infinitybuttons;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.larsmans.infinitybuttons.block.InfinityButtonsBlocks;
import net.larsmans.infinitybuttons.block.custom.button.WoodenButton;
import net.larsmans.infinitybuttons.block.custom.secretbutton.PlankSecretButton;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_7924;

//SUPPORT: v4.0.5+
public class InfinityButtonsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> largeButtons;
    public final SimpleEntrySet<WoodType, class_2248> plankSecretButtons;

    public InfinityButtonsModule(String modId) {
        super(modId, "ib");
        class_2960 tab = modRes(modId);

        largeButtons = SimpleEntrySet.builder(WoodType.class, "large_button",
                        () -> InfinityButtonsBlocks.OAK_LARGE_BUTTON, () -> VanillaWoodTypes.OAK,
                        woodType -> new WoodenButton(FabricBlockSettings.copyOf(class_2246.field_10057)
                                .method_9632(0.5f).collidable(false).nonOpaque().sounds(class_2498.field_11547)
                                .pistonBehavior(class_3619.field_15971),
                                true, woodType.canBurn())
                )
                .addTag(modRes("wooden_large_buttons"), class_7924.field_41254)
                .addTag(modRes("wooden_large_buttons"), class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(largeButtons);

        plankSecretButtons = SimpleEntrySet.builder(WoodType.class, "plank_secret_button",
                        () -> InfinityButtonsBlocks.OAK_PLANK_SECRET_BUTTON, () -> VanillaWoodTypes.OAK,
                        woodType -> new PlankSecretButton(FabricBlockSettings.copyOf(woodType.planks)
                                .method_9629(2.0f, 3.0f).burnable()
                                .nonOpaque().method_9626(class_2498.field_11547).method_50012(class_3619.field_15971),
                                woodType.planks)
                )
                .addTag(modRes("wooden_secret_buttons"), class_7924.field_41254)
                .addTag(modRes("wooden_secret_buttons"), class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(plankSecretButtons);
    }
}
