/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class UtilityTag {
    public static final ResourceLocation SILICA_TAG = UtilityTag.platformTag("silica_glass", "silica");
    public static final ResourceLocation GLASS_TAG = UtilityTag.platformTag("glass_blocks", "glass");
    public static final ResourceLocation GLASS_PANE_TAG = UtilityTag.platformTag("glass_panes");

    public static ResourceLocation getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink sink, ResourceManager manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        ResourceLocation RLocLogs = new ResourceLocation(resLocMOD + "_" + suffixTag);
        ResourceLocation RLocStems = new ResourceLocation(resLocMOD + "_" + suffixAlt);
        ResourceLocation RLocFolders = new ResourceLocation(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName());
        ResourceLocation RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (UtilityTag.doTagExistFor(RLocLogs, manager)) {
            return RLocLogs;
        }
        if (UtilityTag.doTagExistFor(RLocStems, manager)) {
            return RLocStems;
        }
        if (UtilityTag.doTagExistFor(RLocEC, manager)) {
            return RLocEC;
        }
        if (UtilityTag.doTagExistFor(RLocFolders, manager)) {
            return RLocFolders;
        }
        UtilityTag.createAndAddDefaultTags(RLocEC, sink, blockType, new Block[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(ResourceLocation resLoc, ResourceSink sink, BlockType blockType, Block ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return UtilityTag.createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return UtilityTag.createAndAddCustomTags(resLoc, sink, blocks);
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Block ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Block block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.f_256747_);
            sink.addTag(tagBuilder, Registries.f_256913_);
        }
        return isTagCreated;
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Item ... items) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Item item : items) {
            if (item == null) continue;
            tagBuilder.addEntry((Object)item);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.f_256913_);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameBlockTypeOrRegEx, String fromModId, String tagResLoc, boolean includeBlock, boolean includeItem, ResourceSink sink) {
        UtilityTag.addTagToAllBlocks(blocks, nameBlockTypeOrRegEx, fromModId, tagResLoc, includeBlock, includeItem, sink, null);
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameBlockTypeOrRegEx, String fromModId, String tagResLoc, boolean includeBlock, boolean includeItem, ResourceSink pack, @Nullable String regexBlockId) {
        if (PlatHelper.isModLoaded((String)fromModId) || fromModId.isEmpty()) {
            if (!((String)tagResLoc).contains(":")) {
                tagResLoc = fromModId + ":" + (String)tagResLoc;
            }
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)new ResourceLocation((String)tagResLoc));
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType blockType = (BlockType)entry.getKey();
                Block block = (Block)entry.getValue();
                String blockPath = Utils.getID((Block)block).m_135815_();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!blockType.getId().toString().matches(fromModId + ":" + nameBlockTypeOrRegEx) && !fromModId.isEmpty() || regexBlockId != null && !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.f_256747_);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.f_256913_);
                }
            }
        }
    }

    public static Pair<ResourceLocation, Boolean> getATagId(String idTag, String idAlt, ResourceManager manager) {
        ResourceLocation RLocId = new ResourceLocation(idTag);
        ResourceLocation RLocIdAlt = new ResourceLocation(idAlt);
        if (UtilityTag.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (UtilityTag.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(ResourceLocation resLoc, ResourceManager manager) {
        boolean blockTag = manager.m_213713_(ResType.TAGS.getPath(resLoc.m_246208_("blocks/"))).isPresent();
        boolean itemTag = manager.m_213713_(ResType.TAGS.getPath(resLoc.m_246208_("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static ResourceLocation platformTag(String tagPath) {
        return UtilityTag.platformTag(tagPath, tagPath);
    }

    public static ResourceLocation platformTag(String fabric, String forge) {
        return PlatHelper.getPlatform().isFabric() ? UtilityTag.fabricTag(fabric) : UtilityTag.forgeTag(forge);
    }

    public static ResourceLocation fabricTag(String tagPath) {
        return new ResourceLocation("c", tagPath);
    }

    public static ResourceLocation forgeTag(String tagPath) {
        return new ResourceLocation("forge", tagPath);
    }
}

