/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.graveyard;

import com.finallion.graveyard.blockentities.SarcophagusBlockEntity;
import com.finallion.graveyard.blockentities.enums.SarcophagusPart;
import com.finallion.graveyard.blockentities.render.SarcophagusBlockEntityRenderer;
import com.finallion.graveyard.blocks.SarcophagusBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.mehvahdjukaar.every_compat.modules.neoforge.graveyard.GraveyardModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompatCoffinRenderer
extends SarcophagusBlockEntityRenderer<GraveyardModule.CompatCoffinBlockTile> {
    public CompatCoffinRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(SarcophagusBlockEntity entity, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState blockState = entity.getBlockState();
        DoubleBlockCombiner.NeighborCombineResult propertySource = DoubleBlockCombiner.combineWithNeigbour(GraveyardModule.COFFIN_TILE, SarcophagusBlock::getBlockType, SarcophagusBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockState, (LevelAccessor)entity.getLevel(), (BlockPos)entity.getBlockPos(), (worldx, pos) -> false);
        float g = ((Float2FloatFunction)propertySource.apply(SarcophagusBlock.opennessCombiner((LidBlockEntity)entity))).get(tickDelta);
        g = 1.0f - g;
        g = 1.0f - g * g * g;
        String base = ((SarcophagusBlock)blockState.getBlock()).getBase();
        String lid = ((SarcophagusBlock)blockState.getBlock()).getLid();
        BakedModel baseModel = this.getCustomModel(base);
        BakedModel lidModel = this.getCustomModel(lid);
        if (entity.getLevel() != null && entity.getBlockState().getValue((Property)SarcophagusBlock.PART) == SarcophagusPart.HEAD) {
            this.render(entity, matrixStack, vertexConsumers, light, overlay, g, lidModel, true);
            this.render(entity, matrixStack, vertexConsumers, light, overlay, g, baseModel, false);
        }
    }

    private BakedModel getCustomModel(String base) {
        return null;
    }

    private void render(SarcophagusBlockEntity entity, PoseStack matrixStack, MultiBufferSource vertexConsumer, int light, int overlay, float g, BakedModel model, boolean isLid) {
        matrixStack.pushPose();
        Direction direction = ((Direction)entity.getBlockState().getValue((Property)SarcophagusBlock.FACING)).getOpposite();
        float f = direction.toYRot();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-f));
        switch (direction) {
            case EAST: {
                matrixStack.translate(-1.0, 0.0, 1.0);
                break;
            }
            case SOUTH: {
                matrixStack.translate(0.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                matrixStack.translate(-1.0, 0.0, 0.0);
            }
        }
        if (isLid) {
            matrixStack.translate((double)g * 0.3, (double)g * 0.3, 0.0);
            matrixStack.mulPose(Axis.ZN.rotationDegrees(g * 45.0f));
        }
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrixStack.last(), vertexConsumer.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)entity.getBlockState(), (boolean)true)), entity.getBlockState(), model, 1.0f, 1.0f, 1.0f, light, overlay);
        matrixStack.popPose();
    }
}

