package net.mehvahdjukaar.every_compat.modules.forge.mcaw;

import com.mcwwindows.kikoz.init.BlockInit;
import com.mcwwindows.kikoz.objects.*;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;

//SUPPORT: v2.2.1+
public class MacawWindowsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> window;
    public final SimpleEntrySet<WoodType, Block> window2;
    public final SimpleEntrySet<WoodType, Block> fourWindow;
    public final SimpleEntrySet<WoodType, Block> strippedLogWindow;
    public final SimpleEntrySet<WoodType, Block> strippedLogWindow2;
    public final SimpleEntrySet<WoodType, Block> strippedLogFourWindow;
    public final SimpleEntrySet<WoodType, Block> plankWindow;
    public final SimpleEntrySet<WoodType, Block> plankWindow2;
    public final SimpleEntrySet<WoodType, Block> plankFourWindow;
    public final SimpleEntrySet<WoodType, Block> paneWindow;
    public final SimpleEntrySet<WoodType, Block> strippedPaneWindow;
    public final SimpleEntrySet<WoodType, Block> plankPaneWindow;
    public final SimpleEntrySet<WoodType, Block> logParapet;
    public final SimpleEntrySet<WoodType, Block> plankParapet;
    public final SimpleEntrySet<WoodType, Block> blinds;
    public final SimpleEntrySet<WoodType, Block> shutter;
    public final SimpleEntrySet<WoodType, Block> louveredShutter;

    public MacawWindowsModule(String modId) {
        super(modId, "mcw");
        ResourceLocation tab = modRes(modId);

        window = SimpleEntrySet.builder(WoodType.class, "window",
                        BlockInit.OAK_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new ConnectedWindow(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(window);

        window2 = SimpleEntrySet.builder(WoodType.class, "window2",
                        BlockInit.OAK_WINDOW2, () -> VanillaWoodTypes.OAK,
                        w -> new WindowBarred(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows_two"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(window2);

        fourWindow = SimpleEntrySet.builder(WoodType.class, "four_window",
                        BlockInit.OAK_FOUR_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new WindowBarred(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows_four"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(fourWindow);

        strippedLogWindow = SimpleEntrySet.builder(WoodType.class, "log_window", "stripped",
                        BlockInit.STRIPPED_OAK_LOG_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new ConnectedWindow(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                //TEXTURES: stripped_log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(strippedLogWindow);

        strippedLogWindow2 = SimpleEntrySet.builder(WoodType.class, "log_window2", "stripped",
                        BlockInit.STRIPPED_OAK_LOG_WINDOW2, () -> VanillaWoodTypes.OAK,
                        w -> new WindowBarred(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                //TEXTURES: stripped_log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows_two"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(strippedLogWindow2);

        strippedLogFourWindow = SimpleEntrySet.builder(WoodType.class, "log_four_window", "stripped",
                        BlockInit.STRIPPED_OAK_LOG_FOUR_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new WindowBarred(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                //TEXTURES: stripped_log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows_four"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(strippedLogFourWindow);

        plankWindow = SimpleEntrySet.builder(WoodType.class, "plank_window",
                        BlockInit.OAK_PLANK_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new ConnectedWindow(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(plankWindow);

        plankWindow2 = SimpleEntrySet.builder(WoodType.class, "plank_window2",
                        BlockInit.OAK_PLANK_WINDOW2, () -> VanillaWoodTypes.OAK,
                        w -> new WindowBarred(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows_two"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(plankWindow2);

        plankFourWindow = SimpleEntrySet.builder(WoodType.class, "plank_four_window",
                        BlockInit.OAK_PLANK_FOUR_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new WindowBarred(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("windows_four"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(plankFourWindow);

        paneWindow = SimpleEntrySet.builder(WoodType.class, "pane_window",
                        BlockInit.OAK_PANE_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new Window(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("pane_windows"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(paneWindow);

        strippedPaneWindow = SimpleEntrySet.builder(WoodType.class, "pane_window", "stripped",
                        BlockInit.STRIPPED_OAK_PANE_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new Window(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                //TEXTURES: stripped_log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("pane_windows"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(strippedPaneWindow);

        plankPaneWindow = SimpleEntrySet.builder(WoodType.class, "plank_pane_window",
                        BlockInit.OAK_PLANK_PANE_WINDOW, () -> VanillaWoodTypes.OAK,
                        w -> new Window(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(modRes("pane_windows"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(plankPaneWindow);

        logParapet = SimpleEntrySet.builder(WoodType.class, "log_parapet",
                        BlockInit.OAK_LOG_PARAPET, () -> VanillaWoodTypes.OAK,
                        w -> new Parapet(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("parapets"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(logParapet);

        plankParapet = SimpleEntrySet.builder(WoodType.class, "plank_parapet",
                        BlockInit.OAK_PLANK_PARAPET, () -> VanillaWoodTypes.OAK,
                        w -> new Parapet(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("parapets"), Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(plankParapet);

        blinds = SimpleEntrySet.builder(WoodType.class, "blinds",
                        BlockInit.OAK_BLINDS, () -> VanillaWoodTypes.OAK,
                        w -> new Blinds(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: textures
                //TEXTURES: log, stripped_log, planks
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("blinds"), Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(blinds);

        shutter = SimpleEntrySet.builder(WoodType.class, "shutter",
                        BlockInit.OAK_SHUTTER, () -> VanillaWoodTypes.OAK,
                        w -> new Shutter(Utils.copyPropertySafe(w.planks))
                )
                .createPaletteFromPlanks(this::shutterPalette)
                .addTexture(modRes("block/oak_shutter"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("shutters"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(shutter);

        louveredShutter = SimpleEntrySet.builder(WoodType.class, "louvered_shutter",
                        BlockInit.OAK_LOUVERED_SHUTTER, () -> VanillaWoodTypes.OAK,
                        w -> new Shutter(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/oak_louvered_shutter"))
                .createPaletteFromPlanks(this::shutterPalette)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("shutters"), Registries.f_256747_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(louveredShutter);
    }

    private void shutterPalette(Palette p) {
        int leftover = p.size() - 3;
        if (leftover > 6) {
            p.remove(p.getLightest());
            p.remove(p.getDarkest());
            p.remove(p.getDarkest());
        }
    }
}
