package net.mehvahdjukaar.every_compat.modules.hearth_and_home;

import com.starfish_studios.hearth_and_home.HearthAndHome;
import com.starfish_studios.hearth_and_home.block.LatticeBlock;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;

// SUPPORT v2.0.1
public class HearthAndHomeModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> sanded_wood;
    public final SimpleEntrySet<WoodType, Block> parquet;
    public final SimpleEntrySet<WoodType, Block> trim;
    public final SimpleEntrySet<WoodType, Block> vertical_trim;
    public final SimpleEntrySet<WoodType, Block> lattice;

    public HearthAndHomeModule(String modId) {
        super(modId, "hnhome");
        var tab = (PlatHelper.getPlatform().isForge()) ? modRes(HearthAndHome.MOD_ID) : modRes("tab");

        sanded_wood = SimpleEntrySet.builder(WoodType.class, "sanded_wood",
                        getModBlock("oak_sanded_wood"), () -> VanillaWoodTypes.OAK,
                        w -> new Block(Utils.copyPropertySafe(w.planks)))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("sanded_wood"), Registries.f_256747_, Registries.f_256913_)
                .addTexture(modRes("block/sanded_wood/oak"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(sanded_wood);

        parquet = SimpleEntrySet.builder(WoodType.class, "parquet",
                        getModBlock("oak_parquet"), () -> VanillaWoodTypes.OAK,
                        w -> new Block(Utils.copyPropertySafe(w.planks)))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("parquet"), Registries.f_256747_,  Registries.f_256913_)
                .addTexture(modRes("block/parquet/oak"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(parquet);

        trim = SimpleEntrySet.builder(WoodType.class, "trim",
                        getModBlock("oak_trim"), () -> VanillaWoodTypes.OAK,
                        w -> new Block(Utils.copyPropertySafe(w.planks)))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("trims"), Registries.f_256747_, Registries.f_256913_)
                .addTexture(modRes("block/trim/oak"))
                .defaultRecipe()
                .addRecipe(modRes("oak_trim_from_oak_vertical_trim"))
                .setTabKey(tab)
                .build();
        this.addEntry(trim);

        vertical_trim = SimpleEntrySet.builder(WoodType.class, "vertical_trim",
                        getModBlock("oak_vertical_trim"), () -> VanillaWoodTypes.OAK,
                        w -> new Block(Utils.copyPropertySafe(w.planks)))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("trims"), Registries.f_256747_, Registries.f_256913_)
                .addTexture(modRes("block/trim/oak"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(vertical_trim);

        lattice = SimpleEntrySet.builder(WoodType.class, "lattice",
                        getModBlock("oak_lattice"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeBlock(Utils.copyPropertySafe(w.planks).m_60955_()))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("lattices"), Registries.f_256747_, Registries.f_256913_)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .addTexture(modRes("block/lattice/oak"))
                .addTexture(modRes("block/lattice/oak_bar"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(lattice);
    }
}
