package net.mehvahdjukaar.every_compat.modules.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3f;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ModDrawersGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData(StorageDrawersModule module, ResourceManager manager) {
        if (geometryDataLoaded)
            return;

        geometryDataLoaded = true;

        populateGeometryData(modLoc("models/block/geometry/full_drawers_icon_area_1.json"),
                modLoc("models/block/geometry/full_drawers_count_area_1.json"),
                modLoc("models/block/geometry/full_drawers_ind_area_1.json"),
                modLoc("models/block/geometry/full_drawers_indbase_area_1.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/full_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/full_drawers_count_area_2.json"),
                modLoc("models/block/geometry/full_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/full_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/full_drawers_icon_area_4.json"),
                modLoc("models/block/geometry/full_drawers_count_area_4.json"),
                modLoc("models/block/geometry/full_drawers_ind_area_4.json"),
                modLoc("models/block/geometry/full_drawers_indbase_area_4.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_drawers_icon_area_1.json"),
                modLoc("models/block/geometry/half_drawers_count_area_1.json"),
                modLoc("models/block/geometry/half_drawers_ind_area_1.json"),
                modLoc("models/block/geometry/half_drawers_indbase_area_1.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/half_drawers_count_area_2.json"),
                modLoc("models/block/geometry/half_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/half_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_drawers_icon_area_4.json"),
                modLoc("models/block/geometry/half_drawers_count_area_4.json"),
                modLoc("models/block/geometry/half_drawers_ind_area_4.json"),
                modLoc("models/block/geometry/half_drawers_indbase_area_4.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new)
        );

        populateGeometryData(modLoc("models/block/geometry/full_comp_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/full_comp_drawers_count_area_2.json"),
                modLoc("models/block/geometry/full_comp_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/full_comp_drawers_icon_area_3.json"),
                modLoc("models/block/geometry/full_comp_drawers_count_area_3.json"),
                modLoc("models/block/geometry/full_comp_drawers_ind_area_3.json"),
                modLoc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_comp_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/half_comp_drawers_count_area_2.json"),
                modLoc("models/block/geometry/half_comp_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_comp_drawers_icon_area_3.json"),
                modLoc("models/block/geometry/half_comp_drawers_count_area_3.json"),
                modLoc("models/block/geometry/half_comp_drawers_ind_area_3.json"),
                modLoc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new)
        );
    }

    //FORGE use StorageDrawers.rl() and FABRIC use ModConstants.loc()
    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("storagedrawers", path);
    }

    private static void populateGeometryData(ResourceLocation locationIcon,
                                             ResourceLocation locationCount,
                                             ResourceLocation locationInd,
                                             ResourceLocation locationIndBase, ResourceManager manager,
                                             BlockDrawers... blocks) {
        BlockModel slotInfo = getBlockModel(locationIcon, manager);
        BlockModel countInfo = getBlockModel(locationCount, manager);
        BlockModel indInfo = getBlockModel(locationInd, manager);
        BlockModel indBaseInfo = getBlockModel(locationIndBase, manager);
        for (BlockDrawers block : blocks) {
            if (block == null)
                continue;

            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = slotInfo.m_111436_().get(i).f_111308_;
                Vector3f to = slotInfo.m_111436_().get(i).f_111309_;
                block.labelGeometry[i] = new AABB(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = countInfo.m_111436_().get(i).f_111308_;
                Vector3f to = countInfo.m_111436_().get(i).f_111309_;
                block.countGeometry[i] = new AABB(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = indInfo.m_111436_().get(i).f_111308_;
                Vector3f to = indInfo.m_111436_().get(i).f_111309_;
                block.indGeometry[i] = new AABB(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = indBaseInfo.m_111436_().get(i).f_111308_;
                Vector3f to = indBaseInfo.m_111436_().get(i).f_111309_;
                block.indBaseGeometry[i] = new AABB(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
        }
    }

    private static BlockModel getBlockModel(ResourceLocation location, ResourceManager manager) {
        Resource iresource;
        Reader reader = null;
        try {
//            iresource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(location);
//            reader = new InputStreamReader(iresource.open(), StandardCharsets.UTF_8);
            iresource =  manager.m_215593_(location);
            reader = new InputStreamReader(iresource.m_215507_(), StandardCharsets.UTF_8);
            return BlockModel.m_111461_(reader);
        } catch (IOException e) {
            return null;
        } finally {
            IOUtils.closeQuietly(reader);
        }
    }

}