package net.mehvahdjukaar.every_compat.common_classes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

@Environment(EnvType.CLIENT)
public class CompatChestBlockRenderer extends ChestRenderer<CompatChestBlockEntity> {
    public static final ResourceLocation CHEST_SHEET = new ResourceLocation("textures/atlas/chest.png");
    private final Map<WoodType, Material> single = new HashMap<>();
    private final Map<WoodType, Material> left = new HashMap<>();
    private final Map<WoodType, Material> right = new HashMap<>();
    private final Map<WoodType, Material> trapped = new HashMap<>();
    private final Map<WoodType, Material> trapped_left = new HashMap<>();
    private final Map<WoodType, Material> trapped_right = new HashMap<>();

    //assumes standard naming here. Generalize if needed
    public CompatChestBlockRenderer(BlockEntityRendererProvider.Context context, String shortenedId) {
        super(context);
        for (WoodType w : WoodTypeRegistry.getTypes()) {
            if (HardcodedBlockType.isKnownVanillaWood(w)) continue; // minecraft:pale_oak is from Perfect Parity: The Garden Awakens Edition
            String path = "entity/chest/" + shortenedId + "/" + w.getAppendableId() + "_chest";
            String trapped_path = "entity/chest/" + shortenedId + "/" + w.getAppendableId() + "_trapped_chest";
            if (!w.isVanilla()) {
                single.put(w, new Material(CHEST_SHEET, EveryCompat.res(path)));
                left.put(w, new Material(CHEST_SHEET, EveryCompat.res(path + "_left")));
                right.put(w, new Material(CHEST_SHEET, EveryCompat.res(path + "_right")));
                trapped.put(w, new Material(CHEST_SHEET, EveryCompat.res(trapped_path)));
                trapped_left.put(w, new Material(CHEST_SHEET, EveryCompat.res(trapped_path + "_left")));
                trapped_right.put(w, new Material(CHEST_SHEET, EveryCompat.res(trapped_path + "_right")));
            }
        }
    }

    protected @NotNull Material getMaterial(CompatChestBlockEntity blockEntity, ChestType chestType) {
        WoodType w = blockEntity.getWoodType();
        if (blockEntity.isTrapped()) {
            return switch (chestType) {
                case LEFT -> trapped_left.get(w);
                case RIGHT -> trapped_right.get(w);
                default -> trapped.get(w);
            };
        } else {
            return switch (chestType) {
                case LEFT -> left.get(w);
                case RIGHT -> right.get(w);
                default -> single.get(w);
            };
        }
    }


    //copy pasted from ChestRenderer

    @Override
    public void render(CompatChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : Blocks.f_50087_.m_49966_().m_61124_(ChestBlock.f_51478_, Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_(ChestBlock.f_51479_) ? blockstate.m_61143_(ChestBlock.f_51479_) : ChestType.SINGLE;
        Block flag1 = blockstate.m_60734_();
        if (flag1 instanceof AbstractChestBlock<?> abstractchestblock) {
            boolean flag1x = chesttype != ChestType.SINGLE;
            poseStack.m_85836_();
            float f = (blockstate.m_61143_(ChestBlock.f_51478_)).m_122435_();
            poseStack.m_252880_(0.5F, 0.5F, 0.5F);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            poseStack.m_252880_(-0.5F, -0.5F, -0.5F);
            DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> neighborcombineresult;
            if (flag) {
                neighborcombineresult = abstractchestblock.m_5641_(blockstate, level, blockEntity.m_58899_(), true);
            } else {
                neighborcombineresult = DoubleBlockCombiner.Combiner::m_6502_;
            }

            float f1 = neighborcombineresult.m_5649_(ChestBlock.m_51517_(blockEntity)).get(partialTick);
            f1 = 1.0F - f1;
            f1 = 1.0F - f1 * f1 * f1;
            int i = neighborcombineresult.<Int2IntFunction>m_5649_(new BrightnessCombiner<>()).applyAsInt(packedLight);
            Material material = this.getMaterial(blockEntity, chesttype);
            VertexConsumer vertexconsumer = material.m_119194_(buffer, RenderType::m_110452_);
            if (flag1x) {
                if (chesttype == ChestType.LEFT) {
                    this.m_112369_(poseStack, vertexconsumer, this.f_112353_, this.f_112355_, this.f_112354_, f1, i, packedOverlay);
                } else {
                    this.m_112369_(poseStack, vertexconsumer, this.f_112356_, this.f_112358_, this.f_112357_, f1, i, packedOverlay);
                }
            } else {
                this.m_112369_(poseStack, vertexconsumer, this.f_112350_, this.f_112352_, this.f_112351_, f1, i, packedOverlay);
            }

            poseStack.m_85849_();
        }
    }
    private void m_112369_(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lidPart.f_104203_ = -(lidAngle * 1.5707964F);
        lockPart.f_104203_ = lidPart.f_104203_;
        lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    public static void register(ClientHelper.BlockEntityRendererEvent event, BlockEntityType<CompatChestBlockEntity> tile, String s) {
        event.register(tile, c -> new CompatChestBlockRenderer(c, s));
    }

}
