package net.mehvahdjukaar.every_compat.common_classes;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;

public class CompatTrappedChestBlock extends CompatChestBlock {

    public CompatTrappedChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> tile, Properties properties) {
        super(tile, properties);
    }

    @Override
    protected @NotNull Stat<ResourceLocation> m_7699_() {
        return Stats.f_12988_.m_12902_(Stats.f_12962_);
    }

    @Override
    public boolean m_7899_(@NotNull BlockState state) {
        return true;
    }

    @Override
    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return Mth.m_14045_(ChestBlockEntity.m_59086_(level, pos), 0, 15);
    }

    @Override
    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return direction == Direction.UP ? state.m_60746_(level, pos, direction) : 0;
    }
}
