package net.mehvahdjukaar.every_compat.modules.forge.beautify_decorate;

import com.github.Pandarix.beautify.common.block.OakBlinds;
import com.github.Pandarix.beautify.common.block.OakPictureFrame;
import com.github.Pandarix.beautify.common.block.OakTrellis;
import com.github.Pandarix.beautify.core.init.BlockInit;
import com.github.Pandarix.beautify.core.init.ItemGroupInit;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.SoundType;

//SUPPORT: v2.0.2+
public class BeautifyDecorateModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, OakTrellis> tellis;
    public final SimpleEntrySet<WoodType, OakBlinds> blinds;
    public final SimpleEntrySet<WoodType, OakPictureFrame> picture_frames;

    public BeautifyDecorateModule(String modId) {
        super(modId, "bd");
        var tab = ItemGroupInit.BEAUTIFY_TAB.getId();

        tellis = SimpleEntrySet.builder(WoodType.class, "trellis",
                        BlockInit.OAK_TRELLIS, () -> VanillaWoodTypes.OAK,
                        w -> new OakTrellis(Utils.copyPropertySafe(w.planks)
                                .m_60913_(0.3F, 0.3F)
                                .m_60918_(SoundType.f_56754_).m_60955_()
                        )
                )
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13082_, Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(tellis);

        blinds = SimpleEntrySet.builder(WoodType.class, "blinds",
                        BlockInit.OAK_BLINDS, () -> VanillaWoodTypes.OAK,
                        w -> new OakBlinds(Utils.copyPropertySafe(w.planks)
                                .m_60955_().m_60913_(0.4F, 0.4F)
                                .m_60918_(SoundType.f_56736_)
                        )
                )
                .requiresChildren("slab") // Recipes
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(blinds);

        picture_frames = SimpleEntrySet.builder(WoodType.class, "picture_frame",
                        BlockInit.OAK_PICTURE_FRAME, () -> VanillaWoodTypes.OAK,
                        w -> new OakPictureFrame(Utils.copyPropertySafe(w.planks)
                                .m_60955_().m_60913_(0.1F, 0.1F)
                                .m_60918_(SoundType.f_56736_).m_60955_()
                        )
                )
                .requiresChildren("slab") // Recipes
                .addTexture(modRes("block/oak_frame_texture"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(picture_frames);


    }
}