package net.mehvahdjukaar.every_compat.modules.forge.graveyard;

import com.finallion.graveyard.blockentities.SarcophagusBlockEntity;
import com.finallion.graveyard.blockentities.enums.SarcophagusPart;
import com.finallion.graveyard.blockentities.render.SarcophagusBlockEntityRenderer;
import com.finallion.graveyard.blocks.SarcophagusBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(Dist.CLIENT)
public class CompatCoffinRenderer extends SarcophagusBlockEntityRenderer<GraveyardModule.CompatCoffinBlockTile> {
    public CompatCoffinRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(SarcophagusBlockEntity entity, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState blockState = entity.m_58900_();
        DoubleBlockCombiner.NeighborCombineResult<? extends SarcophagusBlockEntity> propertySource = DoubleBlockCombiner.m_52822_(
                (BlockEntityType) GraveyardModule.COFFIN_TILE,
                SarcophagusBlock::getBlockType,
                SarcophagusBlock::getConnectedDirection,
                ChestBlock.f_51478_,
                blockState,
                entity.m_58904_(),
                entity.m_58899_(),
                (worldx, pos) -> false
        );
        float g = propertySource.m_5649_(SarcophagusBlock.opennessCombiner(entity)).get(tickDelta);
        g = 1.0F - g;
        g = 1.0F - g * g * g;
        String base = ((SarcophagusBlock) blockState.m_60734_()).getBase();
        String lid = ((SarcophagusBlock) blockState.m_60734_()).getLid();
        BakedModel baseModel = getCustomModel(base);
        BakedModel lidModel = getCustomModel(lid);
        if (entity.m_58904_() != null && entity.m_58900_().m_61143_(SarcophagusBlock.PART) == SarcophagusPart.HEAD) {
            this.render(entity, matrixStack, vertexConsumers, light, overlay, g, lidModel, true);
            this.render(entity, matrixStack, vertexConsumers, light, overlay, g, baseModel, false);
        }

    }

    //TODO: this uses custom item models. adding is not trivial.
    private BakedModel getCustomModel(String base) {
        return null;
    }


    private void render(
            SarcophagusBlockEntity entity,
            PoseStack matrixStack,
            MultiBufferSource vertexConsumer,
            int light,
            int overlay,
            float g,
            BakedModel model,
            boolean isLid
    ) {
        matrixStack.m_85836_();
        Direction direction = (entity.m_58900_().m_61143_(SarcophagusBlock.FACING)).m_122424_();
        float f = direction.m_122435_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        switch (direction) {
            case EAST -> matrixStack.m_85837_(-1.0, 0.0, 1.0);
            case SOUTH -> matrixStack.m_85837_(0.0, 0.0, 1.0);
            case NORTH -> matrixStack.m_85837_(-1.0, 0.0, 0.0);
        }

        if (isLid) {
            matrixStack.m_85837_((double) g * 0.3, (double) g * 0.3, 0.0);
            matrixStack.m_252781_(Axis.f_252393_.m_252977_(g * 45.0F));
        }

        Minecraft.m_91087_()
                .m_91289_()
                .m_110937_()
                .m_111067_(
                        matrixStack.m_85850_(),
                        vertexConsumer.m_6299_(ItemBlockRenderTypes.m_109284_(entity.m_58900_(), true)),
                        entity.m_58900_(),
                        model,
                        1.0F,
                        1.0F,
                        1.0F,
                        light,
                        overlay
                );
        matrixStack.m_85849_();
    }


}