package net.mehvahdjukaar.every_compat.modules.forge.oreberries_replanted;

import com.mrbysco.oreberriesreplanted.block.OreBerryBushBlock;
import com.mrbysco.oreberriesreplanted.block.VatBlock;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

//SUPPORT: v0.5.2+
public class OreberriesReplantedModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> vats;

    public OreberriesReplantedModule(String modId) {
        super(modId, "or");
        ResourceLocation tab = modRes("tab");

        vats = SimpleEntrySet.builder(WoodType.class, "vat",
                        OreBerryRegistry.OAK_VAT, () -> VanillaWoodTypes.OAK,
                        w -> new VatBlock(BlockBehaviour.Properties.m_284310_()
                                .m_284180_(w.planks.m_284356_())
                                .m_60918_(SoundType.f_56757_)
                                .m_60955_()
                                .m_60960_(OreBerryBushBlock::isntSolid)
                                .m_60971_(OreBerryBushBlock::isntSolid))
                )
                .addTile(OreBerryRegistry.VAT_BLOCK_ENTITY)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(vats);


    }
}