package net.mehvahdjukaar.every_compat.modules.forge.variants;

import kittehmod.vct.blocks.VCTCraftingTableBlock;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;

import java.util.List;


public class VariantCraftingTablesModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> craftingTable;

    public VariantCraftingTablesModule(String modId) {
        super(modId, "vct");
        ResourceKey<CreativeModeTab> tab = CreativeModeTabs.f_256791_;

        craftingTable = SimpleEntrySet.builder(WoodType.class, "crafting_table",
                        getModBlock("spruce_crafting_table"),
                        () -> VanillaWoodTypes.SPRUCE,
                        w -> new VCTCraftingTableBlock(Utils.copyPropertySafe(w.planks).m_60978_(2.5F).m_60918_(SoundType.f_56736_)))
                //TEXTURE: texture is oak_craftng_table's texture
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_front"),
                        EveryCompat.res("block/vct/spruce_crafting_table_front_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_side"),
                        EveryCompat.res("block/vct/spruce_crafting_table_side_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_top"),
                        EveryCompat.res("block/vct/spruce_crafting_table_top_m"))
                .addTag(new ResourceLocation("forge:workbenches"), Registries.f_256747_)
                .addTag(new ResourceLocation("forge:workbench"), Registries.f_256747_)
                .addTag(new ResourceLocation("forge:workbenches"), Registries.f_256913_)
                .addTag(new ResourceLocation("forge:workbench"), Registries.f_256913_)
                .addTag(new ResourceLocation("charm:crafting_table"), Registries.f_256913_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();

        this.addEntry(craftingTable);
    }

    @Override
    public List<String> getAlreadySupportedMods() {
        return List.of(
                "abundant_atmosphere", "ad_astra", "aether", "architects_palette", "ars_nouveau",
                "atmospheric", "autumnity", "biomemakeover", "biomesoplenty", "caupona",
                "caverns_and_chasms", "ceilands", "cobblemon", "colorfulazaleas", "darkerdepths",
                "deeperdarker", "ecologics", "endergetic", "endlessbiomes", "enhanced_mushrooms",
                "enlightened_end", "environmental", "extendedmushrooms", "forbidden_arcanus", "fruittrees",
                "gardens_of_the_dead", "goodending", "habitat", "hexcasting", "hexerei",
                "integrateddynamics", "malum", "morecraft", "nethers_exoticism", "newworld",
                "outer_end", "phantasm", "prehistoricfauna", "quark", "regions_unexplored",
                "silentgear", "snowyspirit", "tconstruct", "twigs", "twilightforest",
                "undergarden", "upgrade_aquatic", "windswept"
        );
    }
}
