package net.mehvahdjukaar.every_compat.modules.furnish;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.*;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

// SUPPORT: v24+
public class FurnishModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> bedsideTable;
    public final SimpleEntrySet<WoodType, Block> bench;
    public final SimpleEntrySet<WoodType, Block> cabinet;
    public final SimpleEntrySet<WoodType, Block> chair;
    public final SimpleEntrySet<WoodType, Block> coffin;
    public final SimpleEntrySet<WoodType, Block> crate;
    public final SimpleEntrySet<WoodType, Block> kitchenCabinet;
    public final SimpleEntrySet<WoodType, Block> ladder;
    public final SimpleEntrySet<WoodType, Block> logBenches;
    public final SimpleEntrySet<WoodType, Block> pedestalTable;
    public final SimpleEntrySet<WoodType, Block> shelf;
    public final SimpleEntrySet<WoodType, Block> shutter;
    public final SimpleEntrySet<WoodType, Block> squareTable;
    public final SimpleEntrySet<WoodType, Block> stool;
    public final SimpleEntrySet<WoodType, Block> table;
    public final SimpleEntrySet<WoodType, Block> wardrobe;
    public final SimpleEntrySet<WoodType, Block> bookshelfChest;

    public FurnishModule(String modId) {
        super(modId, "fur");
        ResourceLocation tab = modRes(Furnish.MODID);

        TemplateRecipeManager.registerTemplate(modRes("furniture_making"), FurnishRecipeTemplate::new);

        table = SimpleEntrySet.builder(WoodType.class, "table",
                        getModBlock("oak_table"), () -> VanillaWoodTypes.OAK,
                        w -> new Table(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(table);

        squareTable = SimpleEntrySet.builder(WoodType.class, "square_table",
                        getModBlock("oak_square_table"), () -> VanillaWoodTypes.OAK,
                        w -> new SimpleFurniture(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_square_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(squareTable);

        pedestalTable = SimpleEntrySet.builder(WoodType.class, "pedestal_table",
                        getModBlock("oak_pedestal_table"), () -> VanillaWoodTypes.OAK,
                        w -> new SimpleFurniture(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_pedestal_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(pedestalTable);

        bedsideTable = SimpleEntrySet.builder(WoodType.class, "bedside_table",
                        getModBlock("oak_bedside_table"), () -> VanillaWoodTypes.OAK,
                        w -> new InventoryFurniture(Utils.copyPropertySafe(w.log), FurnishRegistries.Drawers_Open_Sound, FurnishRegistries.Drawers_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTile(FurnishRegistries.Furniture_BlockEntity)
                .addRecipe(modRes("furniture_making/oak_bedside_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(bedsideTable);

        kitchenCabinet = SimpleEntrySet.builder(WoodType.class, "kitchen_cabinet",
                        FurnishBlocks.Oak_Kitchen_Cabinet, () -> VanillaWoodTypes.OAK,
                        w -> new InventoryFurniture(Utils.copyPropertySafe(w.planks), FurnishRegistries.Drawers_Open_Sound, FurnishRegistries.Drawers_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTile(FurnishRegistries.Furniture_BlockEntity)
                .addRecipe(modRes("furniture_making/oak_kitchen_cabinet"))
                .setTabKey(tab)
                .build();
        this.addEntry(kitchenCabinet);

        cabinet = SimpleEntrySet.builder(WoodType.class, "cabinet",
                        FurnishBlocks.Birch_Cabinet, () -> VanillaWoodTypes.BIRCH,
                        w -> new Cabinet(Utils.copyPropertySafe(w.log), FurnishRegistries.Cabinet_Open_Sound, FurnishRegistries.Cabinet_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTile(FurnishRegistries.Furniture_BlockEntity)
                .addTexture(modRes("block/birch_cabinet_door_right"))
                .addTexture(modRes("block/birch_cabinet_door_left"))
                .addRecipe(modRes("furniture_making/birch_cabinet"))
                .setTabKey(tab)
                .build();
        this.addEntry(cabinet);

        wardrobe = SimpleEntrySet.builder(WoodType.class, "wardrobe",
                        FurnishBlocks.Birch_Wardrobe, () -> VanillaWoodTypes.BIRCH,
                        w -> new Wardrobe(Utils.copyPropertySafe(w.log), FurnishRegistries.Cabinet_Open_Sound, FurnishRegistries.Cabinet_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTile(FurnishRegistries.Large_Furniture_BlockEntity)
                .addTexture(modRes("block/birch_wardrobe_door_bottom_right"))
                .addTexture(modRes("block/birch_wardrobe_door_bottom_left"))
                .addTexture(modRes("block/birch_wardrobe_door_top_right"))
                .addTexture(modRes("block/birch_wardrobe_door_top_left"))
                .addRecipe(modRes("furniture_making/birch_wardrobe"))
                .setTabKey(tab)
                .build();
        this.addEntry(wardrobe);

        stool = SimpleEntrySet.builder(WoodType.class, "stool",
                        FurnishBlocks.Oak_Stool, () -> VanillaWoodTypes.OAK,
                        w -> new Chair(Utils.copyPropertySafe(w.log), Chair.BASE_SHAPES)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_stool"))
                .setTabKey(tab)
                .build();
        this.addEntry(stool);

        chair = SimpleEntrySet.builder(WoodType.class, "chair",
                        FurnishBlocks.Oak_Chair, () -> VanillaWoodTypes.OAK,
                        w -> new Chair(Utils.copyPropertySafe(w.log),
                                VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_SEAT))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_chair"))
                .setTabKey(tab)
                .build();
        this.addEntry(chair);

        shutter = SimpleEntrySet.builder(WoodType.class, "shutter",
                        FurnishBlocks.Oak_Shutter, () -> VanillaWoodTypes.OAK,
                        w -> new Shutter(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("trapdoor") //REASON: recipes
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_shutter"))
                .addTexture(modRes("block/oak_shutter"))
                .setTabKey(tab)
                .build();
        this.addEntry(shutter);

        crate = SimpleEntrySet.builder(WoodType.class, "crate",
                        FurnishBlocks.Oak_Crate, () -> VanillaWoodTypes.OAK,
                        w -> new Crate(Utils.copyPropertySafe(w.planks))
                )
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(modRes("crates"), Registries.f_256747_)
                .addTag(modRes("wooden_furniture"), Registries.f_256913_)
                .addTag(modRes("mail"), Registries.f_256913_)
                .addTag(modRes("crates"), Registries.f_256913_)
                .addTag(modRes("crate_blacklist"), Registries.f_256913_)
                .addRecipe(modRes("furniture_making/oak_crate"))
                .addTexture(modRes("block/oak_crate_side"))
                .addTexture(modRes("block/oak_crate_top"))
                .setTabKey(tab)
                .addCustomItem((woodType, block, properties) -> new BlockItem(block, properties.stacksTo(1))
                )
                .copyParentDrop()
                .build();
        this.addEntry(crate);

        shelf = SimpleEntrySet.builder(WoodType.class, "shelf",
                        FurnishBlocks.Oak_Shelf, () -> VanillaWoodTypes.OAK,
                        w -> new Shelf(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTile(FurnishRegistries.Shelf_BlockEntity)
                .addRecipe(modRes("furniture_making/oak_shelf"))
                .setTabKey(tab)
                .build();
        this.addEntry(shelf);

        bench = SimpleEntrySet.builder(WoodType.class, "bench",
                        FurnishBlocks.Oak_Bench, () -> VanillaWoodTypes.OAK,
                        w -> new Bench(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_bench"))
                .setTabKey(tab)
                .build();
        this.addEntry(bench);

        logBenches = SimpleEntrySet.builder(WoodType.class, "log_bench",
                        FurnishBlocks.Oak_Log_Bench, () -> VanillaWoodTypes.OAK,
                        w -> new LogBench(Utils.copyPropertySafe(w.log))
                )
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_log_bench"))
                .addTexture(modRes("block/oak_log_bench_top"))
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .build();
        this.addEntry(logBenches);

        ladder = SimpleEntrySet.builder(WoodType.class, "ladder",
                        FurnishBlocks.Oak_Ladder, () -> VanillaWoodTypes.OAK,
                        w -> new Ladder(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13082_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/oak_ladder"))
                .setTabKey(tab)
                .build();
        this.addEntry(ladder);

        coffin = SimpleEntrySet.builder(WoodType.class, "coffin",
                        FurnishBlocks.Jungle_Coffin, () -> VanillaWoodTypes.JUNGLE,
                        w -> new Coffin(Utils.copyPropertySafe(w.planks))
                )
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addRecipe(modRes("furniture_making/jungle_coffin"))
                .addTexture(modRes("block/jungle_coffin_sides"))
                .setTabKey(tab)
                .build();
        this.addEntry(coffin);

        bookshelfChest = SimpleEntrySet.builder(WoodType.class, "bookshelf_chest",
                        FurnishBlocks.Dark_Oak_Bookshelf_Chest, () -> VanillaWoodTypes.DARK_OAK,
                        w -> new BookshelfChest(Utils.copyPropertySafe(w.planks).pushReaction(PushReaction.BLOCK))
                )
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("bookshelf_chest"), Registries.f_256747_)
                .addTag(modRes("wooden_furniture"), Registries.f_256747_)
                .addTag(modRes("wooden_furniture"), Registries.f_256913_)
                .addTag(modRes("bookshelf_chests"), Registries.f_256913_)
                .addRecipe(modRes("furniture_making/dark_oak_bookshelf_chest"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf_chest_empty"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf_chest_plenty"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf_chest_sparse"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTile(FurnishRegistries.BookshelfChest_BlockEntity)
                .setTabKey(tab)
                .build();
        this.addEntry(bookshelfChest);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, handler) -> {

            for (var w : WoodTypeRegistry.INSTANCE) {
                boolean hasSomething = false;
                SimpleTagBuilder itemTag = SimpleTagBuilder.of(modRes(w.getTypeName() + "_" + "furniture"));

                for (var entry : this.getEntries()) {
                    Item b = ((SimpleEntrySet<?, ?>) entry).items.get(w);
                    if (b != null) {
                        hasSomething = true;
                        itemTag.addEntry(b);
                    }
                }
                if (hasSomething) {
                    handler.addTag(itemTag, Registries.f_256913_);
                    handler.addTag(itemTag, Registries.f_256747_);
                }
            }
        });
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) -> {
            logBenches.blocks.forEach((w, block) -> {
                var id = Utils.getID(block);

                try (TextureImage topTexture = TextureImage.open(manager,
                        RPUtils.findFirstBlockTextureLocation(manager, w.log, CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));
                     TextureImage newTexture = topTexture.makeCopy()) {

                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace("block/oak_log_bench_top", w, id, "oak");

                    sink.addTextureIfNotPresent(manager, newId, () -> newTexture);

                    sink.addTextureIfNotPresent(manager, newId + "_top", () -> {
                        TextureImage newTop = topTexture.makeCopy();
                        CompatSpritesHelper.createSmallLogTopTexture(topTexture, newTop);
                        return newTop;
                    });

                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate Log Bench block texture for for {} : {}", block, e);

                }

            });
            coffin.blocks.forEach((w, block) -> {
                var id = Utils.getID(block);

                try (TextureImage topTexture = TextureImage.open(manager,
                        RPUtils.findFirstBlockTextureLocation(manager, w.log, CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE))) {

                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace("block/jungle_coffin_sides", w, id, "jungle");

                    sink.addTextureIfNotPresent(manager, newId + "_top", () -> {
                        TextureImage newTop = topTexture.makeCopy();
                        CompatSpritesHelper.createSmallLogTopTexture(topTexture, newTop);
                        return newTop;
                    });

                    //odd. reusing an existing texture
                    sink.addTextureIfNotPresent(manager, newId, () -> topTexture);

                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate coffin block texture for for {} : {}", block, e);

                }

            });
        });
    }

    //!! RECIPES
    public static class FurnishFinishedRecipe implements FinishedRecipe {
        protected final Ingredient ingredient;
        protected final ItemStack result;
        protected final ResourceLocation id;
        protected final String group;
        private final Advancement.Builder advancement;
        protected final ResourceLocation advancementId;


        public FurnishFinishedRecipe(
                ResourceLocation resourceLocation,
                String group,
                Ingredient ingredient,
                ItemStack result, Advancement.Builder advancement, ResourceLocation advancementId
        ) {
            this.id = resourceLocation;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }


        public void m_7917_(@NotNull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("id", this.id.toString());

            json.add("ingredient", ingredient.m_43942_());

            json.addProperty("result", Utils.getID(result.m_41720_()).toString());
            json.addProperty("count", result.m_41613_());
        }

        @Override
        public @NotNull ResourceLocation m_6445_() {
            return id;
        }

        @Override
        public @NotNull RecipeSerializer<?> m_6637_() {
            return FurnishRegistries.Furniture_Recipe_Serializer.get();
        }

        @Nullable
        @Override
        public JsonObject m_5860_() {
            return advancement.m_138400_();
        }

        @Nullable
        @Override
        public ResourceLocation m_6448_() {
            return advancementId;
        }
    }

    public class FurnishRecipeTemplate implements IRecipeTemplate<FurnishFinishedRecipe> {

        private final List<Object> conditions = new ArrayList<>();

        public final ItemStack result;
        public final String group;
        public final Ingredient ingredient;

        public FurnishRecipeTemplate(JsonObject json) {
            var g = json.get("group");
            this.group = g == null ? "" : g.getAsString();

            this.ingredient = Ingredient.m_43917_(json.get("ingredient"));
            String s1 = GsonHelper.m_13906_(json, "result");
            int i = GsonHelper.m_13927_(json, "count");
            this.result = new ItemStack(BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s1)), i);
        }

        @Override
        public <T extends BlockType> FurnishFinishedRecipe createSimilar(
                T originalMat, T destinationMat, Item unlockItem, String id) {
            ItemLike newRes = BlockType.changeItemType(this.result.m_41720_(), originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                        this.result, originalMat, destinationMat));
            }
            ItemStack newResult = new ItemStack(newRes);
            if (this.result.m_41782_()) newResult.m_41751_(this.result.m_41784_().m_6426_());
            if (id == null) id = BuiltInRegistries.f_257033_.m_7981_(newRes.m_5456_()).toString();

            Ingredient newIng = ResourcesUtils.convertIngredient(this.ingredient, originalMat, destinationMat);

            Advancement.Builder advancement = Advancement.Builder.m_138353_();

            advancement.m_138386_("has_planks", InventoryChangeTrigger.TriggerInstance.m_43199_(unlockItem));
            var res = new ResourceLocation(id);
            return new FurnishFinishedRecipe(res, group, newIng, newResult, advancement,
                    modRes("recipes/" + "furnish" + "/" + res.m_135815_()));
        }

        @Override
        public void addCondition(Object condition) {
            this.conditions.add(condition);
        }

        @Override
        public List<Object> getConditions() {
            return conditions;
        }
    }
}
