package net.mehvahdjukaar.every_compat.modules.mrcrayfish;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.block.*;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.CeilingFanBlockEntityRenderer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.item.MailboxItem;
import com.mrcrayfish.furniture.refurbished.item.PoweredItem;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.*;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

//SUPPORT: v1.0.12+
public class RefurbishedFurnitureModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> chairs;
    public final SimpleEntrySet<WoodType, Block> tables;
    public final SimpleEntrySet<WoodType, Block> darkFans;
    public final SimpleEntrySet<WoodType, Block> lightFans;
    public final SimpleEntrySet<WoodType, Block> toilets;
    public final SimpleEntrySet<WoodType, Block> crates;
    public final SimpleEntrySet<WoodType, Block> mailboxes;
    public final SimpleEntrySet<WoodType, Block> jars;
    public final SimpleEntrySet<WoodType, Block> kitchen_cabinetry;
    public final SimpleEntrySet<WoodType, Block> kitchen_drawer;
    public final SimpleEntrySet<WoodType, Block> kitchen_sink;
    public final SimpleEntrySet<WoodType, Block> kitchen_storage_cabinet;
    public final SimpleEntrySet<WoodType, Block> storage_cabinet;
    public final SimpleEntrySet<WoodType, Block> basin;
    public final SimpleEntrySet<WoodType, Block> bath;
    public final SimpleEntrySet<WoodType, Block> lattice_fence;
    public final SimpleEntrySet<WoodType, Block> lattice_fence_gate;
    public final SimpleEntrySet<WoodType, Block> desk;
    public final SimpleEntrySet<WoodType, Block> cutting_board;
    public final SimpleEntrySet<WoodType, Block> drawer;
    public final SimpleEntrySet<LeavesType, Block> hedges;


    public RefurbishedFurnitureModule(String modId) {
        super(modId, "rfm");
        ResourceLocation tab = modRes("creative_tab");

        TemplateRecipeManager.registerTemplate(modRes("workbench_constructing"), ConstructingTemplate::new);

        chairs = SimpleEntrySet.builder(WoodType.class, "chair",
                        getModBlock("oak_chair"), () -> VanillaWoodTypes.OAK,
                        w -> new ChairBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_().m_60978_(2.0F))))
                .addRecipe(modRes("constructing/oak_chair"))
                .setTabKey(tab)
                .addTexture(modRes("block/oak_chair"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("general"), Registries.f_256913_)
                .build();
        this.addEntry(chairs);

        tables = SimpleEntrySet.builder(WoodType.class, "table",
                        getModBlock("oak_table"), () -> VanillaWoodTypes.OAK,
                        w -> new TableBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_()
                                .m_60978_(2.0F))))
                .addRecipe(modRes("constructing/oak_table"))
                .setTabKey(tab)
                .addTexture(modRes("block/oak_table"))
                .addTexture(modRes("block/oak_particle"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("tuckable"), Registries.f_256747_)
                .addTag(modRes("general"), Registries.f_256913_)
                .build();
        this.addEntry(tables);

        darkFans = SimpleEntrySet.builder(WoodType.class, "dark_ceiling_fan",
                        getModBlock("oak_dark_ceiling_fan"), () -> VanillaWoodTypes.OAK,
                        w -> new CeilingFanBlock(w.toVanillaOrOak(),
                                MetalType.DARK,
                                BlockBehaviour.Properties.m_284310_().m_284180_(w.planks.m_284356_())
                                        .m_60978_(0.8F).m_60918_(w.getSound()).m_60953_(CeilingFanBlock::light))
                )
                .addTextureM(modRes("block/oak_dark_ceiling_fan"),
                        EveryCompat.res("block/rfm/oak_ceiling_fan_m"))
                .addTile(ModBlockEntities.CEILING_FAN::get)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("electronics"), Registries.f_256913_)
                .addTag(modRes("bedroom"), Registries.f_256913_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.TRANSLUCENT)
                .addRecipe(modRes("constructing/oak_dark_ceiling_fan"))
                .defaultRecipe()
                .addCustomItem((w, block, properties) -> new PoweredItem(block, properties))
                .build();
        this.addEntry(darkFans);

        lightFans = SimpleEntrySet.builder(WoodType.class, "light_ceiling_fan",
                        getModBlock("oak_light_ceiling_fan"), () -> VanillaWoodTypes.OAK,
                        w -> new CeilingFanBlock(w.toVanillaOrOak(),
                                MetalType.DARK,
                                BlockBehaviour.Properties.m_284310_().m_284180_(w.planks.m_284356_())
                                        .m_60978_(0.8F).m_60918_(w.getSound()).m_60953_(CeilingFanBlock::light))
                )
                .addTile(ModBlockEntities.CEILING_FAN::get)
                .addTextureM(modRes("block/oak_light_ceiling_fan"),
                        EveryCompat.res("block/rfm/oak_ceiling_fan_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("electronics"), Registries.f_256913_)
                .addTag(modRes("bedroom"), Registries.f_256913_)
                .setTabKey(tab)
                .setRenderType(RenderLayer.TRANSLUCENT)
                .addRecipe(modRes("constructing/oak_light_ceiling_fan"))
                .addCustomItem((w, block, properties) -> new PoweredItem(block, properties))
                .build();
        this.addEntry(lightFans);


        crates = SimpleEntrySet.builder(WoodType.class, "crate",
                        getModBlock("oak_crate"), () -> VanillaWoodTypes.OAK,
                        w -> new CrateBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_()
                                .m_280606_().m_60978_(2.5F))))
                .addRecipe(modRes("constructing/oak_crate"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.CRATE::get)
                .addTexture(modRes("block/oak_crate"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .addTag(modRes("outdoors"), Registries.f_256913_)
                .build();
        this.addEntry(crates);

        mailboxes = SimpleEntrySet.builder(WoodType.class, "mail_box",
                        getModBlock("oak_mail_box"), () -> VanillaWoodTypes.OAK,
                        w -> new MailboxBlock(w.toVanillaOrOak(), addWoodPropNoFire(w, BlockBehaviour.Properties.m_284310_()
                                .m_60978_(2.5F))))
                .addRecipe(modRes("constructing/oak_mail_box"))
                .addCustomItem((woodType, block, properties) -> new MailboxItem(block, properties))
                .setTabKey(tab)
                .addTile(ModBlockEntities.MAIL_BOX::get)
                .addTextureM(modRes("block/oak_mail_box"),
                        EveryCompat.res("block/rfm/oak_mail_box_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("outdoors"), Registries.f_256913_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(mailboxes);

        toilets = SimpleEntrySet.builder(WoodType.class, "toilet",
                        getModBlock("oak_toilet"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenToiletBlock(w.toVanillaOrOak(), BlockBehaviour.Properties.m_284310_().m_284180_(w.planks.m_284356_())
                                .m_60978_(3.5f).m_60918_(SoundType.f_56742_)))
                .addRecipe(modRes("constructing/oak_toilet"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.TOILET::get)
                .addTextureM(modRes("block/oak_toilet"),
                        EveryCompat.res("block/rfm/oak_toilet_m"))
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(modRes("wooden_toilets"), Registries.f_256913_)
                .addTag(modRes("bathroom"), Registries.f_256913_)
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(toilets);

        jars = SimpleEntrySet.builder(WoodType.class, "storage_jar",
                        getModBlock("oak_storage_jar"), () -> VanillaWoodTypes.OAK,
                        w -> new StorageJarBlock(w.toVanillaOrOak(), BlockBehaviour.Properties.m_284310_()
                                .m_284180_(w.planks.m_284356_())
                                .m_280658_(NoteBlockInstrument.HAT).m_60978_(1.0F).m_60918_(SoundType.f_56744_)))
                .addRecipe(modRes("constructing/oak_storage_jar"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_JAR::get)
                .addTextureM(modRes("block/oak_storage_jar"),
                        EveryCompat.res("block/rfm/oak_storage_jar_m"))
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(jars);

        kitchen_cabinetry = SimpleEntrySet.builder(WoodType.class, "kitchen_cabinetry",
                        getModBlock("oak_kitchen_cabinetry"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenCabinetryBlock(w.toVanillaOrOak(),
                                addWoodProp(w, BlockBehaviour.Properties.m_284310_()).m_280606_().m_60978_(2.0f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_cabinetry"))
                .setTabKey(tab)
//                .addTile(ModBlockEntities.STORAGE_CABINET::get)
                .addTextureM(modRes("block/oak_kitchen_cabinetry"),
                        EveryCompat.res("block/rfm/oak_kitchen_cabinetry_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_kitchen_cabinetry"), Registries.f_256913_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .build();
        this.addEntry(kitchen_cabinetry);

        kitchen_drawer = SimpleEntrySet.builder(WoodType.class, "kitchen_drawer",
                        getModBlock("oak_kitchen_drawer"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenDrawerBlock(w.toVanillaOrOak(),
                                addWoodProp(w, BlockBehaviour.Properties.m_284310_()).m_280606_().m_60978_(2.5f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_drawer"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.KITCHEN_DRAWER::get)
                .addTextureM(modRes("block/oak_kitchen_drawer"),
                        EveryCompat.res("block/rfm/oak_kitchen_drawer_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .addTag(modRes("wooden_kitchen_drawers"), Registries.f_256913_)
                .build();
        this.addEntry(kitchen_drawer);

        kitchen_sink = SimpleEntrySet.builder(WoodType.class, "kitchen_sink",
                        getModBlock("oak_kitchen_sink"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenSinkBlock(w.toVanillaOrOak(),
                                addWoodProp(w, BlockBehaviour.Properties.m_284310_()).m_280606_().m_60978_(2.5f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_sink"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.KITCHEN_SINK::get)
                .addTextureM(modRes("block/oak_kitchen_sink"),
                        EveryCompat.res("block/rfm/oak_kitchen_sink_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_kitchen_sinks"), Registries.f_256913_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .build();
        this.addEntry(kitchen_sink);

        kitchen_storage_cabinet = SimpleEntrySet.builder(WoodType.class, "kitchen_storage_cabinet",
                        getModBlock("oak_kitchen_storage_cabinet"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenStorageCabinetBlock(w.toVanillaOrOak(),
                                addWoodProp(w, BlockBehaviour.Properties.m_284310_()).m_280606_().m_60978_(2.5f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_storage_cabinet"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_CABINET::get)
                .addTextureM(modRes("block/oak_kitchen_storage_cabinet"),
                        EveryCompat.res("block/rfm/oak_kitchen_storage_cabinet_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_kitchen_storage_cabinets"), Registries.f_256913_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .build();
        this.addEntry(kitchen_storage_cabinet);

        storage_cabinet = SimpleEntrySet.builder(WoodType.class, "storage_cabinet",
                        getModBlock("oak_storage_cabinet"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenStorageCabinetBlock(w.toVanillaOrOak(),
                                addWoodProp(w, BlockBehaviour.Properties.m_284310_()).m_280606_().m_60978_(2.5f))
                )
                .addRecipe(modRes("constructing/oak_storage_cabinet"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_CABINET::get)
                .addTextureM(modRes("block/oak_storage_cabinet"),
                        EveryCompat.res("block/rfm/oak_storage_cabinet_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("general"), Registries.f_256913_)
                .addTag(modRes("bedroom"), Registries.f_256913_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .build();
        this.addEntry(storage_cabinet);

        basin = SimpleEntrySet.builder(WoodType.class, "basin",
                        getModBlock("oak_basin"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenBasinBlock(w.toVanillaOrOak(), BlockBehaviour.Properties.m_284310_()
                                .m_284180_(w.planks.m_284356_())
                                .m_60978_(3.5f).m_60918_(SoundType.f_56742_)
                        )
                )
                .addRecipe(modRes("constructing/oak_basin"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.BASIN::get)
                .addTextureM(modRes("block/oak_basin"),
                        EveryCompat.res("block/rfm/oak_basin_m"))
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(modRes("wooden_basins"), Registries.f_256913_)
                .addTag(modRes("bathroom"), Registries.f_256913_)
                .build();
        this.addEntry(basin);

        bath = SimpleEntrySet.builder(WoodType.class, "bath",
                        getModBlock("oak_bath"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenBathBlock(w.toVanillaOrOak(), BlockBehaviour.Properties.m_284310_()
                                .m_284180_(w.planks.m_284356_())
                                .m_60978_(3.5f).m_60918_(SoundType.f_56742_)
                        )
                )
                .addRecipe(modRes("constructing/oak_bath"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.BATH::get)
                .addTextureM(modRes("block/oak_bath"),
                        EveryCompat.res("block/rfm/oak_bath_m"))
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(modRes("bathroom"), Registries.f_256913_)
                .addTag(modRes("wooden_baths"), Registries.f_256913_)
                .build();
        this.addEntry(bath);

        lattice_fence = SimpleEntrySet.builder(WoodType.class, "lattice_fence",
                        getModBlock("oak_lattice_fence"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeFenceBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_()
                                .m_60978_(2.0f).m_280606_())
                        )
                )
                .addRecipe(modRes("constructing/oak_lattice_fence"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_JAR::get)
                .addTexture(modRes("block/oak_lattice_fence"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13039_, Registries.f_256747_)
                .addTag(BlockTags.f_13098_, Registries.f_256747_)
                .addTag(modRes("outdoors"), Registries.f_256913_)
                .addTag(BlockTags.f_13039_, Registries.f_256913_)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(lattice_fence);

        lattice_fence_gate = SimpleEntrySet.builder(WoodType.class, "lattice_fence_gate",
                        getModBlock("oak_lattice_fence_gate"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeFenceGateBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_())
                                .m_60978_(2.0f)
                        )
                )
                .addRecipe(modRes("constructing/oak_lattice_fence_gate"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_JAR::get)
                .addTextureM(modRes("block/oak_lattice_fence_gate"),
                        EveryCompat.res("block/rfm/oak_lattice_fence_gate_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13055_, Registries.f_256747_)
                .addTag(BlockTags.f_13056_, Registries.f_256747_)
                .addTag(modRes("outdoors"), Registries.f_256913_)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(lattice_fence_gate);

        desk = SimpleEntrySet.builder(WoodType.class, "desk",
                        getModBlock("oak_desk"), () -> VanillaWoodTypes.OAK,
                        w -> new DeskBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_())
                                .m_60978_(2.0f).m_280606_()
                        )
                )
                .addRecipe(modRes("constructing/oak_desk"))
                .setTabKey(tab)
                .addTexture(modRes("block/oak_desk"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("tuckable"), Registries.f_256747_)
                .addTag(modRes("general"), Registries.f_256913_)
                .addTag(modRes("bedroom"), Registries.f_256913_)
                .build();
        this.addEntry(desk);

        cutting_board = SimpleEntrySet.builder(WoodType.class, "cutting_board",
                        getModBlock("oak_cutting_board"), () -> VanillaWoodTypes.OAK,
                        w -> new CuttingBoardBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_())
                                .m_60978_(1.5f)
                        )
                )
                .addRecipe(modRes("constructing/oak_cutting_board"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.CUTTING_BOARD::get)
                .addTexture(modRes("block/oak_cutting_board"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("kitchen"), Registries.f_256913_)
                .build();
        this.addEntry(cutting_board);

        drawer = SimpleEntrySet.builder(WoodType.class, "drawer",
                        getModBlock("oak_drawer"), () -> VanillaWoodTypes.OAK,
                        w -> new DrawerBlock(w.toVanillaOrOak(), addWoodProp(w, BlockBehaviour.Properties.m_284310_())
                                .m_60978_(2.5f).m_280606_()
                        )
                )
                .addRecipe(modRes("constructing/oak_drawer"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.DRAWER::get)
                .addTexture(modRes("block/oak_drawer"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("storage"), Registries.f_256913_)
                .addTag(modRes("bedroom"), Registries.f_256913_)
                .addTag(modRes("general"), Registries.f_256913_)
                .build();
        this.addEntry(drawer);

        hedges = SimpleEntrySet.builder(LeavesType.class, "hedge",
                        getModBlock("oak_hedge"), () -> VanillaLeavesTypes.OAK,
                        l -> new HedgeBlock(LeafType.OAK, BlockBehaviour.Properties.m_284310_().m_60978_(0.5f)
                                .m_60918_(SoundType.f_154674_))
                )
                .requiresChildren("leaves") // Textures
                .addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves",
                        "leaves", CompatSpritesHelper.LOOKS_LIKE_LEAF_TEXTURE))
                .addRecipe(modRes("constructing/oak_hedge"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.DRAWER::get)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .copyParentTint()
                .build();
        this.addEntry(hedges);
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, handler) -> {

            // code copied from ResourceUtils.addStandardResources
            StaticResource darkBlade = StaticResource.getOrLog(manager, ResType.MODELS.getPath(
                    modRes("extra/oak_dark_ceiling_fan_blade")
            ));
            addFanModels(handler, manager, darkBlade, darkFans);
            StaticResource lightBlade = StaticResource.getOrLog(manager, ResType.MODELS.getPath(
                    modRes("extra/oak_light_ceiling_fan_blade")
            ));
            addFanModels(handler, manager, lightBlade, lightFans);
        });
    }

    private void addFanModels(ResourceSink handler, ResourceManager manager, StaticResource darkBlade, SimpleEntrySet<WoodType, Block> darkFans) {
        darkFans.blocks.forEach((w, b) -> {
            try {
                handler.addSimilarJsonResource(manager, darkBlade, s ->
                        s.replace("oak", w.getAppendableId())
                                .replace("texture\": \"refurbished_furniture:block", "texture\": \"everycomp:block/rfm"));

            } catch (Exception exception) {
                EveryCompat.LOGGER.error("Failed to add {} model json file:", b, exception);
            }
        });
    }

    @Override
    public void onClientSetup() {
        super.onClientSetup();
        darkFans.blocks.forEach((key, value) -> {
            ResourceLocation res = EveryCompat.res("extra/" + key.getAppendableId() + "_dark_ceiling_fan_blade");
            CeilingFanBlockEntityRenderer.registerFanBlade(value, () -> ClientHelper.getModel(Minecraft.getInstance().getModelManager(), res));
        });
        lightFans.blocks.forEach((key, value) -> {
            ResourceLocation res = EveryCompat.res("extra/" + key.getAppendableId() + "_light_ceiling_fan_blade");
            CeilingFanBlockEntityRenderer.registerFanBlade(value, () -> ClientHelper.getModel(Minecraft.getInstance().getModelManager(), res));
        });
    }

    @Override
    public void onClientInit() {
        super.onClientInit();
        ClientHelper.addSpecialModelRegistration(event -> darkFans.blocks.keySet().forEach(w -> {
            event.register(EveryCompat.res("extra/" + w.getAppendableId() + "_dark_ceiling_fan_blade"));
            event.register(EveryCompat.res("extra/" + w.getAppendableId() + "_light_ceiling_fan_blade"));
        }));
    }

    public static BlockBehaviour.Properties addWoodProp(WoodType w, BlockBehaviour.Properties p) {
        if (w.canBurn()) p.m_278183_();
        return addWoodPropNoFire(w, p);
    }

    public static BlockBehaviour.Properties addWoodPropNoFire(WoodType w, BlockBehaviour.Properties p) {
        p.m_284180_(w.planks.m_284356_()).m_60918_(w.getSound()).m_280658_(NoteBlockInstrument.BASS);
        return p;
    }


    public class ConstructingTemplate implements IRecipeTemplate<WorkbenchContructingRecipe.Result> {

        private final List<Object> conditions = new ArrayList<>();

        public final ItemStack result;
        public final NonNullList<StackedIngredient> materials;
        private final boolean notification;

        public ConstructingTemplate(JsonObject json) {

            JsonArray materialArray = GsonHelper.m_13933_(json, "materials");
            this.materials = NonNullList.m_122780_(materialArray.size(), StackedIngredient.EMPTY);
            IntStream.range(0, materialArray.size()).forEach((i) -> materials.set(i, StackedIngredient.fromJson(materialArray.get(i))));
            String s1;
            int count;
            if (json.get("result").isJsonObject()) {
                s1 = GsonHelper.m_13930_(json, "result").get("item").getAsString();
                count = GsonHelper.m_13930_(json, "result").get("count").getAsInt();
            } else {
                s1 = GsonHelper.m_13906_(json, "result");
                count = 1;
            }

            this.result = new ItemStack(BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s1)), count);
            this.notification = GsonHelper.m_13855_(json, "show_notification", true);
        }

        @Override
        public <T extends BlockType> WorkbenchContructingRecipe.Result createSimilar(
                T originalMat, T destinationMat, Item unlockItem, String id) {

            ItemLike newRes = BlockType.changeItemType(this.result.m_41720_(), originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                        this.result, originalMat, destinationMat));
            }
            ItemStack newResult = new ItemStack(newRes);
            if (this.result.m_41782_()) newResult.m_41751_(this.result.m_41784_().m_6426_());
            if (id == null) id = BuiltInRegistries.f_257033_.m_7981_(newRes.m_5456_()).toString();

            List<StackedIngredient> newMaterials = new ArrayList<>();
            for (StackedIngredient ing : this.materials) {
                Ingredient converted = ResourcesUtils.convertIngredient(ing.ingredient(), originalMat, destinationMat);
                newMaterials.add(new StackedIngredient(converted, ing.count()));
            }

            Advancement.Builder advancement = Advancement.Builder.m_138353_();

            List<String> requirements = new ArrayList<>();
            for (var m : newMaterials) {
                String name = "has_" + m.ingredient().getItems()[0].getItem();
                requirements.add(name);
                var items = Arrays.stream(m.ingredient().getItems()).map(ItemStack::m_41720_).collect(Collectors.toSet());
                advancement.m_138386_(name, new InventoryChangeTrigger.TriggerInstance(
                        ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_,
                        new ItemPredicate[]{new ItemPredicate(null, items,
                                MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_,
                                EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)}
                ));
            }

            requirements.add("has_the_recipe");

            var res = new ResourceLocation(id);

            advancement.m_143951_(new String[][]{requirements.toArray(new String[0])});
            advancement.m_138386_("has_the_recipe", RecipeUnlockedTrigger.m_63728_(res));

            advancement.m_138354_(AdvancementRewards.Builder.m_10009_(EveryCompat.res("recipes/" + res.m_135815_())));

            return new WorkbenchContructingRecipe.Result(res, newResult.m_41720_(), result.m_41613_(), newMaterials, advancement,
                    modRes("recipes/misc/constructing/" + res.m_135815_()), notification);
        }

        @Override
        public void addCondition(Object condition) {
            this.conditions.add(condition);
        }

        @Override
        public List<Object> getConditions() {
            return conditions;
        }
    }
}
