package net.mehvahdjukaar.every_compat.modules.fabric.lauchs;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_3481;
import net.minecraft.class_7924;
import net.stehschnitzel.shutter.block.Shutter;
import net.stehschnitzel.shutter.init.ShutterItemGroup;

//SUPPORT: v2.0.2+
public class LauchsShuttersModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Shutter> shutters;

    public LauchsShuttersModule(String modId) {
        super(modId, "ls");

        shutters = SimpleEntrySet.builder(WoodType.class, "shutter",
                        getModBlock("oak_shutter", Shutter.class), () -> VanillaWoodTypes.OAK,
                        w -> new Shutter(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTextureM(modRes("block/oak_shutter_lower"), EveryCompat.res("block/ls/oak_shutter_lower_m"))
                .addTextureM(modRes("block/oak_shutter_normal"), EveryCompat.res("block/ls/oak_shutter_normal_m"))
                .addTextureM(modRes("block/oak_shutter_upper"), EveryCompat.res("block/ls/oak_shutter_upper_m"))
                .addTexture(modRes("block/oak_shutter_lower_big"))
                .addTexture(modRes("block/oak_shutter_normal_big"))
                .addTexture(modRes("block/oak_shutter_upper_big"))
                .addTexture(modRes("block/oak_shutter_middle"))
                .addTexture(modRes("block/oak_shutter_middle_big"))
                .addTexture(modRes("item/oak_shutter"))
                .setRenderType(RenderLayer.CUTOUT)
                .setTab(() -> ShutterItemGroup.SHUTTER_GROUP)
                .defaultRecipe()
                .build();

        this.addEntry(shutters);
    }

//    @Override
//    public List<String> getAlreadySupportedMods() {
//        return List.of(
//                "ecologics", "quark", "twigs",
//                "autumnity", "environments", "goodending"
//        );
//    }
}
