package net.mehvahdjukaar.every_compat.modules.fabric.lightmans_currency;

import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.common.ModCreativeGroups;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7924;

//SUPPORT: v1.0.2.4+
public class LightmansCurrencyModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> shelves;
    public final SimpleEntrySet<WoodType, class_2248> card_displays;

    public LightmansCurrencyModule(String modId) {
        super(modId, "lc");
        var tab = modRes("trading");

        shelves = SimpleEntrySet.builder(WoodType.class, "", "shelf",
                        getModBlock("shelf_oak"), () -> VanillaWoodTypes.OAK,
                        w -> new ShelfBlock(FabricBlockSettings.create().nonOpaque()
                                .method_9629(2.0F, Float.POSITIVE_INFINITY)
                                .method_9626(class_2498.field_11547)
                        )
                )
                .addTile(() -> ModBlockEntities.ITEM_TRADER)
                //TEXTURE: Using planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_17754, class_7924.field_41254)
                .addTag(class_3481.field_17753, class_7924.field_41254)
                .addTag(new class_2960("create:non_movable"), class_7924.field_41254)
                .addTag(new class_2960("ftbchunks:interact_whitelist"), class_7924.field_41254)
                .addTag(modRes("trader_normal"), class_7924.field_41197)
                .addTag(modRes("shelf"), class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.SOLID)
                .build();
        this.addEntry(shelves);

        card_displays = SimpleEntrySet.builder(WoodType.class, "", "card_display",
                        getModBlock("card_display_oak"), () -> VanillaWoodTypes.OAK,
                        w -> new CardDisplayBlock(FabricBlockSettings.create().nonOpaque()
                                .method_9629(2.0F, Float.POSITIVE_INFINITY)
                                .method_9626(class_2498.field_11547)
                        )
                )
                .addTile(() -> ModBlockEntities.ITEM_TRADER)
                //TEXTURE: Using log, log_top, & planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_17754, class_7924.field_41254)
                .addTag(class_3481.field_17753, class_7924.field_41254)
                .addTag(new class_2960("create:non_movable"), class_7924.field_41254)
                .addTag(new class_2960("ftbchunks:interact_whitelist"), class_7924.field_41254)
                .addTag(modRes("trader_normal"), class_7924.field_41197)
                .addTag(modRes("shelf"), class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(card_displays);

    }

    @Override
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        event.register(shelves.getTile(ItemTraderBlockEntity.class), ItemTraderBlockEntityRenderer::new);
    }

}