/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.item.FuelBlockItem;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FarmersDelightModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, class_2248> cabinets;
    public static final PaletteStrategy customPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.reduceDown();
        if (p.size() < 9) {
            while (p.size() <= 9) {
                p.increaseInner();
            }
        } else {
            while (p.size() >= 9) {
                p.reduce();
            }
        }
    }));
    private final Map<String, String> COMPAT_RECIPE_MODS = Map.ofEntries(Map.entry("aether", "fcaether"), Map.entry("betterend", "fcbe"), Map.entry("betternether", "fcbn"), Map.entry("biomesoplenty", "fcbop"), Map.entry("biomeswevegone", "fcbwg"), Map.entry("blue_skies", "fcbs"), Map.entry("cinderscapes", "fccs"), Map.entry("eternal_starlight", "fces"), Map.entry("natures_spirit", "fcns"), Map.entry("nethers_exoticism", "fcne"), Map.entry("promenade", "fcpromenade"), Map.entry("regions_unexplored", "fcru"), Map.entry("terrestria", "fcterrestria"), Map.entry("twilightforest", "fctf"));

    public FarmersDelightModule(String modId) {
        super(modId, "fd", "everycomp");
        this.cabinets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cabinet", this.getModBlock("oak_cabinet"), () -> VanillaWoodTypes.OAK, w -> new CabinetBlock(Utils.copyPropertySafe((class_2248)w.planks))).requiresChildren(new String[]{"trapdoor", "slab"})).addTile(this.getModTile("cabinet")).addTextureM(this.modRes("block/oak_cabinet_front"), EveryCompat.res("block/fd/oak_cabinet_front_m"), customPalette)).addTexture(this.modRes("block/oak_cabinet_side"), customPalette)).addTexture(this.modRes("block/oak_cabinet_top"), customPalette)).addTexture(this.modRes("block/oak_cabinet_front_open"), customPalette)).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("cabinets/wooden"), class_7924.field_41197)).addTag(class_3481.field_33713, class_7924.field_41254)).setTabKey(this.modRes("farmersdelight"))).setTabMode(TabAddMode.AFTER_SAME_TYPE)).defaultRecipe().addCustomItem((w, block, p) -> new FuelBlockItem(block, ModItems.basicItem(), 300)).build();
        this.addEntry(this.cabinets);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                boolean isCollectionModNotInstalled;
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                String namespaceRegex = this.COMPAT_RECIPE_MODS.getOrDefault(woodType.getNamespace(), "none");
                boolean isRecipeModNotInstalled = !PlatHelper.getInstalledMods().contains(namespaceRegex);
                boolean bl = isCollectionModNotInstalled = PlatHelper.getInstalledMods().contains("mr_farmers_cuttingcollection") && !this.COMPAT_RECIPE_MODS.containsKey(woodType.getNamespace());
                if (!isRecipeModNotInstalled || !isCollectionModNotInstalled) continue;
                this.createCuttingRecipe("door", woodType.getBlockOfThis("door"), woodType, sink, manager);
                this.createCuttingRecipe("hanging_sign", woodType.getBlockOfThis("hanging_sign"), woodType, sink, manager);
                this.createCuttingRecipe("sign", woodType.getBlockOfThis("sign"), woodType, sink, manager);
                this.createCuttingRecipe("trapdoor", woodType.getBlockOfThis("trapdoor"), woodType, sink, manager);
                this.createCuttingRecipe("log", woodType.getBlockOfThis("log"), woodType, sink, manager);
                this.createCuttingRecipe("wood", woodType.getBlockOfThis("wood"), woodType, sink, manager);
            }
        });
    }

    public void createCuttingRecipe(String recipeType, class_2248 input, WoodType targetType, ResourceSink sink, class_3300 manager) {
        if (Objects.isNull(input)) {
            return;
        }
        String recipeLocation = this.modRes("cutting/oak_" + recipeType).toString();
        class_1860 recipe = RPUtils.readRecipe((class_3300)manager, (String)recipeLocation);
        if (recipe instanceof CuttingBoardRecipe) {
            CuttingBoardRecipe crRecipe = (CuttingBoardRecipe)recipe;
            String path = this.shortenedId() + "/cutting/" + targetType.getAppendableId() + "_" + recipeType;
            class_2371 oldResult = crRecipe.getRollableResults();
            class_2371 newResult = class_2371.method_10213((int)oldResult.size(), (Object)ChanceResult.EMPTY);
            for (int i = 0; i < oldResult.size(); ++i) {
                class_1792 newItem;
                ChanceResult r = (ChanceResult)oldResult.get(i);
                class_1792 critem = r.stack().method_7909();
                WoodType originalType = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((class_1935)critem);
                if (originalType == VanillaWoodTypes.OAK && (newItem = BlockSetAPI.changeItemType((class_1792)critem, (BlockType)originalType, (BlockType)targetType)) != null) {
                    newResult.set(i, (Object)new ChanceResult(r.stack().method_60503((class_1935)newItem), r.chance()));
                    continue;
                }
                newResult.set(i, (Object)r);
            }
            CuttingBoardRecipe newRec = new CuttingBoardRecipe(this.modRes("cutting").toString(), class_1856.method_8091((class_1935[])new class_1935[]{input}), crRecipe.getTool(), newResult, crRecipe.getSoundEvent());
            class_2960 recipePath = EveryCompat.res(path);
            sink.addRecipe(new class_8786(recipePath, (class_1860)newRec));
        }
    }
}

