package net.mehvahdjukaar.every_compat.modules.forge.buildersaddition;

import com.mrh0.buildersaddition.blocks.Hedge;
import com.mrh0.buildersaddition.state.HedgeState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;

@SuppressWarnings("deprecation")
public class CompatHedge  extends CompatBaseDerivativeBlock implements SimpleWaterloggedBlock, IForgeShearable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<HedgeState> STATE = EnumProperty.m_61587_("state", HedgeState.class);

    private static final VoxelShape SHAPE_NONE = Block.m_49796_(4d, 0d, 4d, 12d, 16d, 12d);
    private static final VoxelShape SHAPE_STRAIGHT_Z = Block.m_49796_(0d, 0d, 4d, 16d, 16d, 12d);
    private static final VoxelShape SHAPE_STRAIGHT_X = Block.m_49796_(4d, 0d, 0d, 12d, 16d, 16d);

    private static final VoxelShape SHAPE_SHORT_N = Block.m_49796_(4d, 0d, 0d, 12d, 16d, 4d);
    private static final VoxelShape SHAPE_SHORT_E = Block.m_49796_(12d, 0d, 4d, 16d, 16d, 12d);
    private static final VoxelShape SHAPE_SHORT_S = Block.m_49796_(4d, 0d, 12d, 12d, 16d, 16d);
    private static final VoxelShape SHAPE_SHORT_W = Block.m_49796_(0d, 0d, 4d, 4d, 16d, 12d);

    private static final VoxelShape SHAPE_CORNER_NE = Shapes.m_83124_(SHAPE_NONE, SHAPE_SHORT_N, SHAPE_SHORT_E);
    private static final VoxelShape SHAPE_CORNER_NW = Shapes.m_83124_(SHAPE_NONE, SHAPE_SHORT_N, SHAPE_SHORT_W);
    private static final VoxelShape SHAPE_CORNER_SE = Shapes.m_83124_(SHAPE_NONE, SHAPE_SHORT_S, SHAPE_SHORT_E);
    private static final VoxelShape SHAPE_CORNER_SW = Shapes.m_83124_(SHAPE_NONE, SHAPE_SHORT_S, SHAPE_SHORT_W);

    private static final VoxelShape SHAPE_T_N = Shapes.m_83110_(SHAPE_STRAIGHT_Z, SHAPE_SHORT_N);
    private static final VoxelShape SHAPE_T_E = Shapes.m_83110_(SHAPE_STRAIGHT_X, SHAPE_SHORT_E);
    private static final VoxelShape SHAPE_T_S = Shapes.m_83110_(SHAPE_STRAIGHT_Z, SHAPE_SHORT_S);
    private static final VoxelShape SHAPE_T_W = Shapes.m_83110_(SHAPE_STRAIGHT_X, SHAPE_SHORT_W);

    private static final VoxelShape SHAPE_CROSS = Shapes.m_83110_(SHAPE_STRAIGHT_X, SHAPE_STRAIGHT_Z);

    private static final VoxelShape COL_NONE = Block.m_49796_(4d, 0d, 4d, 12d, 24d, 12d);
    private static final VoxelShape COL_STRAIGHT_Z = Block.m_49796_(0d, 0d, 4d, 16d, 24d, 12d);
    private static final VoxelShape COL_STRAIGHT_X = Block.m_49796_(4d, 0d, 0d, 12d, 24d, 16d);

    private static final VoxelShape COL_SHORT_N = Block.m_49796_(4d, 0d, 0d, 12d, 24d, 4d);
    private static final VoxelShape COL_SHORT_E = Block.m_49796_(12d, 0d, 4d, 16d, 24d, 12d);
    private static final VoxelShape COL_SHORT_S = Block.m_49796_(4d, 0d, 12d, 12d, 24d, 16d);
    private static final VoxelShape COL_SHORT_W = Block.m_49796_(0d, 0d, 4d, 4d, 24d, 12d);

    private static final VoxelShape COL_CORNER_NE = Shapes.m_83124_(COL_NONE, COL_SHORT_N, COL_SHORT_E);
    private static final VoxelShape COL_CORNER_NW = Shapes.m_83124_(COL_NONE, COL_SHORT_N, COL_SHORT_W);
    private static final VoxelShape COL_CORNER_SE = Shapes.m_83124_(COL_NONE, COL_SHORT_S, COL_SHORT_E);
    private static final VoxelShape COL_CORNER_SW = Shapes.m_83124_(COL_NONE, COL_SHORT_S, COL_SHORT_W);

    private static final VoxelShape COL_T_N = Shapes.m_83110_(COL_STRAIGHT_Z, COL_SHORT_N);
    private static final VoxelShape COL_T_E = Shapes.m_83110_(COL_STRAIGHT_X, COL_SHORT_E);
    private static final VoxelShape COL_T_S = Shapes.m_83110_(COL_STRAIGHT_Z, COL_SHORT_S);
    private static final VoxelShape COL_T_W = Shapes.m_83110_(COL_STRAIGHT_X, COL_SHORT_W);

    private static final VoxelShape COL_CROSS = Shapes.m_83110_(COL_STRAIGHT_X, COL_STRAIGHT_Z);

    public CompatHedge(String name, Block source) {
        super("hedge_" + name, source);
        m_49959_(m_49966_().m_61124_(WATERLOGGED, false).m_61124_(STATE, HedgeState.None));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(STATE, WATERLOGGED);
    }

    public VoxelShape getShape(BlockState state) {
        return switch (state.m_61143_(STATE)) {
            case None -> SHAPE_NONE;
            case Straight_X -> SHAPE_STRAIGHT_X;
            case Straight_Z -> SHAPE_STRAIGHT_Z;
            case Corner_NE -> SHAPE_CORNER_NE;
            case Corner_NW -> SHAPE_CORNER_NW;
            case Corner_SE -> SHAPE_CORNER_SE;
            case Corner_SW -> SHAPE_CORNER_SW;
            case TCross_N -> SHAPE_T_N;
            case TCross_E -> SHAPE_T_E;
            case TCross_S -> SHAPE_T_S;
            case TCross_W -> SHAPE_T_W;
            case Cross -> SHAPE_CROSS;
        };

    }

    @Override
    public @NotNull VoxelShape m_5939_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos,
                                                 @NotNull CollisionContext context) {
        return switch (state.m_61143_(STATE)) {
            case None -> COL_NONE;
            case Straight_X -> COL_STRAIGHT_X;
            case Straight_Z -> COL_STRAIGHT_Z;
            case Corner_NE -> COL_CORNER_NE;
            case Corner_NW -> COL_CORNER_NW;
            case Corner_SE -> COL_CORNER_SE;
            case Corner_SW -> COL_CORNER_SW;
            case TCross_N -> COL_T_N;
            case TCross_E -> COL_T_E;
            case TCross_S -> COL_T_S;
            case TCross_W -> COL_T_W;
            case Cross -> COL_CROSS;
        };
    }

    @Override
    public @NotNull VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return getShape(state);
    }

    @SuppressWarnings({"ConstantValue", "UnreachableCode"})
    public BlockState getState(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockState bn = worldIn.m_8055_(pos.m_122012_());
        BlockState be = worldIn.m_8055_(pos.m_122029_());
        BlockState bs = worldIn.m_8055_(pos.m_122019_());
        BlockState bw = worldIn.m_8055_(pos.m_122024_());

        boolean n = bn.m_60734_() instanceof Hedge;
        boolean e = be.m_60734_() instanceof Hedge;
        boolean s = bs.m_60734_() instanceof Hedge;
        boolean w = bw.m_60734_() instanceof Hedge;

        if(n && e && s && w)
            return getNextState(state, HedgeState.Cross);

        if(!n && !e && !s && !w)
            return getNextState(state, HedgeState.None);

        else if(n && e && !s && w)
            return getNextState(state, HedgeState.TCross_N);
        else if(n && e && s && !w)
            return getNextState(state, HedgeState.TCross_E);
        else if(!n && e && s && w)
            return getNextState(state, HedgeState.TCross_S);
        else if(n && !e && s && w)
            return getNextState(state, HedgeState.TCross_W);

        else if(!e && !w && (n || s))
            return getNextState(state, HedgeState.Straight_X);
        else if(!n && !s && (e || w))
            return getNextState(state, HedgeState.Straight_Z);

        else if(n && e && !s && !w)
            return getNextState(state, HedgeState.Corner_NE);
        else if(n && !e && !s && w)
            return getNextState(state, HedgeState.Corner_NW);
        else if(!n && e && s && !w)
            return getNextState(state, HedgeState.Corner_SE);
        else if(!n && !e && s && w)
            return getNextState(state, HedgeState.Corner_SW);
        return this.m_49966_();
    }

    private BlockState getNextState(BlockState state, HedgeState shape) {
        return state.m_61124_(STATE, shape);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext c) {
        return getState(this.m_49966_(), c.m_43725_(), c.m_8083_()).m_61124_(WATERLOGGED,
                c.m_43725_().m_6425_(c.m_8083_()).m_76152_() == Fluids.f_76193_);
    }

    @Override
    public @NotNull FluidState m_5888_(BlockState state) {
        return state.m_61143_(WATERLOGGED) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public boolean m_7361_(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidStateIn) {
        return SimpleWaterloggedBlock.super.m_7361_(world, pos, state, fluidStateIn);
    }

    @Override
    public boolean m_6044_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluidIn) {
        return SimpleWaterloggedBlock.super.m_6044_(world, pos, state, fluidIn);
    }

    @Override
    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, PathComputationType type) {
        return switch (type) {
            case LAND, AIR -> false;
            case WATER -> world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public @NotNull BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn,
                                           @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if(stateIn.m_61143_(WATERLOGGED)) {
            worldIn.m_186469_(currentPos, Fluids.f_76193_, Fluids.f_76193_.m_6718_(worldIn));
        }
        return getState(stateIn, worldIn, currentPos);
    }
}
