package net.mehvahdjukaar.every_compat.modules.lieonlion;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;

//SUPPORT: v1.5.6+
public class MoreChestVariantsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;

    public MoreChestVariantsModule(String modID) {
        super(modID, "mcv");
        ResourceKey<CreativeModeTab> functionalTab = CreativeModeTabs.f_256791_;
        ResourceKey<CreativeModeTab> redstoneTab = CreativeModeTabs.f_257028_;

        String namespace = (PlatHelper.getPlatform().isForge()) ? "forge" : "c";

        chests = SimpleEntrySet.builder(WoodType.class, "chest",
                        getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatChestBlock(this::getChestTile,
                                Utils.copyPropertySafe(Blocks.f_50087_).m_284180_(MapColor.f_283825_))
                )
                .addModelTransform(m -> m.addModifier((s, blockId, woodType) ->
                    s.replace("\"lolmcv:entity/chest/oak\"",
                            "\""+woodType.createFullIdWith(EveryCompat.MOD_ID, "entity/chest", shortenedId(), "", "chest")+"\"" )
                ))
                .addTile(MoreChestBlockEntity::new)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13088_, Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/normal"), Registries.f_256747_)
                .addTag(new ResourceLocation(namespace, "chests"), Registries.f_256747_)
                .addTag(new ResourceLocation(namespace, "chests/wooden"), Registries.f_256747_)
                .addTag(new ResourceLocation("quad", "cats_on_blocks/sit"), Registries.f_256747_)
                .addTag(new ResourceLocation("quad", "fuel/wood"), Registries.f_256913_)
                .addTag(new ResourceLocation(namespace, "chests"), Registries.f_256913_)
                .addTag(new ResourceLocation(namespace, "chests/wooden"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/normal"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256913_)
                .setTabKey(functionalTab)
                .defaultRecipe()
                .build();
        this.addEntry(chests);

        trappedChests = SimpleEntrySet.builder(WoodType.class, "trapped_chest",
                        getModBlock("oak_trapped_chest"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatTrappedChestBlock(this::getTrappedTile,
                                Utils.copyPropertySafe(Blocks.f_50325_).m_284180_(MapColor.f_283825_))
                )
                .addModelTransform(m -> m.addModifier((s, blockId, woodType) ->
                    s.replace("\"lolmcv:entity/chest/trapped/oak\"",
                            "\""+woodType.createFullIdWith(EveryCompat.MOD_ID, "entity/chest", shortenedId(), "", "trapped_chest")+"\"" )
                ))
                .addTile(MoreTrappedBlockEntity::new)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13088_, Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:chests/trapped"), Registries.f_256747_)
                .addTag(new ResourceLocation(namespace, "chests"), Registries.f_256747_)
                .addTag(new ResourceLocation(namespace, "chests/wooden"), Registries.f_256747_)
                .addTag(new ResourceLocation("quad", "fuel/wood"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/trapped"), Registries.f_256913_)
                .addTag(new ResourceLocation("lieonstudio:chests/wooden"), Registries.f_256913_)
                .addTag(new ResourceLocation(namespace, "chests"), Registries.f_256913_)
                .addTag(new ResourceLocation(namespace, "chests/wooden"), Registries.f_256913_)
                .setTabKey(redstoneTab)
                .defaultRecipe()
                .build();
        this.addEntry(trappedChests);

    }

    // GetTile ---------------------------------------------------------------------------------------------------------
    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return trappedChests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity -----------------------------------------------------------------------------------------------------
    private class MoreChestBlockEntity extends CompatChestBlockEntity {
        public MoreChestBlockEntity(BlockPos pos, BlockState state) {
            super(chests.getTile(), pos, state);
        }
    }

    private class MoreTrappedBlockEntity extends CompatChestBlockEntity {
        public MoreTrappedBlockEntity(BlockPos pos, BlockState state) {
            super(trappedChests.getTile(), pos, state);
        }
    }

    // Registry --------------------------------------------------------------------------------------------------------
    @Override
    @Environment(EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        CompatChestBlockRenderer.register(event, trappedChests.getTile(CompatChestBlockEntity.class), shortenedId());
    }

    // Textures
    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) -> {
            trappedChests.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak"),
                        EveryCompat.res("entity/mcv_chest_normal_m"),
                        EveryCompat.res("entity/mcv_chest_normal_o"),
                        EveryCompat.res("entity/mcv_trapped_normal_o"), 0
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak_left"),
                        EveryCompat.res("entity/mcv_chest_left_m"),
                        EveryCompat.res("entity/mcv_chest_left_o"),
                        EveryCompat.res("entity/mcv_trapped_left_o"), 0
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak_right"),
                        EveryCompat.res("entity/mcv_chest_right_m"),
                        EveryCompat.res("entity/mcv_chest_right_o"),
                        EveryCompat.res("entity/mcv_trapped_right_o"), 0
                );

                // MODEL BLOCK
                String path = shortenedId() + "/" + wood.getAppendableId() + "_chest";
                String trapped_path = shortenedId() + "/" + wood.getAppendableId() + "_trapped_chest";

            });

        });
    }

}
