/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ColoringUtils;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.TextureGenHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends Block, I extends Item>
implements EntrySet<T> {
    public static int totalChildren = 0;
    protected static final ResourceLocation NO_TAB_MARKER = new ResourceLocation("none");
    public final Map<T, B> blocks = new HashMap<T, B>();
    public final Map<T, I> items = new HashMap<T, I>();
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String typeName;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final boolean mergePalette;
    protected final Supplier<ResourceKey<CreativeModeTab>> tab;
    protected final TabAddMode tabMode;
    protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
    protected final Set<Supplier<ResourceLocation>> recipeLocations = new HashSet<Supplier<ResourceLocation>>();
    protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraModelTransform;
    protected final Predicate<T> condition;
    protected final boolean copyTint;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergePalette, boolean copyTint, Predicate<T> condition) {
        this.typeName = (String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name;
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.tabMode = tabMode;
        this.baseType = baseType;
        this.type = type;
        this.copyTint = copyTint;
        this.extraModelTransform = extraTransform;
        this.mergePalette = mergePalette;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
        if (tab == null && PlatHelper.isDev()) {
            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
        }
    }

    @Override
    public int getBlockCount() {
        return this.blocks.size();
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public Item getItemOf(T type) {
        Item i = (Item)this.items.get(type);
        if (ModEntriesConfigs.isEntryEnabled(type, (Object)i)) {
            return i;
        }
        return null;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new ResourceLocation(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
        }
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
            ColoringUtils.copyItemTint(event, this.items);
        }
    }

    @Override
    public void registerItemsToExistingTabs(SimpleModule module, RegHelper.ItemToTabEvent event) {
        block7: {
            ResourceKey<CreativeModeTab> tab;
            block8: {
                block6: {
                    if (this.tab == null) {
                        if (PlatHelper.isDev()) {
                            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
                        }
                        return;
                    }
                    tab = this.tab.get();
                    if (tab.m_135782_().equals((Object)NO_TAB_MARKER)) {
                        return;
                    }
                    if (!BuiltInRegistries.f_279662_.m_142003_(tab)) {
                        throw new UnsupportedOperationException("Creative tab " + tab + " not registered found in the registries. This means that the target mod must have changed its name. You can either downgrade the mod" + tab.m_135782_().m_135827_() + " or wait for an Every Compat update");
                    }
                    if (this.tabMode != TabAddMode.AFTER_ALL) break block6;
                    event.add(tab, (ItemLike[])this.items.values().toArray(new Item[0]));
                    break block7;
                }
                if (this.tabMode != TabAddMode.AFTER_SAME_WOOD) break block8;
                BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
                for (Map.Entry<T, I> e : this.items.entrySet()) {
                    Item item = (Item)e.getValue();
                    BlockType wood = (BlockType)e.getKey();
                    event.addAfter(tab, s -> reg.getBlockTypeOf((ItemLike)s.m_41720_()) == wood, new ItemLike[]{item});
                }
                break block7;
            }
            if (this.tabMode != TabAddMode.AFTER_SAME_TYPE) break block7;
            BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
            String childKey = this.getChildKey(module);
            Class typeClass = this.getTypeClass();
            for (Map.Entry<T, I> e : this.items.entrySet()) {
                Item item = (Item)e.getValue();
                event.addAfter(tab, s -> {
                    BlockType type = reg.getBlockTypeOf((ItemLike)s.m_41720_());
                    if (type == null) {
                        return false;
                    }
                    return type.getClass() == typeClass && Objects.equals(type.getChildKey((Object)s.m_41720_()), childKey);
                }, new ItemLike[]{item});
            }
        }
    }

    @Override
    public void generateTags(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<ResourceLocation, Set<ResourceKey<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)tb.getKey());
                for (Map.Entry<T, ?> entry : this.getDefaultEntries().entrySet()) {
                    if (!ModEntriesConfigs.isEntryEnabled((BlockType)entry.getKey(), entry.getValue())) continue;
                    builder.addEntry(entry.getValue());
                }
                for (ResourceKey resourceKey : tb.getValue()) {
                    sink.addTag(builder, resourceKey);
                }
            }
        }
        TagUtility.addTagToAllBlocks(this.blocks, "petrified", "sullysmod", (TagKey<Block>)BlockTags.f_144282_, true, false, sink);
        String regEx = "\\w+_(log|planks|beehive|boards|sanded_wood|beam|parquet|trim|bookshelf|window|drawer|table|bookshelf|shelf|table|support|cabinet|board_stairs|board_slab|boards)";
        TagUtility.addTagToAllBlocks(this.blocks, "fright", "soulfulnether", (TagKey<Block>)BlockTags.f_13085_, true, false, sink, regEx);
    }

    public Map<T, ?> getDefaultEntries() {
        return this.blocks;
    }

    @Override
    public void generateRecipes(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        int i = 0;
        for (Supplier<ResourceLocation> r : this.recipeLocations) {
            ResourceLocation res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, sink, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res, (Object)e);
            }
        }
    }

    @Override
    public void generateTextures(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        if (this.textures.isEmpty()) {
            return;
        }
        try {
            TextureGenHelper.generateDefault(sink, manager, module.modId, this.textures, this.getBaseType(), this.mergePalette, this.getDefaultEntries());
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {}: {}", (Object)(module == null ? "dummy" : module.modRes(this.getName())), (Object)e);
        }
    }

    @Override
    @Nullable
    public Item getItemForECTab(T type) {
        if (this.tab == null) {
            if (PlatHelper.isDev()) {
                throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
            }
            EveryCompat.LOGGER.error("Creative tab cant be null. Found null one for entry set: {}", (Object)Utils.getID(this.getBaseType()).toString());
            return null;
        }
        try {
            ResourceKey<CreativeModeTab> tagKey = this.tab.get();
            if (tagKey.m_135782_().equals((Object)NO_TAB_MARKER)) {
                return null;
            }
        }
        catch (Exception e) {
            if (PlatHelper.isDev()) {
                throw e;
            }
            EveryCompat.LOGGER.error("Failed to get creative tab for EntrySet - {} : {}", (Object)Utils.getID(this.getBaseType()).toString(), (Object)e);
            return null;
        }
        return EntrySet.super.getItemForECTab(type);
    }

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends Block, I extends Item> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<ResourceKey<CreativeModeTab>> tab = null;
        protected TabAddMode tabMode = TabAddMode.AFTER_SAME_TYPE;
        protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
        protected final Set<Supplier<ResourceLocation>> recipes = new HashSet<Supplier<ResourceLocation>>();
        protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
        protected boolean useMergedPalette;
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;
        protected boolean copyTint = false;
        @Deprecated(forRemoval=true)
        protected BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> palette = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL requiresFromMap(Map<T, ?> entrySet) {
            this.addCondition(blockType -> !Objects.isNull(entrySet.get(blockType)));
            return (BL)this;
        }

        public BL excludeBlockTypes(String regEx) {
            this.addCondition(blockType -> !blockType.getId().toString().matches(regEx));
            return (BL)this;
        }

        public BL excludeBlockTypes(String modId, String ... typeIds) {
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(modId).append(":(");
            for (int i = 0; i < typeIds.length; ++i) {
                regexBuilder.append(typeIds[i]);
                if (i == typeIds.length - 1) continue;
                regexBuilder.append("|");
            }
            regexBuilder.append(")");
            this.addCondition(blockType -> !blockType.getId().toString().matches(regexBuilder.toString()));
            return (BL)this;
        }

        public BL addCondition(Predicate<T> newCondition) {
            this.condition = this.condition == null ? newCondition : this.condition.and(newCondition);
            return (BL)this;
        }

        public BL copyParentTint() {
            this.copyTint = true;
            return (BL)this;
        }

        public BL setTabMode(TabAddMode mode) {
            this.tabMode = mode;
            return (BL)this;
        }

        public BL noTab() {
            return this.setTabKey(NO_TAB_MARKER);
        }

        public BL setTabKey(ResourceLocation res) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)res);
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTabKey(Supplier<ResourceKey<CreativeModeTab>> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL setTabKey(ResourceKey<CreativeModeTab> key) {
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTab(Supplier<CreativeModeTab> tab) {
            this.tab = Suppliers.memoize(() -> (ResourceKey)BuiltInRegistries.f_279662_.m_7854_((Object)((CreativeModeTab)tab.get())).get());
            return (BL)this;
        }

        public BL addTag(ResourceLocation tag, ResourceKey<?> registries) {
            return this.addTag(tag, new ResourceKey[]{registries});
        }

        public BL addTag(ResourceLocation location, ResourceKey<?> ... registries) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.addAll(List.of(registries));
            return (BL)this;
        }

        public BL addTag(TagKey<?> tag, ResourceKey<?> registries) {
            return this.addTag(tag, new ResourceKey[]{registries});
        }

        public BL addTag(TagKey<?> tag, ResourceKey<?> ... registries) {
            this.addTag(tag.f_203868_(), registries);
            return (BL)this;
        }

        public BL addRecipe(ResourceLocation resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(TextureInfo.Builder textureLoc) {
            if (PlatHelper.getPhysicalSide().isClient()) {
                TextureInfo info = textureLoc.build();
                this.textures.add(info);
                if (info.keepNamespace()) {
                    ((DynamicTexturePack)ClientDynamicResourcesHandler.getInstance().dynamicPack).addNamespaces(new String[]{info.texture().m_135827_()});
                }
            }
            return (BL)this;
        }

        public BL addTexture(ResourceLocation resourceLocation) {
            return this.addTexture(TextureInfo.of(resourceLocation));
        }

        public BL addTexture(ResourceLocation resourceLocation, PaletteStrategy palette) {
            return this.addTexture(TextureInfo.of(resourceLocation).palette(palette));
        }

        public BL addTextureM(ResourceLocation textureLocation, ResourceLocation maskLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation));
        }

        public BL addTextureM(ResourceLocation textureLocation, ResourceLocation maskLocation, PaletteStrategy palette) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation).palette(palette));
        }

        public BL addTextureC(ResourceLocation textureLocation, String customTexturePath) {
            return this.addTexture(TextureInfo.of(textureLocation, customTexturePath));
        }

        public BL addTextureAutoM(ResourceLocation textureLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).autoMask());
        }

        public BL useMergedPalette() {
            this.useMergedPalette = true;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setPalette(BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> paletteProvider) {
            this.palette = (t, m) -> {
                Pair old = (Pair)paletteProvider.apply((Object)t, (ResourceManager)m);
                return PaletteStrategy.PaletteAndAnimation.of((List)old.getFirst(), (McMetaFile)old.getSecond());
            };
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromPlanks(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks");
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromPlanks() {
            return this.createPaletteFromPlanks(p -> {});
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.createPaletteFromChild(paletteTransform, childKey, null);
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(String childKey, Predicate<String> whichSide) {
            return this.createPaletteFromChild(p -> {}, childKey, whichSide);
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(String childKey) {
            return this.createPaletteFromChild(p -> {}, childKey, null);
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide) {
            return this.setPalette((blockType, m) -> {
                PaletteStrategy.PaletteAndAnimation p = PaletteStrategies.makePaletteFromChild(blockType, m, childKey, whichSide, paletteTransform);
                return Pair.of(p.palette(), (Object)p.animation());
            });
        }
    }
}

