package net.mehvahdjukaar.every_compat.modules.dawn_of_time;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.*;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_7924;
import org.dawnoftime.dawnoftime.block.japanese.SpruceLowTableBlock;
import org.dawnoftime.dawnoftime.block.roman.BirchCouchBlock;
import org.dawnoftime.dawnoftime.block.roman.BirchFootstoolBlock;
import org.dawnoftime.dawnoftime.block.templates.*;
import org.dawnoftime.dawnoftime.util.VoxelShapes;

import java.util.function.ToIntFunction;

import static net.mehvahdjukaar.every_compat.api.PaletteStrategies.registerCached;


//SUPPORT v1.6.3+
public class DawnOfTimeModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> BEAM;
    public final SimpleEntrySet<WoodType, class_2248> COUCH;
    public final SimpleEntrySet<WoodType, class_2248> EDGE;
    public final SimpleEntrySet<WoodType, class_2248> FANCY_FENCE;
    public final SimpleEntrySet<WoodType, class_2248> FOOTSTOOL;
    public final SimpleEntrySet<WoodType, class_2248> LATTICE;
    public final SimpleEntrySet<WoodType, class_2248> LEGLESS_CHAIR;
    public final SimpleEntrySet<WoodType, class_2248> LOW_TABLE;
    public final SimpleEntrySet<WoodType, class_2248> PERGOLA;
    public final SimpleEntrySet<WoodType, class_2248> PLATE;
    public final SimpleEntrySet<WoodType, class_2248> SUPPORT_BEAM;
    public final SimpleEntrySet<WoodType, class_2248> SUPPORT_SLAB;
    public final SimpleEntrySet<WoodType, class_2248> WALL;

    public DawnOfTimeModule(String modId) {
        super(modId, "dot", EveryCompat.MOD_ID);
        class_2960 tab = modRes("dot_tab");

        PLATE = SimpleEntrySet.builder(WoodType.class, "planks_plate",
                        getModBlock("oak_planks_plate"), () -> VanillaWoodTypes.OAK,
                        w -> new PlateBlock(Utils.copyPropertySafe(w.planks).method_50013()))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(PLATE);

        EDGE = SimpleEntrySet.builder(WoodType.class, "planks_edge",
                        getModBlock("oak_planks_edge"), () -> VanillaWoodTypes.OAK,
                        w -> new EdgeBlock(Utils.copyPropertySafe(w.planks).method_50013()))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(EDGE);

        PERGOLA = SimpleEntrySet.builder(WoodType.class, "pergola",
                        getModBlock("oak_pergola"), () -> VanillaWoodTypes.OAK,
                        w -> new PergolaBlock(Utils.copyPropertySafe(w.log).method_50013()))
                .addTextureM(modRes("block/oak_pergola"), EveryCompat.res("block/dot/oak_pergola_m"), dullPalette)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(PERGOLA);

        LATTICE = SimpleEntrySet.builder(WoodType.class, "lattice",
                        getModBlock("oak_lattice"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeBlock(Utils.copyPropertySafe(w.planks).method_22488().method_50013()))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTexture(modRes("block/oak_lattice"))
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(LATTICE);

        BEAM = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> VanillaWoodTypes.OAK,
                        w -> new BeamBlock(Utils.copyPropertySafe(w.log).method_50013()))
                .addTextureM(modRes("block/oak_beam"), EveryCompat.res("block/dot/oak_beam_m"), dullPalette)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(BEAM);

        WALL = SimpleEntrySet.builder(WoodType.class, "wall",
                        getModBlock("oak_wall"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2544(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: ???
                .addTag(class_2960.method_60656("decoration_blocks/fences_and_walls"), class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(class_3489.field_15560, class_7924.field_41197)
                .addTag(class_3489.field_15560, class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(WALL);

        SUPPORT_BEAM = SimpleEntrySet.builder(WoodType.class, "support_beam",
                        getModBlock("oak_support_beam"), () -> VanillaWoodTypes.OAK,
                        w -> new SupportBeamBlock(Utils.copyPropertySafe(w.planks).method_50013())
                )
                //TEXTURES: ???
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(SUPPORT_BEAM);

        SUPPORT_SLAB = SimpleEntrySet.builder(WoodType.class, "support_slab",
                        getModBlock("oak_support_slab"), () -> VanillaWoodTypes.OAK,
                        w -> new SupportSlabBlock(Utils.copyPropertySafe(w.planks).method_50013())
                )
                //TEXTURES: ???
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(SUPPORT_SLAB);

        FANCY_FENCE = SimpleEntrySet.builder(WoodType.class, "fancy_fence",
                        getModBlock("birch_fancy_fence"), () -> VanillaWoodTypes.BIRCH,
                        w -> new PlateBlock(Utils.copyPropertySafe(w.planks)
                                .method_50013().method_22488().method_9629(3.0F, 5.0F),
                                VoxelShapes.THIN_PLATE_SHAPES))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTexture(modRes("block/birch_fancy_fence"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(FANCY_FENCE);

        FOOTSTOOL = SimpleEntrySet.builder(WoodType.class, "footstool",
                        getModBlock("birch_footstool"), () -> VanillaWoodTypes.BIRCH,
                        w -> new BirchFootstoolBlock(Utils.copyPropertySafe(w.planks), 9.0F))
                .addTextureM(modRes("block/birch_footstool"), EveryCompat.res("block/dot/birch_footstool_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(FOOTSTOOL);

        COUCH = SimpleEntrySet.builder(WoodType.class, "couch",
                        getModBlock("birch_couch"), () -> VanillaWoodTypes.BIRCH,
                        w -> new BirchCouchBlock(Utils.copyPropertySafe(w.planks), 13.0F,
                                VoxelShapes.ROMAN_COUCH_SHAPES))
                .addTextureM(modRes("block/birch_couch"), EveryCompat.res("block/dot/birch_couch_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(COUCH);

        LOW_TABLE = SimpleEntrySet.builder(WoodType.class, "low_table",
                        getModBlock("spruce_low_table"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new SpruceLowTableBlock(Utils.copyPropertySafe(w.log).method_22488()
                                .method_9629(2.0F, 6.0F).method_9631(litBlockEmission(14))))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTexture(modRes("block/spruce_low_table"), dullPalette)
                .addTile(getModTile("displayer"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(LOW_TABLE);

        LEGLESS_CHAIR = SimpleEntrySet.builder(WoodType.class, "legless_chair",
                        getModBlock("spruce_legless_chair"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new ChairBlock(Utils.copyPropertySafe(w.log).method_22488()
                                .method_9629(2.0F, 6.0F), 3.0F,
                                VoxelShapes.SPRUCE_LEGLESS_CHAIR_SHAPES))
                .addTextureM(modRes("block/spruce_legless_chair"), EveryCompat.res("block/dot/spruce_legless_chair_m"), dullPalette)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(LEGLESS_CHAIR);
    }

    private static final PaletteStrategy dullPalette = registerCached((blockType, manager) ->
            PaletteStrategies.makePaletteFromChild(blockType, manager, VanillaWoodChildKeys.PLANKS, null,
                    (p) -> {
                p.add(p.increaseInner());
                p.add(p.increaseInner());
                p.remove(p.getLightest());
                p.remove(p.getDarkest());
                p.remove(p.getDarkest());
            }
    ));

    @SuppressWarnings("SameParameterValue")
    private static ToIntFunction<class_2680> litBlockEmission(int lightValue) {
        return (state) -> (Boolean)state.method_11654(class_2741.field_12548) ? lightValue : 0;
    }
}
