/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.xerca;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import xerca.xercamod.common.block.BlockCarvedLog;

public class XercaModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> carved1;
    public final SimpleEntrySet<WoodType, Block> carved2;
    public final SimpleEntrySet<WoodType, Block> carved3;
    public final SimpleEntrySet<WoodType, Block> carved4;
    public final SimpleEntrySet<WoodType, Block> carved5;
    public final SimpleEntrySet<WoodType, Block> carved6;
    public final SimpleEntrySet<WoodType, Block> carved7;
    public final SimpleEntrySet<WoodType, Block> carved8;
    public static final PaletteStrategy neutralPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.add(p.increaseInner());
        p.reduceDown();
        p.reduceUp();
    }));
    public static final PaletteStrategy darkPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.add(p.increaseInner());
        p.reduceDown();
        p.reduceUp();
        p.reduceUp();
    }));
    public static final PaletteStrategy darkerPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.add(p.increaseInner());
        p.reduceDown();
        p.reduceUp();
        p.reduceUp();
        p.reduceUp();
    }));
    public static final PaletteStrategy darkestPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.add(p.increaseInner());
        p.reduceDown();
        p.reduceDown();
        p.reduceUp();
        p.reduceUp();
        p.reduceUp();
    }));

    public XercaModule(String modId) {
        super(modId, "x", "everycomp");
        ResourceKey tab = CreativeModeTabs.BUILDING_BLOCKS;
        this.carved1 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "1", "carved", this.getModBlock("carved_warped_1"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_1_top"), darkerPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_1_side_abcd"), darkerPalette)).addRecipe(this.modRes("carving/carved_warped_1_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_1_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved1);
        this.carved2 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "2", "carved", this.getModBlock("carved_warped_2"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_2_top"), darkestPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_2_side_abcd"), darkestPalette)).addRecipe(this.modRes("carving/carved_warped_2_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_2_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved2);
        this.carved3 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "3", "carved", this.getModBlock("carved_warped_3"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_3_top"), darkestPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_3_side_abcd"), darkestPalette)).addRecipe(this.modRes("carving/carved_warped_3_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_3_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved3);
        this.carved4 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "4", "carved", this.getModBlock("carved_warped_4"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_4_top"), darkestPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_4_side_abcd"), darkestPalette)).addRecipe(this.modRes("carving/carved_warped_4_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_4_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved4);
        this.carved5 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "5", "carved", this.getModBlock("carved_warped_5"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_5_top"), darkestPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_5_side_ab"), darkestPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_5_side_cd"), darkestPalette)).addRecipe(this.modRes("carving/carved_warped_5_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_5_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved5);
        this.carved6 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "6", "carved", this.getModBlock("carved_warped_6"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_6_top"), darkPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_6_bottom"), darkPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_6_side_a"), darkPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_6_side_b"), darkPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_6_side_c"), darkPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_6_side_d"), darkPalette)).addRecipe(this.modRes("carving/carved_warped_6_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_6_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved6);
        this.carved7 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "7", "carved", this.getModBlock("carved_warped_7"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_7_top"), neutralPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_7_side_a"), neutralPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_7_side_bcd"), neutralPalette)).addRecipe(this.modRes("carving/carved_warped_7_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_7_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved7);
        this.carved8 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "8", "carved", this.getModBlock("carved_warped_8"), () -> VanillaWoodTypes.WARPED, w -> new BlockCarvedLog(Utils.copyPropertySafe((Block)w.log))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addModelTransform(m -> m.replaceString("\"xercamod:block/carved_wood/carved_warped\"", "\"xercamod:block/carved_wood/carved_oak\""))).addTexture(this.modRes("block/carved_wood/carved_warped_8_top"), neutralPalette)).addTexture(this.modRes("block/carved_wood/carved_warped_8_side_abcd"), neutralPalette)).addRecipe(this.modRes("carving/carved_warped_8_from_warped_log_carving"))).addRecipe(this.modRes("carving/carved_warped_8_from_stripped_warped_log_carving"))).setTabKey(tab)).build();
        this.addEntry(this.carved8);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> this.carved1.items.forEach((wood, item) -> {
            Block strippedLog = wood.getBlockOfThis("stripped_log");
            if (Objects.nonNull(strippedLog)) {
                this.recipeCreator(wood.log.asItem(), Objects.requireNonNull(strippedLog).asItem(), 1, (WoodType)wood, sink);
            }
            this.recipeCreator(wood.log.asItem(), (Item)item, 1, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)item, 1, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved2.items.get(wood), 2, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved2.items.get(wood), 2, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved3.items.get(wood), 3, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved3.items.get(wood), 3, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved4.items.get(wood), 4, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved4.items.get(wood), 4, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved5.items.get(wood), 5, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved5.items.get(wood), 5, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved6.items.get(wood), 6, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved6.items.get(wood), 6, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved7.items.get(wood), 7, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved7.items.get(wood), 7, (WoodType)wood, sink);
            this.recipeCreator(wood.log.asItem(), (Item)this.carved8.items.get(wood), 8, (WoodType)wood, sink);
            this.createRecipeIfNotNull("stripped_log", (Item)this.carved8.items.get(wood), 8, (WoodType)wood, sink);
        }));
    }

    public void recipeCreator(Item input, Item output, int num, WoodType wood, ResourceSink sink) {
        String pathBuilder = this.shortenedId() + "/" + wood.getNamespace() + "/";
        Object recipeName = wood.getTypeName() + "_log_from_" + wood.getTypeName() + "_log_carving";
        if (output == Objects.requireNonNull(wood.getBlockOfThis("stripped_log")).asItem()) {
            recipeName = (String)recipeName + "stripped_" + (String)recipeName;
        } else {
            recipeName = ((String)recipeName).replaceAll(".*", "");
            recipeName = (String)recipeName + "carved_" + wood.getTypeName() + "_" + num;
            recipeName = (String)recipeName + (input == Objects.requireNonNull(wood.getBlockOfThis("stripped_log")).asItem() ? "_from_stripped_" + wood.getTypeName() + "_log_carving" : "_from_" + wood.getTypeName() + "_log_carving");
        }
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", Utils.getID((Item)input).toString());
        JsonObject json = new JsonObject();
        json.addProperty("type", "xercamod:carving");
        json.add("ingredient", (JsonElement)ingredient);
        json.addProperty("result", Utils.getID((Item)output).toString());
        json.addProperty("count", (Number)1);
        sink.addJson(EveryCompat.res(pathBuilder + (String)recipeName), (JsonElement)json, ResType.RECIPES);
    }

    public void createRecipeIfNotNull(String input, Item output, int num, WoodType wood, ResourceSink sink) {
        if (Objects.nonNull(wood.getItemOfThis(input))) {
            this.recipeCreator(wood.getItemOfThis(input), output, num, wood, sink);
        }
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                ResourceLocation modelLocation = this.modRes("models/block/carved_wood/carved_dark_oak.json");
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                try {
                    InputStream modelStream = ((Resource)manager.getResource(modelLocation).orElseThrow()).open();
                    try {
                        JsonObject model = RPUtils.deserializeJson((InputStream)modelStream);
                        String filenameBuilder = "carved_" + woodType.getTypeName();
                        JsonObject underTextures = model.getAsJsonObject("textures");
                        String log_topPath = Objects.equals(woodType.getNamespace(), "tfc") ? ":block/wood/log_top/" + woodType.getTypeName() : ":block/" + woodType.getTypeName() + "_log_top";
                        underTextures.addProperty("up", woodType.getNamespace() + log_topPath);
                        underTextures.addProperty("down", woodType.getNamespace() + log_topPath);
                        underTextures.addProperty("particle", woodType.getNamespace() + log_topPath);
                        sink.addJson(EveryCompat.res("block/carved_wood/" + filenameBuilder), (JsonElement)model, ResType.MODELS);
                    }
                    finally {
                        if (modelStream == null) continue;
                        modelStream.close();
                    }
                }
                catch (IOException e) {
                    EveryCompat.LOGGER.error("Failed to get MODEL file @ {} : {}", (Object)modelLocation, (Object)e);
                }
            }
        });
    }
}

