package net.mehvahdjukaar.every_compat.modules.neoforge.woodster;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

//SUPPORT: v2.0.1+
public class WoodsterModule extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> chiseled_books;
    public final SimpleEntrySet<WoodType, Block> ladders;

    public WoodsterModule(String modId) {
        super(modId, "wdst");
        ResourceLocation tab = modRes(modId);

        chiseled_books = SimpleEntrySet.builder(WoodType.class, "chiseled_bookshelf",
                        getModBlock("dark_oak_chiseled_bookshelf"), () -> VanillaWoodTypes.DARK_OAK,
                        w -> new ChiseledBookShelfBlock(BlockBehaviour.Properties.of()
                                .strength(1.5F)
                                .sound(SoundType.CHISELED_BOOKSHELF)
                        )
                )
                .addTile(() -> BlockEntityType.CHISELED_BOOKSHELF)
                .addTexture(TextureInfo.of(modRes("block/everycomp_dark_oak_chiseled_bookshelf_6"), "block/dark_oak_chiseled_bookshelf_6")
                        .mask(modRes("block/everycomp_dark_oak_chiseled_bookshelf_overlay")))
                .addTexture(TextureInfo.of(modRes("block/everycomp_dark_oak_chiseled_bookshelf_side"), "block/dark_oak_chiseled_bookshelf_side"))
                .addTexture(TextureInfo.of(modRes("block/everycomp_dark_oak_chiseled_bookshelf_top"), "block/dark_oak_chiseled_bookshelf_top"))
                .addTexture(TextureInfo.of(modRes("block/everycomp_dark_oak_chiseled_bookshelf_0"), "block/dark_oak_chiseled_bookshelf_0"))
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .setTabKey(tab)
                .copyParentDrop()
                .defaultRecipe()
                .build();
        this.addEntry(chiseled_books);

        ladders = SimpleEntrySet.builder(WoodType.class, "ladder",
                        getModBlock("spruce_ladder"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new LadderBlock(BlockBehaviour.Properties.of()
                                .strength(0.4F)
                                .sound(SoundType.LADDER)
                        )
                )
                .addTexture(EveryCompat.res("block/spruce_ladder"))
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(BlockTags.CLIMBABLE, Registries.BLOCK)
                .addTag(BlockTags.FALL_DAMAGE_RESETTING, Registries.BLOCK)
                .addTag(ResourceLocation.parse("quill:ladders"), Registries.BLOCK)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(ladders);
    }
}
