/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ColoringUtils;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.TextureGenHelper;
import net.mehvahdjukaar.every_compat.misc.UtilityTag;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends class_2248, I extends class_1792>
implements EntrySet<T> {
    protected static final class_2960 NO_TAB_MARKER = class_2960.method_60656((String)"none");
    public final Map<T, B> blocks = new HashMap<T, B>();
    public final Map<T, I> items = new HashMap<T, I>();
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String typeName;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final boolean mergePalette;
    protected final Supplier<class_5321<class_1761>> tab;
    protected final TabAddMode tabMode;
    protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
    protected final Set<Supplier<class_2960>> recipeLocations = new HashSet<Supplier<class_2960>>();
    protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraModelTransform;
    protected final Predicate<T> condition;
    protected final boolean copyTint;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<class_5321<class_1761>> tab, TabAddMode tabMode, BiFunction<T, class_3300, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergePalette, boolean copyTint, Predicate<T> condition) {
        this.typeName = (String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name;
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.tabMode = tabMode;
        this.baseType = baseType;
        this.type = type;
        this.copyTint = copyTint;
        this.extraModelTransform = extraTransform;
        this.mergePalette = mergePalette;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
        if (tab == null && PlatHelper.isDev()) {
            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
        }
    }

    @Override
    public int getBlockCount() {
        return this.blocks.size();
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public class_1792 getItemOf(T type) {
        class_1792 i = (class_1792)this.items.get(type);
        if (ModEntriesConfigs.isEntryEnabled(type, (Object)i)) {
            return i;
        }
        return null;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(class_2960.method_60655((String)woodFrom, (String)wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
        }
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
            ColoringUtils.copyItemTint(event, this.items);
        }
    }

    @Override
    public void registerItemsToExistingTabs(SimpleModule module, RegHelper.ItemToTabEvent event) {
        block7: {
            class_5321<class_1761> tab;
            block8: {
                block6: {
                    if (this.tab == null) {
                        if (PlatHelper.isDev()) {
                            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
                        }
                        return;
                    }
                    tab = this.tab.get();
                    if (tab.method_29177().equals((Object)NO_TAB_MARKER) || ECConfigs.NO_MOD_CREATIVE_TAB.get().booleanValue()) {
                        return;
                    }
                    if (!class_7923.field_44687.method_35842(tab)) {
                        throw new UnsupportedOperationException("Creative tab " + String.valueOf(tab) + " not registered found in the registries. This means that the target mod must have changed its name. You can either downgrade the mod" + tab.method_29177().method_12836() + " or wait for an Every Compat update");
                    }
                    if (this.tabMode != TabAddMode.AFTER_ALL) break block6;
                    event.add(tab, (class_1935[])this.items.values().toArray(new class_1792[0]));
                    break block7;
                }
                if (this.tabMode != TabAddMode.AFTER_SAME_WOOD) break block8;
                BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
                for (Map.Entry<T, I> e : this.items.entrySet()) {
                    class_1792 item = (class_1792)e.getValue();
                    BlockType wood = (BlockType)e.getKey();
                    event.addAfter(tab, s -> reg.getBlockTypeOf((class_1935)s.method_7909()) == wood, new class_1935[]{item});
                }
                break block7;
            }
            if (this.tabMode != TabAddMode.AFTER_SAME_TYPE) break block7;
            BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
            String childKey = this.getChildKey(module);
            Class typeClass = this.getTypeClass();
            for (Map.Entry<T, I> e : this.items.entrySet()) {
                class_1792 item = (class_1792)e.getValue();
                event.addAfter(tab, s -> {
                    BlockType type = reg.getBlockTypeOf((class_1935)s.method_7909());
                    if (type == null) {
                        return false;
                    }
                    return type.getClass() == typeClass && Objects.equals(type.getChildKey((Object)s.method_7909()), childKey);
                }, new class_1935[]{item});
            }
        }
    }

    @Override
    public void generateTags(SimpleModule module, class_3300 manager, ResourceSink sink) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<class_2960, Set<class_5321<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)tb.getKey());
                for (Map.Entry<T, ?> entry : this.getDefaultEntries().entrySet()) {
                    if (!ModEntriesConfigs.isEntryEnabled((BlockType)entry.getKey(), entry.getValue())) continue;
                    builder.addEntry(entry.getValue());
                }
                for (class_5321 class_53212 : tb.getValue()) {
                    sink.addTag(builder, class_53212);
                }
            }
        }
        UtilityTag.addTagToAllBlocks(this.blocks, "petrified", "sullysmod", class_3481.field_33715.comp_327().toString(), true, false, sink);
        String regEx = "\\w+_(log|planks|beehive|boards|sanded_wood|beam|parquet|trim|bookshelf|window|drawer|table|bookshelf|shelf|table|support|cabinet|board_stairs|board_slab|boards)";
        UtilityTag.addTagToAllBlocks(this.blocks, "fright", "soulfulnether", class_3481.field_23119.comp_327().toString(), true, false, sink, regEx);
        UtilityTag.addTagToAllBlocks(this.blocks, "(brimwood|cobalt|dead|yellow_bioshroom)", "regions_unexplored", class_3481.field_23209.comp_327().toString(), true, false, sink);
        UtilityTag.addTagToAllBlocks(this.blocks, "(brimwood|cobalt|dead|yellow_bioshroom)", "regions_unexplored", "minecraft:non_flammable_wood", false, true, sink);
        UtilityTag.addTagToAllBlocks(this.blocks, "\\w+_chest", "", UtilityTag.platformTag("chests/wooden").toString(), true, true, sink);
    }

    public Map<T, ?> getDefaultEntries() {
        return this.blocks;
    }

    @Override
    public void generateRecipes(SimpleModule module, class_3300 manager, ResourceSink sink) {
        int i = 0;
        for (Supplier<class_2960> r : this.recipeLocations) {
            class_2960 res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, sink, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res, (Object)e);
            }
        }
    }

    @Override
    public void generateTextures(SimpleModule module, class_3300 manager, ResourceSink sink) {
        if (this.textures.isEmpty()) {
            return;
        }
        try {
            TextureGenHelper.generateDefault(sink, manager, module.modId, this.textures, this.getBaseType(), this.mergePalette, this.getDefaultEntries());
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {}: {}", (Object)(module == null ? "dummy" : module.modRes(this.getName())), (Object)e);
        }
    }

    @Override
    @Nullable
    public class_1792 getItemForECTab(T type) {
        if (this.tab == null) {
            if (PlatHelper.isDev()) {
                throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
            }
            EveryCompat.LOGGER.error("Creative tab cant be null. Found null one for entry set: {}", (Object)Utils.getID(this.getBaseType()).toString());
            return null;
        }
        try {
            class_5321<class_1761> tagKey = this.tab.get();
            if (tagKey.method_29177().equals((Object)NO_TAB_MARKER)) {
                return null;
            }
        }
        catch (Exception e) {
            if (PlatHelper.isDev()) {
                throw e;
            }
            EveryCompat.LOGGER.error("Failed to get creative tab for EntrySet - {} : {}", (Object)Utils.getID(this.getBaseType()).toString(), (Object)e);
            return null;
        }
        return EntrySet.super.getItemForECTab(type);
    }

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends class_2248, I extends class_1792> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<class_5321<class_1761>> tab = null;
        protected TabAddMode tabMode = TabAddMode.AFTER_SAME_TYPE;
        protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
        protected final Set<Supplier<class_2960>> recipes = new HashSet<Supplier<class_2960>>();
        protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
        protected boolean useMergedPalette;
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;
        protected boolean copyTint = false;
        @Deprecated(forRemoval=true)
        protected BiFunction<T, class_3300, PaletteStrategy.PaletteAndAnimation> palette = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL requiresFromMap(Map<T, ?> entrySet) {
            this.addCondition(blockType -> !Objects.isNull(entrySet.get(blockType)));
            return (BL)this;
        }

        public BL excludeBlockTypes(String regEx) {
            this.addCondition(blockType -> !blockType.getId().toString().matches(regEx));
            return (BL)this;
        }

        public BL excludeBlockTypes(String modId, String ... typeIds) {
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(modId).append(":(");
            for (int i = 0; i < typeIds.length; ++i) {
                regexBuilder.append(typeIds[i]);
                if (i == typeIds.length - 1) continue;
                regexBuilder.append("|");
            }
            regexBuilder.append(")");
            this.addCondition(blockType -> !blockType.getId().toString().matches(regexBuilder.toString()));
            return (BL)this;
        }

        public BL addCondition(Predicate<T> newCondition) {
            this.condition = this.condition == null ? newCondition : this.condition.and(newCondition);
            return (BL)this;
        }

        public BL copyParentTint() {
            this.copyTint = true;
            return (BL)this;
        }

        public BL setTabMode(TabAddMode mode) {
            this.tabMode = mode;
            return (BL)this;
        }

        public BL noTab() {
            return this.setTabKey(NO_TAB_MARKER);
        }

        public BL setTabKey(class_2960 res) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)res);
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTabKey(Supplier<class_5321<class_1761>> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL setTabKey(class_5321<class_1761> key) {
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTab(Supplier<class_1761> tab) {
            this.tab = Suppliers.memoize(() -> (class_5321)class_7923.field_44687.method_29113((Object)((class_1761)tab.get())).get());
            return (BL)this;
        }

        public BL addTag(class_2960 tag, class_5321<?> registries) {
            return this.addTag(tag, new class_5321[]{registries});
        }

        public BL addTag(class_2960 location, class_5321<?> ... registries) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.addAll(List.of(registries));
            return (BL)this;
        }

        public BL addTag(class_6862<?> tag, class_5321<?> registries) {
            return this.addTag(tag, new class_5321[]{registries});
        }

        public BL addTag(class_6862<?> tag, class_5321<?> ... registries) {
            this.addTag(tag.comp_327(), registries);
            return (BL)this;
        }

        public BL addRecipe(class_2960 resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(TextureInfo.Builder textureLoc) {
            if (PlatHelper.getPhysicalSide().isClient()) {
                TextureInfo info = textureLoc.build();
                this.textures.add(info);
                if (info.keepNamespace()) {
                    ClientDynamicResourcesHandler.getInstance().getPackResources().addNamespaces(new String[]{info.texture().method_12836()});
                }
            }
            return (BL)this;
        }

        public BL addTexture(class_2960 resourceLocation) {
            return this.addTexture(TextureInfo.of(resourceLocation));
        }

        public BL addTexture(class_2960 resourceLocation, PaletteStrategy palette) {
            return this.addTexture(TextureInfo.of(resourceLocation).setPalette(palette));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation, class_2960 overlayLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation).overlay(overlayLocation));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation, PaletteStrategy palette) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation).setPalette(palette));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation, class_2960 overlayLocation, PaletteStrategy palette) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation).overlay(overlayLocation).setPalette(palette));
        }

        public BL addTextureC(class_2960 textureLocation, String customTexturePath) {
            return this.addTexture(TextureInfo.of(textureLocation, customTexturePath));
        }

        public BL addTextureC(class_2960 textureLocation, PaletteStrategy palette, String customTexturePath) {
            return this.addTexture(TextureInfo.of(textureLocation, customTexturePath).setPalette(palette));
        }

        public BL addTextureMC(class_2960 textureLocation, class_2960 maskLocation, PaletteStrategy palette, String customTexturePath) {
            return this.addTexture(TextureInfo.of(textureLocation, customTexturePath).mask(maskLocation).setPalette(palette));
        }

        public BL copyTexture(class_2960 textureLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).copyTexture());
        }

        public BL useMergedPalette() {
            this.useMergedPalette = true;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setPalette(BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteProvider) {
            this.palette = (t, m) -> {
                Pair old = (Pair)paletteProvider.apply((Object)t, (class_3300)m);
                return PaletteStrategy.PaletteAndAnimation.of((List)old.getFirst(), (McMetaFile)old.getSecond());
            };
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromPlanks(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks");
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromPlanks() {
            return this.createPaletteFromPlanks(p -> {});
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.createPaletteFromChild(paletteTransform, childKey, null);
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(String childKey, Predicate<String> whichSide) {
            return this.createPaletteFromChild(p -> {}, childKey, whichSide);
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(String childKey) {
            return this.createPaletteFromChild(p -> {}, childKey, null);
        }

        @Deprecated(forRemoval=true)
        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide) {
            return this.setPalette((blockType, m) -> {
                PaletteStrategy.PaletteAndAnimation p = PaletteStrategies.makePaletteFromChild(blockType, m, childKey, whichSide, paletteTransform);
                return Pair.of(p.palette(), (Object)p.animation());
            });
        }
    }
}

