package net.mehvahdjukaar.every_compat.api;

import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public interface EntrySet<T extends BlockType> {


    String getName();

    @NotNull
    default String getChildKey(SimpleModule module) {
        return module.getModId() + ":" + getName();
    }

    Class<T> getTypeClass();

    void addTranslations(SimpleModule module, AfterLanguageLoadEvent lang);

    void registerBlocks(SimpleModule module, Registrator<class_2248> registry, Collection<T> woodTypes);

    void registerItems(SimpleModule module, Registrator<class_1792> registry);

    void registerTiles(SimpleModule module, Registrator<class_2591<?>> registry);

    void setRenderLayer();

    void generateTags(SimpleModule module,  class_3300 manager, ResourceSink pack);

    void generateLootTables(SimpleModule module,  class_3300 manager, ResourceSink pack);

    void generateRecipes(SimpleModule module, class_3300 manager, ResourceSink pack);

    void generateModels(SimpleModule module, class_3300 manager, ResourceSink sink);

    void generateTextures(SimpleModule module, class_3300 manager, ResourceSink sink);

    default void setupExistingTiles() {
    }

    //used for tabs
    @Nullable
    default class_1792 getItemOf(T type) {
        return null;
    }

    void registerItemColors(ClientHelper.ItemColorEvent event);

    void registerBlockColors(ClientHelper.BlockColorEvent event);

    void registerItemsToExistingTabs(SimpleModule module, RegHelper.ItemToTabEvent event);

    @Nullable
    default class_1792 getItemForECTab(T type) {
        return this.getItemOf(type);
    }

    int getBlockCount();
}
