package net.mehvahdjukaar.every_compat.api;

import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record TextureInfo(class_2960 texture, @Nullable class_2960 mask,
                          boolean keepNamespace, boolean copyTexture, String customTexturePath, boolean copyMCMETA, boolean autoMask,
                          boolean onAtlas) {

    public static Builder of(class_2960 res) {
        return new Builder(res);
    }

    public static Builder of(class_2960 res, class_2960 mask) {
        return new Builder(res).mask(mask);
    }

    public static Builder of(class_2960 res, String customTexturePath) {
        return new Builder(res).customTexture(customTexturePath);
    }

    public static final class Builder {
        private final class_2960 texture;
        private class_2960 mask;
        private boolean keepNamespace = false;
        private boolean copyTexture = false;
        private boolean copyMCMETA = false;
        private boolean autoMask = false;
        private boolean onAtlas;
        private String customTexturePath;

        public Builder(class_2960 texture) {
            this.texture = texture;
            this.onAtlas = !texture.method_12832().startsWith("entity/");
        }

        public Builder mask(class_2960 mask) {
            this.mask = mask;
            return this;
        }

        // for textures not on atlas that won't be cleared
        public Builder forEntityOrGui(){
            this.onAtlas = false;
            return this;
        }

        public Builder keepNamespace() {
            this.keepNamespace = true;
            return this;
        }

        public Builder copyTexture() {
            this.copyTexture = true;
            return this;
        }

        public Builder customTexture(String customTexturePath) {
            this.customTexturePath = customTexturePath;
            return this;
        }

        public Builder copyMCMETA() {
            this.copyMCMETA = true;
            return this;
        }

        public Builder autoMask() {
            this.autoMask = true;
            return this;
        }

        public TextureInfo build() {
            return new TextureInfo(texture, mask, keepNamespace,
                    copyTexture, customTexturePath, copyMCMETA, autoMask, onAtlas);
        }
    }
}
