package net.mehvahdjukaar.every_compat.misc;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayInputStream;
import java.util.*;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressWarnings("unused")
public class ResourcesUtils {


    @SuppressWarnings("PointlessBooleanExpression")
    public static <B extends class_2248, T extends BlockType> void generateStandardBlockModels(
            class_3300 manager, ResourceSink sink,
            Map<T, B> blocks, T baseType,
            BlockTypeResTransformer<T> modelTransformer,
            BlockTypeResTransformer<T> blockStateTransformer,
            ModelConfiguration modelConfig
    ) {

        if (blocks.isEmpty()) return;

        //finds one entry to grab the baseType equivalent (oak, stone, iron or amethyst)
        var first = blocks.entrySet().stream().findFirst().get();
        class_2248 baseBlock = BlockType.changeBlockType(first.getValue(), first.getKey(), baseType);

        if (baseBlock == null) {
            EveryCompat.LOGGER.error("Skipped generating some block assets because oakBlock is null for {}", Utils.getID(first.getValue()));
            return;
        }

        class_2960 baseId = Utils.getID(baseBlock);

        Set<String> modelsLoc = new HashSet<>();

        /// Blockstate & Models
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail(manager, ResType.BLOCKSTATES.getPath(baseId));

            JsonElement insideBlockstates = RPUtils.deserializeJson(new ByteArrayInputStream(oakBlockstate.data));

            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive(insideBlockstates, s -> s.equals("model")));

            List<StaticResource> oakBlockModels = gatherNonVanillaModels(manager, modelsLoc, modelConfig);

            blocks.forEach((blockType, block) -> {
                class_2960 blockId = Utils.getID(block);
                try {
                    if (true || ModEntriesConfigs.isEntryEnabled(blockType, block)) { //generating all the times otherwise we get log spam
                        /// Creates blockstate
                        StaticResource newBlockState = blockStateTransformer.transform(oakBlockstate, blockId, blockType);
                        Preconditions.checkArgument(newBlockState.location != oakBlockstate.location,
                                "ids cant be the same: " + newBlockState.location);
                        //Adding to the resources
                        sink.addResourceIfNotPresent(manager, newBlockState);

                        /// Creates models/block
                        for (StaticResource model : oakBlockModels) {
                            try {
                                // Modifying models' contents & path
                                StaticResource newModel = modelTransformer.transform(model, blockId, blockType);

                                Preconditions.checkArgument(newModel.location != model.location,
                                        "ids cant be the same: " + newModel.location);
                                //Adding to the resources
                                sink.addResourceIfNotPresent(manager, newModel);
                            } catch (Exception e) {
                                EveryCompat.LOGGER.error("Failed to add {}'s models/block file: {}", Utils.getID(block), e.getMessage());
                            }
                        }
                    }
//                    else {
//                        //dummy blockstate so we don't generate models for this
//                        sink.addJson(blockId, DUMMY_BLOCKSTATE, ResType.BLOCKSTATES);
//                    }

                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {}'s blockstate file: {}", block, e.getMessage());
                }
            });
        } catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find blockstate definition for {}", baseId);
        }

    }

    private static List<StaticResource> gatherNonVanillaModels(class_3300 manager, Set<String> modelsLoc, ModelConfiguration modelConfig) {
        List<StaticResource> models = new ArrayList<>();

        for (var m : modelsLoc) {
            //remove the ones from mc namespace
            class_2960 modelRes = new class_2960(m);
            if (!modelRes.method_12836().equals("minecraft") || modelConfig.blockModel().contains(modelRes) || modelConfig.itemModel().contains(modelRes)) {
                StaticResource model = StaticResource.getOrLog(manager, ResType.MODELS.getPath(m));
                if (Objects.nonNull(model)) models.add(model);
            }
        }
        if (modelConfig.includeInGeneration()) {
            for (var currentModel : modelConfig.blockModel()) {
                StaticResource model = StaticResource.getOrLog(manager, ResType.MODELS.getPath(currentModel));
                if (Objects.nonNull(model)) models.add(model);
            }
        }
        return models;
    }


    //same as above just with just item models. a bunch of copy paste here... ugly
    @SuppressWarnings("PointlessBooleanExpression")
    public static <I extends class_1792, T extends BlockType> void generateStandardItemModels(
            class_3300 manager, ResourceSink sink,
            Map<T, I> items, T baseType, BlockTypeResTransformer<T> itemModelTransformer,
            ModelConfiguration modelConfig
    ) {

        if (items.isEmpty()) return;

        //finds one entry. used so we can grab the oak equivalent
        var first = items.entrySet().stream().findFirst().get();
        class_1792 oakItem = BlockType.changeItemType(first.getValue(), first.getKey(), baseType);

        if (oakItem == null) {
            EveryCompat.LOGGER.error("Skipped generating some item assets because oakItem is NULL for {}", Utils.getID(first.getValue()));
            return;
        }
        String baseItemName = baseType.getTypeName();

        Set<String> modelsLoc = new HashSet<>();

        /// Models/item
        try {
            //we cant use this since it might override parent too. Custom textured items need a custom model added manually with addBlockResources
            // modelModifier.replaceItemType(baseItemname);

            StaticResource oakItemModel = StaticResource.getOrFail(manager,
                    ResType.ITEM_MODELS.getPath(Utils.getID(oakItem)));

            JsonObject json = RPUtils.deserializeJson(new ByteArrayInputStream(oakItemModel.data));
            //adds models referenced from here. not recursive
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive(json, s -> s.equals("model") || s.equals("parent")));

            if (json.has("parent")) {
                String parent = json.get("parent").getAsString();
                if (parent.contains("item/generated")) {
                    itemModelTransformer.replaceItemType(baseItemName);
                }
            }

            items.forEach((blockType, item) -> {
                class_2960 id = Utils.getID(item);
                try {
                    StaticResource newRes = itemModelTransformer.transform(oakItemModel, id, blockType);
                    Preconditions.checkArgument(newRes.location != oakItemModel.location,
                            "ids cant be the same: " + newRes.location);
                    sink.addResourceIfNotPresent(manager, newRes);
                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} item model json file:", item, e);
                }
            });
        } catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find item model for {}", oakItem);
        }


        //models
        List<StaticResource> oakItemModels = gatherNonVanillaModels(manager, modelsLoc, modelConfig);

        items.forEach((w, b) -> {
            class_2960 id = Utils.getID(b);
            if (true || ModEntriesConfigs.isEntryEnabled(w, b)) { //generating all the times otherwise we get log spam

                //creates item model
                for (StaticResource model : oakItemModels) {
                    try {
                        StaticResource newModel = itemModelTransformer.transform(model, id, w);
                        assert newModel.location != model.location : "ids cant be the same";
                        sink.addResourceIfNotPresent(manager, newModel);
                    } catch (Exception exception) {
                        EveryCompat.LOGGER.error("Failed to add {} model json file:", b, exception);
                    }
                }
            }
        });
    }

    @NotNull
    @SuppressWarnings("UnusedReturnValue")
    public static <T extends BlockType> BlockTypeResTransformer<T> addBuiltinModelTransformer(
            BlockTypeResTransformer<T> transformer, T baseType) {
        String oldTypeName = baseType.getTypeName();

        // Modifying models' filename & ResourceLocation
        transformer.setIDModifier((text, id, w) ->
                BlockTypeResTransformer.replaceFullGenericType(text, w, id, oldTypeName, null, 2));

        // Modifying the model files' content
        if (baseType instanceof LeavesType leavesType) {
            SpriteHelper.replaceLeavesTextures(transformer, leavesType);
            var woodT = leavesType.getWoodType();
            if (woodT != null) {
                SpriteHelper.replaceWoodTextures(transformer, woodT);
            }
        } else if (baseType instanceof WoodType woodType) {
            SpriteHelper.replaceWoodTextures(transformer, woodType);
        }

        transformer.replaceGenericType(oldTypeName, "block");

        return transformer;
    }


    //creates and add new jsons based off the ones at the given resources with the provided modifiers
    public static <B extends class_2248, T extends BlockType> void addBlockResources(class_3300 manager, ResourceSink pack,
                                                                                Map<T, B> blocks,
                                                                                BlockTypeResTransformer<T> modifier, class_2960... jsonsLocations) {
        List<StaticResource> original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog(manager, s)).toList();

        blocks.forEach((wood, value) -> {
            if (ModEntriesConfigs.isEntryEnabled(wood, value)) {
                for (var res : original) {

                    try {
                        StaticResource newRes = modifier.transform(res, Utils.getID(value), wood);

                        Preconditions.checkArgument(newRes.location != res.location,
                                "ids cant be the same: " + newRes.location);

                        pack.addResource(newRes);
                    } catch (Exception e) {
                        if (res != null) {
                            EveryCompat.LOGGER.error("Failed to generate json resource from {}", res.location);
                        }
                    }
                }
            }
        });
    }

    //creates and add new recipes based off the one at the given resource

    /**
     * Adds recipes based off an oak leaves based one
     */
    public static void addLeavesRecipes(String modId, class_3300 manager, ResourceSink pack,
                                        Map<LeavesType, class_1792> blocks, String oakRecipe) {
        addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, LeavesTypeRegistry.OAK_TYPE);
    }

    /**
     * Adds recipes based off an oak planks based one
     */
    public static <B extends class_1792> void addWoodRecipes(String modId, class_3300 manager, ResourceSink pack,
                                                       Map<WoodType, B> blocks, String oakRecipe) {
        addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, WoodTypeRegistry.OAK_TYPE);
    }

    /**
     * Adds recipes based off a given one
     */
    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(String modId, class_3300 manager, ResourceSink pack,
                                                                              Map<T, B> blocks, String oakRecipe, T fromType) {
        addBlocksRecipes(manager, pack, blocks, new class_2960(modId, oakRecipe), fromType, 0);
    }

    @SuppressWarnings("removal")
    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(class_3300 manager, ResourceSink pack,
                                                                              Map<T, B> items, class_2960 oakRecipe, T fromType,
                                                                              int index) {
        IRecipeTemplate<?> template = RPUtils.readRecipeAsTemplate(manager,
                ResType.RECIPES.getPath(oakRecipe));

        items.forEach((w, i) -> {

            //check for disabled ones. //
            if (ModEntriesConfigs.isEntryEnabled(w, i)) {
                // Will actually crash if its null since vanilla recipe builder expects a non-null one
                try {
                    String blockId = class_5797.method_36442(i).toString();
                    class_2444 newR;

                    String oakRecipePath = oakRecipe.method_12832();
                    String modifiedRecipe = oakRecipePath.substring(oakRecipePath.lastIndexOf("/") + 1).replace(fromType.getTypeName(), w.getTypeName());
                    String target = blockId.substring(blockId.lastIndexOf("/") + 1);
                    // Replaced the >text< with modifiedRecipe: everycomp:q/biomesoplenty/ >fir_vertical_slab<
                    String newId = blockId.replace(target, modifiedRecipe);

                    if (!blockId.equals(newId)) {
                        newR = template.createSimilar(fromType, w, w.mainChild().method_8389(), newId);
                    }
                    else {
                        newR = template.createSimilar(fromType, w, w.mainChild().method_8389());
                    }
                    if (newR == null) return;

                    newR = ForgeHelper.addRecipeConditions(newR, template.getConditions()); //not even needed

                    // Adding to the resources
                    pack.addRecipe(newR);
                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate recipe @ {} for {}: {}", oakRecipe, i, e.getMessage());
                }
            }
        });
    }


    private static final JsonObject DUMMY_BLOCKSTATE;

    static {
        DUMMY_BLOCKSTATE = new JsonObject();
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", t);
    }


    public static <T extends BlockType> class_1856 convertIngredient(class_1856 ingredient, T originalMat, T destinationMat) {
        class_1856 newIng = ingredient;
        for (var in : ingredient.method_8105()) {
            class_1792 it = in.method_7909();
            if (it != class_1802.field_8077) {
                class_1935 i = BlockType.changeItemType(it, originalMat, destinationMat);
                if (i != null) {
                    //converts first ingredient it finds
                    newIng = class_1856.method_8091(i);
                    break;
                }
            }
        }
        return newIng;
    }

    protected static final String RES_CHARS = "[a-z,A-Z,\\-,_./]*";
    protected static final Pattern RES_PATTERN = Pattern.compile("\"(" + RES_CHARS + ":" + RES_CHARS + ")\"");

    public static String convertItemIDinText(String text, BlockType fromType, BlockType toType) {
        Matcher matcher = RES_PATTERN.matcher(text);
        return matcher.replaceAll(m -> {
            var item = class_7923.field_41178.method_17966(class_2960.method_12829(m.group(1)));
            return item.map(value ->
                    mapOfItem.getOrDefault(item.get().toString(),
                            "\"" + Utils.getID(BlockType.changeItemType(value, fromType, toType)).toString() + "\"")
                    ).orElseGet(() -> m.group(0));
        });
    }

    /**
     * if item (key) matched the following below, then instead of "minecraft:air", the value will be used
     * NOTE:
     * Quark's bookshelf and it's loot_table where it has "minecraft:booK" will be replaced with
     * "minecraft:air". A similar case with "minecraft:shulker_box" also happened, too.
    **/
    private static final Map<String, String> mapOfItem = Map.of(
            "shulker_box", "\"minecraft:shulker_box\"",
            "book", "\"minecraft:book\""
    );

}
