package net.mehvahdjukaar.every_compat.modules.furnish;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.*;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

// SUPPORT: v24+
public class FurnishModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> bedsideTable;
    public final SimpleEntrySet<WoodType, class_2248> bench;
    public final SimpleEntrySet<WoodType, class_2248> cabinet;
    public final SimpleEntrySet<WoodType, class_2248> chair;
    public final SimpleEntrySet<WoodType, class_2248> coffin;
    public final SimpleEntrySet<WoodType, class_2248> crate;
    public final SimpleEntrySet<WoodType, class_2248> kitchenCabinet;
    public final SimpleEntrySet<WoodType, class_2248> ladder;
    public final SimpleEntrySet<WoodType, class_2248> logBenches;
    public final SimpleEntrySet<WoodType, class_2248> pedestalTable;
    public final SimpleEntrySet<WoodType, class_2248> shelf;
    public final SimpleEntrySet<WoodType, class_2248> shutter;
    public final SimpleEntrySet<WoodType, class_2248> squareTable;
    public final SimpleEntrySet<WoodType, class_2248> stool;
    public final SimpleEntrySet<WoodType, class_2248> table;
    public final SimpleEntrySet<WoodType, class_2248> wardrobe;
    public final SimpleEntrySet<WoodType, class_2248> bookshelfChest;

    public FurnishModule(String modId) {
        super(modId, "fur");
        class_2960 tab = modRes(Furnish.MODID);

        TemplateRecipeManager.registerTemplate(modRes("furniture_making"), FurnishRecipeTemplate::new);

        table = SimpleEntrySet.builder(WoodType.class, "table",
                        getModBlock("oak_table"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Table(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(table);

        squareTable = SimpleEntrySet.builder(WoodType.class, "square_table",
                        getModBlock("oak_square_table"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new SimpleFurniture(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_square_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(squareTable);

        pedestalTable = SimpleEntrySet.builder(WoodType.class, "pedestal_table",
                        getModBlock("oak_pedestal_table"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new SimpleFurniture(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_pedestal_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(pedestalTable);

        bedsideTable = SimpleEntrySet.builder(WoodType.class, "bedside_table",
                        getModBlock("oak_bedside_table"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new InventoryFurniture(Utils.copyPropertySafe(w.log), FurnishRegistries.Drawers_Open_Sound, FurnishRegistries.Drawers_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTile(FurnishRegistries.Furniture_BlockEntity)
                .addRecipe(modRes("furniture_making/oak_bedside_table"))
                .setTabKey(tab)
                .build();
        this.addEntry(bedsideTable);

        kitchenCabinet = SimpleEntrySet.builder(WoodType.class, "kitchen_cabinet",
                        FurnishBlocks.Oak_Kitchen_Cabinet, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new InventoryFurniture(Utils.copyPropertySafe(w.planks), FurnishRegistries.Drawers_Open_Sound, FurnishRegistries.Drawers_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTile(FurnishRegistries.Furniture_BlockEntity)
                .addRecipe(modRes("furniture_making/oak_kitchen_cabinet"))
                .setTabKey(tab)
                .build();
        this.addEntry(kitchenCabinet);

        cabinet = SimpleEntrySet.builder(WoodType.class, "cabinet",
                        FurnishBlocks.Birch_Cabinet, () -> WoodTypeRegistry.getValue(new ResourceLocation("birch")),
                        w -> new Cabinet(Utils.copyPropertySafe(w.log), FurnishRegistries.Cabinet_Open_Sound, FurnishRegistries.Cabinet_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTile(FurnishRegistries.Furniture_BlockEntity)
                .addTexture(modRes("block/birch_cabinet_door_right"))
                .addTexture(modRes("block/birch_cabinet_door_left"))
                .addRecipe(modRes("furniture_making/birch_cabinet"))
                .setTabKey(tab)
                .build();
        this.addEntry(cabinet);

        wardrobe = SimpleEntrySet.builder(WoodType.class, "wardrobe",
                        FurnishBlocks.Birch_Wardrobe, () -> WoodTypeRegistry.getValue(new ResourceLocation("birch")),
                        w -> new Wardrobe(Utils.copyPropertySafe(w.log), FurnishRegistries.Cabinet_Open_Sound, FurnishRegistries.Cabinet_Close_Sound)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTile(FurnishRegistries.Large_Furniture_BlockEntity)
                .addTexture(modRes("block/birch_wardrobe_door_bottom_right"))
                .addTexture(modRes("block/birch_wardrobe_door_bottom_left"))
                .addTexture(modRes("block/birch_wardrobe_door_top_right"))
                .addTexture(modRes("block/birch_wardrobe_door_top_left"))
                .addRecipe(modRes("furniture_making/birch_wardrobe"))
                .setTabKey(tab)
                .build();
        this.addEntry(wardrobe);

        stool = SimpleEntrySet.builder(WoodType.class, "stool",
                        FurnishBlocks.Oak_Stool, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Chair(Utils.copyPropertySafe(w.log), Chair.BASE_SHAPES)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_stool"))
                .setTabKey(tab)
                .build();
        this.addEntry(stool);

        chair = SimpleEntrySet.builder(WoodType.class, "chair",
                        FurnishBlocks.Oak_Chair, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Chair(Utils.copyPropertySafe(w.log),
                                VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_SEAT))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_chair"))
                .setTabKey(tab)
                .build();
        this.addEntry(chair);

        shutter = SimpleEntrySet.builder(WoodType.class, "shutter",
                        FurnishBlocks.Oak_Shutter, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Shutter(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("trapdoor") //REASON: recipes
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_shutter"))
                .addTexture(modRes("block/oak_shutter"))
                .setTabKey(tab)
                .build();
        this.addEntry(shutter);

        crate = SimpleEntrySet.builder(WoodType.class, "crate",
                        FurnishBlocks.Oak_Crate, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Crate(Utils.copyPropertySafe(w.planks))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(modRes("crates"), class_7924.field_41254)
                .addTag(modRes("wooden_furniture"), class_7924.field_41197)
                .addTag(modRes("mail"), class_7924.field_41197)
                .addTag(modRes("crates"), class_7924.field_41197)
                .addTag(modRes("crate_blacklist"), class_7924.field_41197)
                .addRecipe(modRes("furniture_making/oak_crate"))
                .addTexture(modRes("block/oak_crate_side"))
                .addTexture(modRes("block/oak_crate_top"))
                .setTabKey(tab)
                .addCustomItem((woodType, block, properties) -> new BlockItem(block, properties.stacksTo(1))
                )
                .copyParentDrop()
                .build();
        this.addEntry(crate);

        shelf = SimpleEntrySet.builder(WoodType.class, "shelf",
                        FurnishBlocks.Oak_Shelf, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Shelf(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTile(FurnishRegistries.Shelf_BlockEntity)
                .addRecipe(modRes("furniture_making/oak_shelf"))
                .setTabKey(tab)
                .build();
        this.addEntry(shelf);

        bench = SimpleEntrySet.builder(WoodType.class, "bench",
                        FurnishBlocks.Oak_Bench, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Bench(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_bench"))
                .setTabKey(tab)
                .build();
        this.addEntry(bench);

        logBenches = SimpleEntrySet.builder(WoodType.class, "log_bench",
                        FurnishBlocks.Oak_Log_Bench, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new LogBench(Utils.copyPropertySafe(w.log))
                )
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_log_bench"))
                .addTexture(modRes("block/oak_log_bench_top"))
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .build();
        this.addEntry(logBenches);

        ladder = SimpleEntrySet.builder(WoodType.class, "ladder",
                        FurnishBlocks.Oak_Ladder, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Ladder(Utils.copyPropertySafe(w.log))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/oak_ladder"))
                .setTabKey(tab)
                .build();
        this.addEntry(ladder);

        coffin = SimpleEntrySet.builder(WoodType.class, "coffin",
                        FurnishBlocks.Jungle_Coffin, () -> WoodTypeRegistry.getValue(new ResourceLocation("jungle")),
                        w -> new Coffin(Utils.copyPropertySafe(w.planks))
                )
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addRecipe(modRes("furniture_making/jungle_coffin"))
                .addTexture(modRes("block/jungle_coffin_sides"))
                .setTabKey(tab)
                .build();
        this.addEntry(coffin);

        bookshelfChest = SimpleEntrySet.builder(WoodType.class, "bookshelf_chest",
                        FurnishBlocks.Dark_Oak_Bookshelf_Chest, () -> WoodTypeRegistry.getValue(new ResourceLocation("dark_oak")),
                        w -> new BookshelfChest(Utils.copyPropertySafe(w.planks).pushReaction(PushReaction.BLOCK))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("bookshelf_chest"), class_7924.field_41254)
                .addTag(modRes("wooden_furniture"), class_7924.field_41254)
                .addTag(modRes("wooden_furniture"), class_7924.field_41197)
                .addTag(modRes("bookshelf_chests"), class_7924.field_41197)
                .addRecipe(modRes("furniture_making/dark_oak_bookshelf_chest"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf_chest_empty"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf_chest_plenty"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTextureM(modRes("block/bookshelf/dark_oak_bookshelf_chest_sparse"),
                        EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))
                .addTile(FurnishRegistries.BookshelfChest_BlockEntity)
                .setTabKey(tab)
                .build();
        this.addEntry(bookshelfChest);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, handler) -> {

            for (var w : WoodTypeRegistry.getTypes()) {
                boolean hasSomething = false;
                SimpleTagBuilder itemTag = SimpleTagBuilder.of(modRes(w.getTypeName() + "_" + "furniture"));

                for (var entry : this.getEntries()) {
                    class_1792 b = ((SimpleEntrySet<?, ?>) entry).items.get(w);
                    if (b != null) {
                        hasSomething = true;
                        itemTag.addEntry(b);
                    }
                }
                if (hasSomething) {
                    handler.addTag(itemTag, class_7924.field_41197);
                    handler.addTag(itemTag, class_7924.field_41254);
                }
            }
        });
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, handler) -> {
            logBenches.blocks.forEach((w, block) -> {
                var id = Utils.getID(block);

                try (TextureImage topTexture = TextureImage.open(manager,
                        RPUtils.findFirstBlockTextureLocation(manager, w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE))) {

                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace("block/oak_log_bench_top", w, id, "oak");

                    var newTexture = topTexture.makeCopy();

                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);

                    var newTop = topTexture.makeCopy();
                    createTopTexture(topTexture, newTop);

                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);

                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate Log Bench block texture for for {} : {}", block, e);

                }

            });
            coffin.blocks.forEach((w, block) -> {
                var id = Utils.getID(block);

                try (TextureImage topTexture = TextureImage.open(manager,
                        RPUtils.findFirstBlockTextureLocation(manager, w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE))) {

                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace("block/jungle_coffin_sides", w, id, "jungle");

                    var newTexture = topTexture.makeCopy();

                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);

                    var newTop = topTexture.makeCopy();
                    createTopTexture(topTexture, newTop);

                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);

                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate coffin block texture for for {} : {}", block, e);

                }

            });
        });
    }

    private void createTopTexture(TextureImage original, TextureImage newImage) {
        original.forEachFramePixel((i, x, y) -> {
            int localX = x - original.getFrameStartX(i);
            int localY = y - original.getFrameStartY(i);
            if (localX >= 5 && localX <= 10 && localY >= 5 && localY <= 10) {
                newImage.getImage().method_4305(x - 3, y - 3, original.getImage().method_4315(x, y));
            } else if (localX >= 10 && localY > 0 && localY <= 7) {
                newImage.getImage().method_4305(x - 6, y, original.getImage().method_4315(x, y));
                newImage.getImage().method_4305(x, y, 0);
            } else if (localY >= 10 && localX > 0 && localX <= 7) {
                newImage.getImage().method_4305(x, y - 6, original.getImage().method_4315(x, y));
                newImage.getImage().method_4305(x, y, 0);
            } else if (localX >= 10 && localY >= 10) {
                newImage.getImage().method_4305(x - 6, y - 6, original.getImage().method_4315(x, y));
            } else if (localX >= 10 || localY >= 10) {
                newImage.getImage().method_4305(x, y, 0);
            }
        });
    }

    //!! RECIPES
    public static class FurnishFinishedRecipe implements class_2444 {
        protected final class_1856 ingredient;
        protected final class_1799 result;
        protected final class_2960 id;
        protected final String group;
        private final class_161.class_162 advancement;
        protected final class_2960 advancementId;


        public FurnishFinishedRecipe(
                class_2960 resourceLocation,
                String group,
                class_1856 ingredient,
                class_1799 result, class_161.class_162 advancement, class_2960 advancementId
        ) {
            this.id = resourceLocation;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }


        public void method_10416(@NotNull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("id", this.id.toString());

            json.add("ingredient", ingredient.method_8089());

            json.addProperty("result", Utils.getID(result.method_7909()).toString());
            json.addProperty("count", result.method_7947());
        }

        @Override
        public @NotNull class_2960 method_10417() {
            return id;
        }

        @Override
        public @NotNull class_1865<?> method_17800() {
            return FurnishRegistries.Furniture_Recipe_Serializer.get();
        }

        @Nullable
        @Override
        public JsonObject method_10415() {
            return advancement.method_698();
        }

        @Nullable
        @Override
        public class_2960 method_10418() {
            return advancementId;
        }
    }

    public class FurnishRecipeTemplate implements IRecipeTemplate<FurnishFinishedRecipe> {

        private final List<Object> conditions = new ArrayList<>();

        public final class_1799 result;
        public final String group;
        public final class_1856 ingredient;

        public FurnishRecipeTemplate(JsonObject json) {
            var g = json.get("group");
            this.group = g == null ? "" : g.getAsString();

            this.ingredient = class_1856.method_52177(json.get("ingredient"));
            String s1 = class_3518.method_15265(json, "result");
            int i = class_3518.method_15260(json, "count");
            this.result = new class_1799(class_7923.field_41178.method_10223(new class_2960(s1)), i);
        }

        @Override
        public <T extends BlockType> FurnishFinishedRecipe createSimilar(
                T originalMat, T destinationMat, class_1792 unlockItem, String id) {
            class_1935 newRes = BlockType.changeItemType(this.result.method_7909(), originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                        this.result, originalMat, destinationMat));
            }
            class_1799 newResult = new class_1799(newRes);
            if (this.result.method_7985()) newResult.method_7980(this.result.method_7948().method_10553());
            if (id == null) id = class_7923.field_41178.method_10221(newRes.method_8389()).toString();

            class_1856 newIng = ResourcesUtils.convertIngredient(this.ingredient, originalMat, destinationMat);

            class_161.class_162 advancement = class_161.class_162.method_707();

            advancement.method_709("has_planks", class_2066.class_2068.method_8959(unlockItem));
            var res = new class_2960(id);
            return new FurnishFinishedRecipe(res, group, newIng, newResult, advancement,
                    modRes("recipes/" + "furnish" + "/" + res.method_12832()));
        }

        @Override
        public void addCondition(Object condition) {
            this.conditions.add(condition);
        }

        @Override
        public List<Object> getConditions() {
            return conditions;
        }
    }
}
