package net.mehvahdjukaar.every_compat.modules.valhelsia_furniture;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.valhelsia.valhelsia_furniture.common.block.*;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlockEntities;
import net.valhelsia.valhelsia_furniture.core.registry.ModTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Consumer;

//SUPPORT: v1.1.3+
public class ValhelsiaFurnitureModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, TableBlock> tables;
    public final SimpleEntrySet<WoodType, ChairBlock> chairs;
    public final SimpleEntrySet<WoodType, ChairBlock> hay_chairs;
    public final SimpleEntrySet<WoodType, StoolBlock> stools;
    public final SimpleEntrySet<WoodType, DeskBlock> desks;
    public final SimpleEntrySet<WoodType, DeskDrawerBlock> desk_drawers;

    public ValhelsiaFurnitureModule(String modId) {
        super(modId, "vf");
        var tab = modRes("main");

        tables = SimpleEntrySet.builder(WoodType.class, "table",
                        getModBlock("oak_table", TableBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new TableBlock(w.toVanillaOrOak(), Utils.copyPropertySafe(w.planks))
                )
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/table/oak/oak_table"))
                //TEXTURES: oak_table_connected is via desk_drawers' EntrySet
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModTags.Blocks.TABLES, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(tables);

        chairs = SimpleEntrySet.builder(WoodType.class, "chair",
                        getModBlock("oak_chair", ChairBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new CompatChairBlock(w.toVanillaOrOak(), Utils.copyPropertySafe(w.planks), false)
                )
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/chair/oak/oak_chair"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModTags.Blocks.CHAIRS, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(chairs);

        hay_chairs = SimpleEntrySet.builder(WoodType.class, "chair", "hay",
                        getModBlock("hay_oak_chair", ChairBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new CompatChairBlock(w.toVanillaOrOak(), Utils.copyPropertySafe(w.planks), true)
                )
                .setRenderType(RenderLayer.CUTOUT)
                .addTextureM(modRes("block/chair/oak/hay_oak_chair"),
                        EveryCompat.res("block/vf/hay_oak_chair_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModTags.Blocks.CHAIRS, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(hay_chairs);

        stools = SimpleEntrySet.builder(WoodType.class, "stool",
                        getModBlock("oak_stool", StoolBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new StoolBlock(w.toVanillaOrOak(), Utils.copyPropertySafe(w.planks))
                )
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/stool/oak_stool"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModTags.Blocks.STOOLS, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(stools);

        desks = SimpleEntrySet.builder(WoodType.class, "desk",
                        getModBlock("oak_desk", DeskBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new DeskBlock(w.toVanillaOrOak(), modTag(w.getAppendableId() + "_desks"), Utils.copyPropertySafe(w.planks))
                )
                .addTextureM(modRes("block/desk/oak/front"),
                        EveryCompat.res("block/vf/desk_front_m"))
                .addTexture(modRes("block/desk/oak/middle"))
                .addTexture(modRes("block/desk/oak/side"))
                .addTexture(modRes("block/desk/oak/top"))
                .addTexture(modRes("block/desk/oak/top_middle"))
                .addTexture(modRes("block/desk/oak/top_side"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModTags.Blocks.DESKS, class_7924.field_41254)
                .addTag(ModTags.Items.DESKS, class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(desks);

        desk_drawers = SimpleEntrySet.builder(WoodType.class, "desk_drawer",
                        getModBlock("oak_desk_drawer", DeskDrawerBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new DeskDrawerBlock(w.toVanillaOrOak(), modTag(w.getAppendableId() + "_desks"), Utils.copyPropertySafe(w.planks))
                )
                .addTile(ModBlockEntities.DESK_DRAWER)
                /*
                * Below is a bit special. has to be separated from the Table's EntrySet above. It has 5 color palettes
                * while the other texture for table is 7 color palettes. Below will only remove one darkest from
                * Planks' 7 color palettes to ensure the texture is not darkened
                */
                .createPaletteFromPlanks(p -> p.remove(p.getDarkest()))
                .addTexture(modRes("block/table/oak/oak_table_connected"))
                //TEXTURE: desks' textures
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(ModTags.Blocks.DESKS, class_7924.field_41254)
                .addTag(ModTags.Items.DESKS, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(desk_drawers);

    }

    // Tags
    private class_6862<class_2248> modTag(String name) {
        return class_6862.method_40092(class_7924.field_41254, EveryCompat.res(name));
    }


    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, sink)-> {
            createTagFor("desks", desks, desk_drawers, sink);
            createTagFor("chairs", chairs, hay_chairs, sink);
            for (var w : tables.blocks.keySet()) {
                boolean isTagFull = false;
                SimpleTagBuilder tag = SimpleTagBuilder.of(EveryCompat.res(w.getAppendableId() + "_tables"));

                class_2248 block = tables.blocks.get(w);
                if (block != null) {
                    isTagFull = true;
                    tag.addEntry(block);
                }
                if (isTagFull) {
                    sink.addTag(tag, class_7924.field_41197);
                    sink.addTag(tag, class_7924.field_41254);
                }
            }
        });
    }

    public void createTagFor(String blockType, SimpleEntrySet<?,?> firstBlock, SimpleEntrySet<?,?> secondBlock, ResourceSink handler) {
        for (var w : firstBlock.blocks.keySet()) {
            boolean isTagFull = false;
            SimpleTagBuilder tag = SimpleTagBuilder.of(EveryCompat.res(w.getAppendableId() + "_" + blockType));
            class_2248 firstB = firstBlock.blocks.get(w);
            class_2248 secondB = secondBlock.blocks.get(w);

            if (firstB != null) {
                isTagFull = true;
                tag.addEntry(firstB);
            }
            if (secondB != null) {
                isTagFull = true;
                tag.addEntry(secondB);
            }
            if (isTagFull) {
                handler.addTag(tag, class_7924.field_41197);
                handler.addTag(tag, class_7924.field_41254);
            }
        }
    }

    // Had to create this because of appendHoverText, "Hay Seat" is showing up on both chairs & hay_chairs
    // chairs shouldn't have "Hay Seat"
    public static class CompatChairBlock extends ChairBlock {
        private final boolean isHayCHair;

        public CompatChairBlock(net.minecraft.class_4719 woodType, Properties properties, boolean isHayCHair) {
            super(woodType, properties);
            this.isHayCHair = isHayCHair;
        }

        @Override
        public void appendHoverText(@NotNull class_1799 stack, @Nullable class_1922 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
            if (isHayCHair) {
                tooltip.add(class_2561.method_43471("tooltip.valhelsia_furniture.hay_seat").method_27692(class_124.field_1080));
            }

        }
    }
}