/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.configs;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;

public class ECConfigs {
    public static ModConfigHolder SPEC;
    public static ModConfigHolder CLIENT_SPEC;
    public static final Supplier<Boolean> TAB_ENABLED;
    public static final Supplier<Boolean> TAB_ITEM_SEARCH_ENABLED;
    public static final Supplier<Boolean> NO_MOD_CREATIVE_TAB;
    public static final Supplier<Boolean> CHECK_PACKET;
    public static final Supplier<Boolean> DEBUG_PACKET;
    public static final Supplier<Boolean> BLOCK_TYPE_TOOLTIP;
    public static final Supplier<Boolean> MOD_TOOPTIP;
    public static final Supplier<Boolean> TOOLTIPS_ADVANCED;
    public static final Supplier<GenMode> SERVER_GENERATION_MODE;
    public static final Supplier<GenMode> CLIENT_GENERATION_MODE;
    public static final Supplier<Boolean> GENERATE_BLOCKTYPE_TAGS;

    public static void init() {
    }

    static {
        ConfigBuilder builder;
        if (PlatHelper.getPhysicalSide().isClient()) {
            builder = ConfigBuilder.create((String)"everycomp", (ConfigType)ConfigType.CLIENT);
            builder.push("general");
            CLIENT_GENERATION_MODE = builder.comment("\nHow dynamic assets are generated. If cached the cache will regenerate once any mod or pack changes\n- NEVER: This mod will never attempt to generate the cache folder. The assets will be put in memory\n- RUN_ONCE: Will generate once & the assets will be stored in memory every time you launched.\n- CACHED: create a CACHE folder via .minecraft/dynamic-resource-pack-cache\n- CACHED_ZIPPED: create a ZIP folder via .minecraft/dynamic-resource-pack-cache\n- ALWAYS: Will always generate the assets & will be stored in memory. There will be no cache folder").define("dynamic_assets_generation_mode", (Enum)GenMode.ALWAYS);
            builder.pop();
            CLIENT_SPEC = builder.build();
            CLIENT_SPEC.forceLoad();
        } else {
            CLIENT_GENERATION_MODE = () -> GenMode.ALWAYS;
        }
        builder = ConfigBuilder.create((String)"everycomp", (ConfigType)ConfigType.COMMON);
        builder.push("general");
        SERVER_GENERATION_MODE = builder.comment("\nHow dynamic assets are generated.\n- NEVER: No asset will be generated. Use this if you have an external pack that adds assets for the block, otherwise you'll get missing assets everywhere\n- RUN_ONCE: Assets will be generated once every session. Subsequent reloads of resource/data pack will not regenerate them even if assets might have changed as a consequence\n- CACHED: Generate the assets on first boot and saves them to a cache folder in .minecraft/dynamic-data-pack-cache. If mods or packs change it will regenerate the cache. If not, subsequent reload won't generate anything and just read the cached ones as a normal pack.\n- CACHED_ZIPPED: Generate the assets on first boot and saves them to a cache zip file in .minecraft/dynamic-data-pack-cache. If mods or packs change it will regenerate the cache. If not, subsequent reload won't generate anything and just read the cached ones as a normal pack.\n- ALWAYS: Will always generate the assets & will be stored in memory. No cache is used. Unintuitively, this is often the fastest method as any disk access will be slow. \nTry and see what works best for you.").worldReload().define("server_assets_generation_mode", (Enum)GenMode.ALWAYS);
        TAB_ENABLED = builder.comment("Puts all the added items into a new Every Compat tab instead of their own mod tabs. Be warned that if disabled it could cause some issue with some mods that have custom tabs").gameRestart().define("creative_tab", true);
        TAB_ITEM_SEARCH_ENABLED = builder.comment("Allow the item_search or searchBar to be visible.").gameRestart().define("tab_item_search", true);
        NO_MOD_CREATIVE_TAB = builder.comment("If set to true, then all of the generated items will not be put into the mod's tab.").gameRestart().define("no_mod_creative_tab", false);
        GENERATE_BLOCKTYPE_TAGS = builder.comment("Generate blocktype tags for every block type. This will be applied to StoneZone & GemsRealm, too. Useful for datapack makers & Iris since v1.8 that can use tags for shaders.").gameRestart().define("generate_blocktype_tags", true);
        CHECK_PACKET = builder.comment("Sends a packet to verify all dependencies mod versions are the same on connect. DIsable if it causes issues").define("mod_version_check_packet", true);
        DEBUG_PACKET = builder.comment("Don't touch unless you are told to").define("debug_packet", false);
        builder.push("tooltips");
        MOD_TOOPTIP = builder.comment("Enabled tooltips showing which mod an EC item is from").define("mod_origin_enabled", true);
        BLOCK_TYPE_TOOLTIP = builder.comment("Enabled tooltips showing which block type an EC item is made from").define("block_type_enabled", true);
        TOOLTIPS_ADVANCED = builder.comment("Only show on advanced settings").define("show_on_advanced_tooltips", false);
        builder.pop();
        SPEC = builder.build();
        SPEC.forceLoad();
    }

    public static enum GenMode {
        NEVER,
        RUN_ONCE,
        CACHED,
        CACHED_ZIPPED,
        ALWAYS;


        public PackGenerationStrategy pickStrategy() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PackGenerationStrategy.NO_OP;
                case 1 -> PackGenerationStrategy.runOnce();
                case 2 -> PackGenerationStrategy.CACHED;
                case 3 -> PackGenerationStrategy.CACHED_ZIPPED;
                case 4 -> PackGenerationStrategy.REGEN_ON_EVERY_RELOAD;
            };
        }
    }
}

