package net.mehvahdjukaar.every_compat;

import io.netty.buffer.Unpooled;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

public class ECNetworking {

    public static void init() {
        NetworkHelper.addNetworkRegistration(ECNetworking::registerMessages, 3);
    }

    private static void registerMessages(NetworkHelper.RegisterMessagesEvent event) {
        event.registerBidirectional(S2CModVersionCheckMessage.CODEC);
        event.registerClientBound(S2CBlockStateCheckMessage.CODEC);
    }


    public static class S2CModVersionCheckMessage implements Message {

        public static final class_9155<class_9129, S2CModVersionCheckMessage> CODEC = Message.makeType(
                EveryCompat.res("mod_version_check"), S2CModVersionCheckMessage::new);

        private final Map<String, String> mods = new HashMap<>();

        public S2CModVersionCheckMessage() {
            for (var m : EveryCompat.getDependencies()) {
                var v = PlatHelper.getModVersion(m);
                if (v != null) {
                    mods.put(m, v);
                }
            }
        }

        public S2CModVersionCheckMessage(class_9129 buf) {
            this.mods.putAll(buf.method_34067(buf1 -> buf.method_19772(), buf1 -> buf.method_19772()));
        }

        @Override
        public void write(class_9129 buf) {
            buf.method_34063(mods, (buf1, s) -> buf.method_10814(s), (buf1, s) -> buf.method_10814(s));
        }

        @Override
        public void handle(Context context) {
            for (var m : mods.entrySet()) {
                String clientVersion = PlatHelper.getModVersion(m.getKey());
                String serverVersion = m.getValue();
                if (!Objects.equals(serverVersion, clientVersion)) {
                    context.disconnect(class_2561.method_43470("EveryCompat has detected that server has mismatched mod versions for mod " +
                            m.getKey() + ": requested version " + serverVersion + ", actual version " + clientVersion));
                }
            }
        }

        @Override
        public class_9154<? extends class_8710> method_56479() {
            return CODEC.comp_2243();
        }
    }

    public static class S2CBlockStateCheckMessage implements Message {

        public static final class_9155<class_9129, S2CBlockStateCheckMessage> CODEC = Message.makeType(
                EveryCompat.res("blockstate_check"), S2CBlockStateCheckMessage::new);

        public S2CBlockStateCheckMessage(class_9129 buf) {
            int start = buf.method_10816();
            int size = buf.method_10816();

            boolean mismatched = false;
            for (int i = start; i < (start + size); i++) {
                try {
                    var nbt = buf.method_10798();
                    if (nbt == null) {
                        int aa = 1;
                    }
                    var b = Utils.readBlockState(nbt, null);
                    class_2680 exp = class_2248.field_10651.method_10200(i);
                    if (b != exp) {
                        if (!mismatched) {
                            EveryCompat.LOGGER.error("Found blockstate id mismatch from {}at id {}. Was expecting: {}", b, i, exp);
                        }
                        mismatched = true;
                    } else {
                        if (mismatched) {
                            EveryCompat.LOGGER.error("to{}at id {}", b, i);
                        }
                        mismatched = false;
                    }
                } catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read blockstate in id map: ", e);
                    break;
                }
            }
            buf.release();
        }

        public S2CBlockStateCheckMessage() {
        }

        @Override
        public void write(class_9129 buf) {
            class_2540 dummy = new class_2540(Unpooled.buffer());
            int start = lastInd;
            for (int i = lastInd; i < class_2248.field_10651.method_10204(); i++) {
                lastInd++;
                class_2487 nbt = class_2512.method_10686(class_2248.method_9531(i));
                dummy.method_10794(nbt);
                if (dummy.writerIndex() > 1048576 * 0.9) {
                    break;
                }
            }
            buf.method_10804(start);
            buf.method_10804(lastInd - start);
            buf.method_52975(dummy);
            dummy.release();
        }

        @Override
        public void handle(Context context) {

        }

        @Override
        public class_9154<? extends class_8710> method_56479() {
            return CODEC.comp_2243();
        }
    }


    private static int lastInd = 0;

    public static void sendPacket(class_3222 s) {
        if (ECConfigs.DEBUG_PACKET.get() || PlatHelper.isDev()) {
            lastInd = 0;
            EveryCompat.LOGGER.warn("Starting Blockstate Map validity check:");
            while (lastInd < class_2248.field_10651.method_10204()) {
                NetworkHelper.sendToClientPlayer(s, new S2CBlockStateCheckMessage());
            }
        }
    }

}
