package net.mehvahdjukaar.every_compat.modules.quark;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.ECPlatformStuff;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.*;
import net.mehvahdjukaar.every_compat.common_classes.*;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.modules.botanypots.BotanyPotsHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_3962;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.violetmoon.quark.content.building.block.*;
import org.violetmoon.quark.content.building.module.*;
import org.violetmoon.zeta.block.ZetaBlock;

import java.util.Objects;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.api.PaletteStrategies.registerCached;
import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;
import static net.mehvahdjukaar.every_compat.misc.UtilityTag.getATagOrCreateANew;
import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.*;

//SUPPORT: v4.0-435+
public class QuarkModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> verticalSlabs;
    public final SimpleEntrySet<WoodType, class_2248> bookshelves;
    public final SimpleEntrySet<WoodType, class_2248> posts;
    public final SimpleEntrySet<WoodType, class_2248> strippedPosts;
    public final SimpleEntrySet<WoodType, class_2248> verticalPlanks;
    public final SimpleEntrySet<WoodType, class_2248> ladders;
    public final SimpleEntrySet<WoodType, class_2248> hollowLogs;
    public final SimpleEntrySet<WoodType, class_2248> chests;
    public final SimpleEntrySet<WoodType, class_2248> trappedChests;
    public final SimpleEntrySet<LeavesType, class_2248> hedges;
    public final SimpleEntrySet<LeavesType, class_2248> leafCarpets;

    public QuarkModule(String modId) {
        super(modId, "q", EveryCompat.MOD_ID);
        class_5321<class_1761> tab = class_7706.field_40195;

        verticalSlabs = QuarkSimpleEntrySet.builder(WoodType.class, "vertical_slab",
                        VerticalSlabsModule.class,
                        getModBlock("oak_vertical_slab"), () -> VanillaWoodTypes.OAK,
                        w -> new VerticalSlabBlock(() -> w.getBlockOfThis(SLAB),
                                Utils.copyPropertySafe(Objects.requireNonNull(w.getBlockOfThis(SLAB)))
                                        .method_9626(w.getSound())
                        )
                )
                .requiresChildren(SLAB)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_vertical_slabs"), class_7924.field_41254, class_7924.field_41197)
                .addTag(modRes("vertical_slabs"), class_7924.field_41254, class_7924.field_41197)
                .addTag(modRes("vertical_slab"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/crafting/vertslabs/oak_vertical_slab"))
                //RECIPES: See addDynamicServerResources for oak_vertical_slab_revert
                .addCondition(woodType -> !PlatHelper.isModLoaded("v_slab_compat"))
                .copyParentDrop()
                .build();
        this.addEntry(verticalSlabs);

        bookshelves = QuarkSimpleEntrySet.builder(WoodType.class, "bookshelf",
                        VariantBookshelvesModule.class,
                        getModBlock("acacia_bookshelf"),
                        () -> VanillaWoodTypes.ACACIA,
                        w -> new VariantBookshelfBlock(shortenedId() + "/" + w.getAppendableId(),
                                null, w.canBurn(), w.getSound())
                )
                .addTextureM(EveryCompat.res("block/acacia_bookshelf"),
                        EveryCompat.res("block/acacia_bookshelf_m"),
                        bookshelfPalette)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_2960.method_60654("c:bookshelves"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/crafting/bookshelves/acacia_bookshelf"))
                .copyParentDrop()
                .build();
        this.addEntry(bookshelves);

        posts = QuarkSimpleEntrySet.builder(WoodType.class, "post",
                        WoodenPostsModule.class,
                        getModBlock("oak_post"), () -> VanillaWoodTypes.OAK,
                        w -> {
                            class_2248 fence = w.getBlockOfThis("fence");
                            return new WoodPostBlock(null, Objects.requireNonNull(fence),
                                    shortenedId() + "/" + w.getNamespace() + "/",
                                    Objects.requireNonNull(fence).method_9564().method_26231());
                        })
                .requiresChildren(FENCE, WOOD) //REASON: recipes
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("posts"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/crafting/posts/oak_post"))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(posts);

        strippedPosts = QuarkSimpleEntrySet.builder(WoodType.class, "post", "stripped",
                        WoodenPostsModule.class,
                        getModBlock("stripped_oak_post"), () -> VanillaWoodTypes.OAK,
                        w -> {
                            if (w.getNamespace().equals("malum") || w.getNamespace().equals("twigs")) return null;
                            class_2248 fence = w.getBlockOfThis("fence");
                            // required stripped_log texture & fence as an ingredients
                            return new WoodPostBlock(null, Objects.requireNonNull(fence),
                                    shortenedId() + "/" + w.getNamespace() + "/stripped_",
                                    Objects.requireNonNull(fence).method_9564().method_26231());
                        })
                .requiresChildren("fence", "stripped_log", "stripped_wood") //REASON: textures, recipes
                //TEXTURES: stripped_log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("posts"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/crafting/posts/stripped_oak_post"))
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(strippedPosts);

        verticalPlanks = QuarkSimpleEntrySet.builder(WoodType.class, "planks", "vertical",
                        VerticalPlanksModule.class,
                        getModBlock("vertical_oak_planks"), () -> VanillaWoodTypes.OAK,
                        w -> {
                            String name = shortenedId() + "/" + w.getVariantId("planks", "vertical");
                            return new ZetaBlock(name, null,
                                    class_4970.class_2251.method_9637()
                                            .method_31710(class_3620.field_15996)
                                            .method_50013()
                                            .method_51368(class_2766.field_12651)
                                            .method_9629(2.0F, 3.0F)
                                            .method_9626(class_2498.field_11547)
                            );
                        }
                )
                .addCondition(w -> !w.getId().toString().equals("gardens_of_the_dead:whistle_planks")) //REASON: The look is no different from a normal plank
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15471, class_7924.field_41254, class_7924.field_41197)
                .addRecipe(modRes("building/crafting/vertplanks/vertical_oak_planks"))
                .build();
        this.addEntry(verticalPlanks);

        ladders = QuarkSimpleEntrySet.builder(WoodType.class, "ladder",
                        VariantLaddersModule.class,
                        getModBlock("spruce_ladder"),
                        () -> VanillaWoodTypes.SPRUCE,
                        w -> new VariantLadderBlock(shortenedId() + "/" + w.getAppendableId(),
                                null, Utils.copyPropertySafe(class_2246.field_9983).method_9626(w.getSound()), w.canBurn()))
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .addTag(modRes("ladders"), class_7924.field_41254, class_7924.field_41197)
                .addTexture(EveryCompat.res("block/spruce_ladder"))
                .addRecipe(modRes("building/crafting/ladders/spruce_ladder"))
                .setRenderType(RenderLayer.TRANSLUCENT)
                .build();
        this.addEntry(ladders);

        hollowLogs = QuarkSimpleEntrySet.builder(WoodType.class, "log", "hollow",
                        HollowLogsModule.class,
                        getModBlock("hollow_oak_log"), () -> VanillaWoodTypes.OAK,
                        w -> new HollowLogBlock(shortenedId() + "/" + w.getAppendableId(),
                                w.log, null, w.canBurn()))
                .requiresChildren("stripped_log") // Texture
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("hollow_logs"), class_7924.field_41254, class_7924.field_41197)
                .addRecipe(modRes("building/crafting/hollowlogs/hollow_oak_log"))
                .build();
        this.addEntry(hollowLogs);

        chests = QuarkSimpleEntrySet.builder(WoodType.class, "chest",
                        VariantChestsModule.class,
                        getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe(class_2246.field_10034))
                )
                .addTile(qChestBlockEntity::new)
                .addTag(class_2960.method_60654("c:chests/wooden"), class_7924.field_41254, class_7924.field_41197)
                .addTag(modRes("revertable_chests"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/chests/oak_chest"))
                .addRecipe(modRes("building/chests/oak_chest_wood"))
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .excludeBlockTypes("twilightforest", "dark")
                .build();
        this.addEntry(chests);

        trappedChests = QuarkSimpleEntrySet.builder(WoodType.class, "chest", "trapped",
                        VariantChestsModule.class,
                        getModBlock("trapped_oak_chest"), () -> VanillaWoodTypes.OAK,
                        w -> {
                            boolean isNamespaceLoaded = w.getNamespace().equals("twilightforest")
                                    || w.getNamespace().equals("blue_skies");
                            if (!chests.blocks.containsKey(w) && !isNamespaceLoaded) return null;
                            String name = shortenedId() + "/" + w.getAppendableId();
                            return new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe(class_2246.field_10380));
                        })
                .addTile(qTrappedBlockEntity::new)
                .addTag(class_2960.method_60654("forge:chests/trapped"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_2960.method_60654("forge:chests/wooden"), class_7924.field_41254, class_7924.field_41197)
                .addTag(modRes("revertable_trapped_chests"), class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/chests/trapped_oak_chest"))
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .build();
        this.addEntry(trappedChests);

        //doing it this way because for some reason its nuking whatever block item I throw in here
        hedges = QuarkSimpleEntrySet.builder(LeavesType.class, "hedge",
                        HedgesModule.class,
                        getModBlock("oak_hedge"),
                        () -> VanillaLeavesTypes.OAK,
                        leavesType -> new HedgeBlock("", null, class_2246.field_10620, leavesType.leaves)
                )
                .addCondition(l -> l.getAssociatedWoodType() != null) // Reason: RECIPES
                .addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves",
                        "leaves", CompatSpritesHelper.LOOKS_LIKE_LEAF_TEXTURE))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("hedges"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .copyParentTint()
                //RECIPES: Manually created below blc the recipe has a tag as an ingredient
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(hedges);


        //doing it this way because for some reason its nuking whatever block item I throw in here
        leafCarpets = QuarkSimpleEntrySet.builder(LeavesType.class, "leaf_carpet",
                        LeafCarpetModule.class,
                        getModBlock("oak_leaf_carpet"),
                        () -> VanillaLeavesTypes.OAK,
                        leavesType -> {
                            String name = shortenedId() + "/" + leavesType.getVariantId("%s_leaf_carpet");
                            return new LeafCarpetBlock(name, leavesType.leaves, null);
                        })
                .addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves",
                        "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))
                .addTag(class_3481.field_33714, class_7924.field_41254)
                .addTag(class_2960.method_60654("forge:mineable/sickle"), class_7924.field_41254)
                .addTag(class_2960.method_60654("mynethersdelight:resurgent_soil_plant"), class_7924.field_41254)
                .setTabKey(tab)
                .setTabMode(TabAddMode.AFTER_SAME_WOOD)
                .addRecipe(modRes("building/crafting/leafcarpet/oak_leaf_carpet"))
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .copyParentTint()
                .build();
        this.addEntry(leafCarpets);

    }

    // GetTile -----------------------------------------------------------------------------------------------------------
    private class_2591<? extends class_2595> getChestTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    private class_2591<? extends class_2595> getTrappedTile() {
        return trappedChests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity -----------------------------------------------------------------------------------------------------------
    private class qChestBlockEntity extends CompatChestBlockEntity {
        public qChestBlockEntity(class_2338 pos, class_2680 state) {
            super(chests.getTile(), pos, state);
        }
    }

    private class qTrappedBlockEntity extends CompatChestBlockEntity {
        public qTrappedBlockEntity(class_2338 pos, class_2680 state) {
            super(trappedChests.getTile(), pos, state);
        }
    }

    @Override
    public void onModSetup() {
        posts.blocks.forEach((w, post) -> {
            class_2248 stripped = strippedPosts.blocks.get(w);
            if (stripped != null) ECPlatformStuff.registerStripping(post, stripped);
        });
        leafCarpets.blocks.forEach((w, leaf) -> class_3962.field_17566.put(leaf, 0.2F));
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        CompatChestBlockRenderer.register(event, trappedChests.getTile(CompatChestBlockEntity.class), shortenedId());
    }

    public static final PaletteStrategy bookshelfPalette = registerCached((blockType, manager) ->
            PaletteStrategies.makePaletteFromChild(
                    blockType, manager, PLANKS, null,
                    p -> {
                        var l0 = p.getDarkest();
                        p.increaseDown();
                        p.increaseDown();
                        p.increaseDown();
                        p.increaseDown();
                        p.remove(l0);
                    }
            )
    );

    @Override
    // TEXTURES
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        //extra task
        executor.accept(this::generateChestTextures);
    }

    private void generateChestTextures(class_3300 manager, ResourceSink sink) {
        trappedChests.blocks.forEach((wood, block) -> {

            // SINGLE
            generateChestTexture(sink, manager, shortenedId(), wood, block,
                    modRes("quark_variant_chests/oak/normal"),
                    EveryCompat.res("model/oak_chest_normal_m"),
                    EveryCompat.res("model/oak_chest_normal_o"),
                    EveryCompat.res("model/trapped_chest_normal")
            );
            // LEFT
            generateChestTexture(sink, manager, shortenedId(), wood, block,
                    modRes("quark_variant_chests/oak/left"),
                    EveryCompat.res("model/oak_chest_left_m"),
                    EveryCompat.res("model/oak_chest_left_o"),
                    EveryCompat.res("model/trapped_chest_left")
            );
            // RIGHT
            generateChestTexture(sink, manager, shortenedId(), wood, block,
                    modRes("quark_variant_chests/oak/right"),
                    EveryCompat.res("model/oak_chest_right_m"),
                    EveryCompat.res("model/oak_chest_right_o"),
                    EveryCompat.res("model/trapped_chest_right")
            );
        });
    }

    @Override
    // RECIPES, TAGS
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            if (PlatHelper.isModLoaded("botanypots")) {
                hedges.items.forEach((leaves, item) -> {
                    var leavesItem = leaves.leaves.method_8389();
                    BotanyPotsHelper.cropQuarkHedgeRecipe(this, item, leavesItem, sink, manager, leaves);
                });
            }

            // hedge's recipe & logs' tags
            hedges.blocks.forEach((leavesType, block) -> {
                if (block != null) createHedgeRecipe(leavesType, block, sink, manager);
            });

            verticalSlabs.blocks.forEach((woodType, block) ->
                    createVertSlabRecipe(woodType, block, sink));
        });
    }

    // Hedge's recipe has a tag as an ingredient
    public void createHedgeRecipe(LeavesType leavesType, class_2248 hedge, ResourceSink sink, class_3300 manager) {

        String recipe = """
                {
                    "neoforge:conditions": [
                        {
                            "type": "zeta:flag",
                            "flag": "hedges"
                        }
                    ],
                    "type": "minecraft:crafting_shaped",
                    "pattern": [
                        "L",
                        "W"
                    ],
                    "key": {
                        "L": {
                            "item": "[LEAVES]"
                        },
                        "W": {
                            "tag": "[TAG]"
                        }
                    },
                    "result": {
                        "id": "[HEDGE]",
                        "count": 2
                    }
                }\s
                """;

        WoodType woodType = leavesType.getAssociatedWoodType();
        if (Objects.nonNull(woodType)) {
            String newTag = getATagOrCreateANew("log", "cap", woodType, sink, manager).toString();

            String newRecipe = recipe.replace("[LEAVES]", Utils.getID(leavesType.leaves).toString())
                    .replace("[TAG]", newTag)
                    .replace("[HEDGE]", Utils.getID(hedge).toString());

            // Adding the finished recipe to ResourceLocation
            sink.addBytes(EveryCompat.res(leavesType.createPathWith(shortenedId(), "hedge")),
                    newRecipe.getBytes(),
                    ResType.RECIPES);
        } else
            EveryCompat.LOGGER.error("Hedge's LeavesType do not have associated WoodType for: {}. HOW??", leavesType.getId().toString());
    }

    //REASON: vertical_slab_revert are not being generated, this will have to do for now
    public void createVertSlabRecipe(WoodType woodType, class_2248 vertSlab, ResourceSink sink) {

        String recipe = """
                {
                    "type": "minecraft:crafting_shapeless",
                    "ingredients": [
                        {
                            "item": "[VERTICAL_SLAB]"
                        }
                    ],
                    "result": {
                        "id": "[SLAB]",
                        "count": 1
                    },
                    "conditions": [
                        {
                            "type": "quark:flag",
                            "flag": "vertical_slabs"
                        }
                    ]
                }\s
                """;

        if (Objects.nonNull(woodType.getBlockOfThis(SLAB))) {
            String newRecipe = recipe
                    .replace("[SLAB]", Utils.getID(Objects.requireNonNull(woodType.getBlockOfThis(SLAB))).toString())
                    .replace("[VERTICAL_SLAB]", Utils.getID(vertSlab).toString());

            // Adding the finished recipe to ResourceLocation
            sink.addBytes(EveryCompat.res(woodType.createPathWith(shortenedId(), "vertical_slab_revert")),
                    newRecipe.getBytes(), ResType.RECIPES);
        }
        else
            EveryCompat.LOGGER.warn("Skipped generating vertical_slab_revert recipe for: {} lacking SLAB.", woodType.getId().toString());
    }

}
