/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class UtilityTexture {
    public static class_2960 modifyTexturePath(String baseTexturePath, String prefix, String shortenedId, String oldTypeName, BlockType blockType) {
        String infix = shortenedId + "/" + blockType.getNamespace() + "/";
        return EveryCompat.res(prefix + infix + baseTexturePath.substring(prefix.length()).replace(oldTypeName, blockType.getTypeName()));
    }

    public static void generateLogTexture(class_2960 baseTextureLoc, class_2960 logMaskLoc, class_2960 planksMaskLoc, String shortenedId, String oldTypeName, PaletteStrategy logPaletteStrategy, ResourceSink sink, class_3300 manager) {
        try (TextureImage baseTexture = TextureImage.open((class_3300)manager, (class_2960)baseTextureLoc);
             TextureImage logMask = TextureImage.open((class_3300)manager, (class_2960)logMaskLoc);
             TextureImage planksMask = TextureImage.open((class_3300)manager, (class_2960)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                class_2960 newResLoc = UtilityTexture.modifyTexturePath(baseTextureLoc.method_12832(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newResLoc, () -> {
                    try {
                        PaletteStrategy.PaletteAndAnimation logPalette = logPaletteStrategy.getPaletteAndAnimation((BlockType)woodType, manager);
                        PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_STANDARD.getPaletteAndAnimation((BlockType)woodType, manager);
                        Respriter planksResprite = Respriter.masked((TextureImage)baseTexture, (TextureImage)logMask);
                        TextureImage recoloredInner = planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                        Respriter logResprite = Respriter.masked((TextureImage)recoloredInner, (TextureImage)planksMask);
                        return logResprite.recolorWithAnimation(logPalette.palette(), logPalette.animation());
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate log texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                        return baseTexture;
                    }
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate log texture: ", (Throwable)e);
        }
    }

    public static void applyLogAndswapPlanksTexture(class_2960 baseTextureLoc, class_2960 logMaskLoc, class_2960 planksMaskLoc, String shortenedId, String oldTypeName, ResourceSink sink, class_3300 manager) {
        try (TextureImage baseTexture = TextureImage.open((class_3300)manager, (class_2960)baseTextureLoc);
             TextureImage logMask = TextureImage.open((class_3300)manager, (class_2960)logMaskLoc);
             TextureImage planksMask = TextureImage.open((class_3300)manager, (class_2960)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                class_2960 newPath = UtilityTexture.modifyTexturePath(baseTextureLoc.method_12832(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                try {
                    TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                    try {
                        PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_REMOVE_DARKEST.getPaletteAndAnimation((BlockType)woodType, manager);
                        TextureOps.applyMask((TextureImage)logTexture, (TextureImage)planksMask);
                        TextureOps.applyOverlay((TextureImage)baseTexture, (TextureImage[])new TextureImage[]{logTexture});
                        sink.addTextureIfNotPresent(manager, newPath, () -> {
                            Respriter planksResprite = Respriter.masked((TextureImage)baseTexture, (TextureImage)logMask);
                            return planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                        });
                    }
                    finally {
                        if (logTexture == null) continue;
                        logTexture.close();
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to apply overlays & generate texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate texture with logOverlay & planks' palettes: ", (Throwable)e);
        }
    }

    public static void applyLogAndGenerateTexture(class_2960 baseTextureLoc, class_2960 maskLoc, String shortenedId, String oldTypeName, ResourceSink sink, class_3300 manager) {
        try (TextureImage baseTexture = TextureImage.open((class_3300)manager, (class_2960)baseTextureLoc);
             TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)maskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                class_2960 newResLoc = UtilityTexture.modifyTexturePath(baseTextureLoc.method_12832(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                try {
                    TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                    try {
                        TextureImage mainTexture = baseTexture.makeCopy();
                        TextureImage logOverlay = logTexture.makeCopy();
                        TextureOps.applyMask((TextureImage)logOverlay, (TextureImage)mask);
                        TextureOps.applyOverlay((TextureImage)mainTexture, (TextureImage[])new TextureImage[]{logOverlay});
                        sink.addTextureIfNotPresent(manager, newResLoc, () -> mainTexture);
                        mainTexture.close();
                        logOverlay.close();
                    }
                    finally {
                        if (logTexture == null) continue;
                        logTexture.close();
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to apply overlays to texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate texture with logOverlay: ", (Throwable)e);
        }
    }
}

