package net.mehvahdjukaar.every_compat.misc;

import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import java.util.Map;
import java.util.Objects;

@SuppressWarnings("unused")
public class UtilityMisc {

    public static boolean doChildrenExistFor(BlockType blockType, String... blockTypes) {
        for (String type : blockTypes) {
            if (Objects.isNull(blockType.getBlockOfThis(type))) return false;
        }
        return true;
    }

    public static boolean doChildrenExistFor(BlockType blockType, SimpleEntrySet<?, ?> entrySet) {
            return Objects.nonNull(entrySet.blocks.get(blockType));
    }

    public static class_4970.class_2251 copyChildrenPropertySafe(String childType, BlockType blockType) {
        class_2248 block = blockType.getBlockOfThis(childType);
        class_2248 blockAlt = null;
        if (childType.contains("_")) {
            String[] split = childType.split("_");
            blockAlt = blockType.getBlockOfThis(split[split.length - 1]);
        }

        if (Objects.nonNull(block)) return Utils.copyPropertySafe(block);
        else if (Objects.nonNull(blockAlt)) return Utils.copyPropertySafe(blockAlt);
        else return Utils.copyPropertySafe((class_2248) blockType.mainChild());
    }

    /**
     * @param types stairs, slab, or other blockTypes can be used
     * @param blockType WoodType, LeavesType, or StoneType
     */
    public static class_2680 copyBlockStateSafe(String types, BlockType blockType) {
        class_2248 block = blockType.getBlockOfThis(types);
        class_2248 blockAlt = null;
        if (types.contains("_")) {
            String[] split = types.split("_");
            blockAlt = blockType.getBlockOfThis(split[1]);
        }

        if (Objects.nonNull(block)) return block.method_9564();
        else if (Objects.nonNull(blockAlt)) return blockAlt.method_9564();
        else return ((class_2248) blockType.mainChild()).method_9564();
    }

    /**
     * @param blocks SimpleEntrySet.blocks
     * @param blockType WoodType, LeavesType, or StoneType
     */
    public static class_2680 copyBlockStateSafe(Map<?, class_2248> blocks, BlockType blockType) {
        if (Objects.nonNull(blocks.get(blockType))) return blocks.get(blockType).method_9564();
        else return ((class_2248) blockType.mainChild()).method_9564();
    }

}
