package net.mehvahdjukaar.every_compat.modules.fabric.exlines;

import com.exline.exlineawnings.ExlineAwningsMain;
import com.exline.exlineawnings.block.AwningBlock;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3620;

//SUPPORT: v1.1.8+
public class AwningModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, AwningBlock> awnings;
    public final SimpleEntrySet<WoodType, AwningBlock> awnings_log;

    @SuppressWarnings("DataFlowIssue")
    public AwningModule(String modId) {
        super(modId, "ea");

        awnings = SimpleEntrySet.builder(WoodType.class, "awning",
                        getModBlock("oak_awning", AwningBlock.class), () -> VanillaWoodTypes.OAK,
                        w -> new AwningBlock(w.getBlockOfThis("stairs").method_9564(),
                                FabricBlockSettings.create()
                                        .method_31710(class_3620.field_16022)
                                        .method_9629(1.0F, 0.1F)
                                        .nonOpaque()
                                        .blockVision(AwningModule::never)
                        )
                )
                //TEXTURE: using planks
                .requiresChildren("stairs")
                .setTabKey(ExlineAwningsMain.FURNITURE_GROUP)
                .addRecipe(modRes("oak_awning_recipe"))
                .build();
        this.addEntry(awnings);

        awnings_log = SimpleEntrySet.builder(WoodType.class, "log_awning",
                        getModBlock("oak_log_awning", AwningBlock.class), () -> VanillaWoodTypes.OAK,
                        w -> new AwningBlock(w.getBlockOfThis("stairs").method_9564(),
                                FabricBlockSettings.create()
                                        .method_31710(class_3620.field_16022)
                                        .method_9629(1.0F, 0.1F)
                                        .nonOpaque()
                                        .blockVision(AwningModule::never)
                        )
                )
                //TEXTURE: using logs
                .requiresChildren("stairs")
                //REASON:  Take a look @ Terrestria's logs' non-standard 16x16 texture, you'll get why
                //EXCLUDED: sakura
                .addCondition(w -> !w.getId().toString().equals("terrestria:sakura"))
                .setTabKey(ExlineAwningsMain.FURNITURE_GROUP)
                .addRecipe(modRes("oak_log_awning_recipe"))
                .build();
        this.addEntry(awnings_log);


    }

    private static boolean never(class_2680 state, class_1922 blockView, class_2338 blockPos) {
        return false;
    }
}